/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.utils;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class PatternContainerControl {
    private static final Map<String, IItemHandler> containerHandlers = new HashMap<String, IItemHandler>();

    public static void putHandler(String containerId, IItemHandler handler) {
        containerHandlers.put(containerId, handler);
    }

    public static ItemStack insertPattern(String containerId, int slot, ItemStack stack) {
        IItemHandler handler = containerHandlers.get(containerId);
        if (handler != null) {
            return handler.insertItem(slot, stack, false);
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack insertPattern(long containerId, int slot, ItemStack stack) {
        return PatternContainerControl.insertPattern(Long.toString(containerId), slot, stack);
    }

    public static void addPattern(String containerId, ItemStack stack) {
        IItemHandler handler = containerHandlers.get(containerId);
        if (handler != null) {
            for (int i = 0; i < handler.getSlots(); ++i) {
                if (!handler.insertItem(i, stack, true).func_190926_b()) continue;
                handler.insertItem(i, stack, false);
                break;
            }
        }
    }

    public static void addPattern(long containerId, ItemStack stack) {
        PatternContainerControl.addPattern(Long.toString(containerId), stack);
    }

    public static ItemStack extractPattern(String containerId, int slot) {
        IItemHandler handler = containerHandlers.get(containerId);
        if (handler != null) {
            return handler.extractItem(slot, 1, false);
        }
        return ItemStack.field_190927_a;
    }
}

