/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.utils;

import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.client.me.ItemRepo;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import mezz.jei.api.gui.IGuiIngredient;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public final class ItemUtils {
    public static boolean matches(ItemStack stack1, ItemStack stack2) {
        if (stack1 == null || stack2 == null) {
            return false;
        }
        return ItemStack.func_179545_c((ItemStack)stack1, (ItemStack)stack2) && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public static boolean contains(ItemStack based, ItemStack stack) {
        if (based == null || stack == null) {
            return false;
        }
        if (ItemStack.func_179545_c((ItemStack)based, (ItemStack)stack)) {
            if (based.func_77978_p() == null && stack.func_77978_p() == null) {
                return based.areCapsCompatible(stack);
            }
            if (based.func_77978_p() == null) {
                return based.areCapsCompatible(stack);
            }
            if (stack.func_77978_p() != null) {
                NBTTagCompound tagCompound = stack.func_77978_p();
                return based.areCapsCompatible(stack) && based.func_77978_p().func_150296_c().stream().allMatch(keyName -> {
                    if (!tagCompound.func_74764_b(keyName)) {
                        return false;
                    }
                    return tagCompound.func_74781_a(keyName).equals((Object)based.func_77978_p().func_74781_a(keyName));
                });
            }
        }
        return false;
    }

    public static ItemStack getFirstStack(IGuiIngredient<ItemStack> ingredient) {
        if (ingredient == null || ingredient.getAllIngredients().isEmpty()) {
            return ItemStack.field_190927_a;
        }
        return ingredient.getAllIngredients().stream().filter(stack -> stack != null && !stack.func_190926_b()).findFirst().map(ItemStack::func_77946_l).orElse(ItemStack.field_190927_a);
    }

    public static ItemStack getFirstStack(List<ItemStack> ingredients) {
        if (ingredients == null || ingredients.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        return ingredients.stream().filter(stack -> stack != null && !stack.func_190926_b()).findFirst().map(ItemStack::func_77946_l).orElse(ItemStack.field_190927_a);
    }

    public static List<IAEItemStack> getStorage(ItemRepo repo) {
        if (repo == null) {
            return Collections.emptyList();
        }
        IItemList all = (IItemList)ObfuscationReflectionHelper.getPrivateValue(ItemRepo.class, (Object)repo, (String)"list");
        if (all == null) {
            return Collections.emptyList();
        }
        return StreamSupport.stream(all.spliterator(), false).collect(Collectors.toList());
    }

    public static ItemStack fromTagOrEmpty(NBTTagCompound tag) {
        return tag == null ? ItemStack.field_190927_a : (tag.func_82582_d() ? ItemStack.field_190927_a : new ItemStack(tag));
    }
}

