/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.utils;

import com.github.vfyjxf.nee.utils.ItemUtils;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class BlackIngredient {
    private final ItemStack identifier;
    @Nullable
    private final String acceptedType;

    public BlackIngredient(ItemStack identifier, @Nullable String acceptedType) {
        this.identifier = identifier;
        this.acceptedType = acceptedType;
    }

    public ItemStack getIdentifier() {
        return this.identifier;
    }

    @Nullable
    public String getAcceptedType() {
        return this.acceptedType;
    }

    public boolean matches(ItemStack stack, String recipeType) {
        if (this.acceptedType == null || recipeType == null || this.acceptedType.equals(recipeType)) {
            return ItemUtils.contains(this.identifier, stack);
        }
        return false;
    }

    public NBTTagCompound toTag() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("identifier", (NBTBase)this.identifier.func_77955_b(new NBTTagCompound()));
        if (this.acceptedType != null) {
            tag.func_74778_a("acceptedType", this.acceptedType);
        }
        return tag;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlackIngredient that = (BlackIngredient)o;
        return this.identifier.equals(that.identifier) && Objects.equals(this.acceptedType, that.acceptedType);
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.acceptedType);
    }
}

