/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.network.packet;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.container.implementations.ContainerPatternTerm;
import com.github.vfyjxf.nee.integration.IPatternProvider;
import com.github.vfyjxf.nee.network.NEENetworkHandler;
import com.github.vfyjxf.nee.network.SyncAction;
import com.github.vfyjxf.nee.network.packet.PacketSyncInterfaceDataClient;
import com.github.vfyjxf.nee.utils.PatternContainerControl;
import io.netty.buffer.ByteBuf;
import java.util.Iterator;
import java.util.Objects;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.items.IItemHandler;

public class PacketSyncInterfaceDataServer
implements IMessage {
    private int actionId;

    public PacketSyncInterfaceDataServer() {
    }

    public PacketSyncInterfaceDataServer(SyncAction action) {
        this.actionId = action.ordinal();
    }

    public void fromBytes(ByteBuf byteBuf) {
    }

    public void toBytes(ByteBuf byteBuf) {
    }

    public static class Handler
    implements IMessageHandler<PacketSyncInterfaceDataServer, IMessage> {
        public IMessage onMessage(PacketSyncInterfaceDataServer packet, MessageContext cxt) {
            EntityPlayerMP player = cxt.getServerHandler().field_147369_b;
            Container container = player.field_71070_bA;
            SyncAction action = SyncAction.values()[packet.actionId];
            if (Objects.requireNonNull(action) != SyncAction.SYNC_INTERFACE_DATA) {
                return null;
            }
            this.handleInterfaceSync(container, player);
            return null;
        }

        private void handleInterfaceSync(Container container, EntityPlayerMP player) {
            if (container instanceof ContainerPatternTerm) {
                ContainerPatternTerm patternTerm = (ContainerPatternTerm)container;
                NBTTagCompound tag = this.packInterfaceData(patternTerm);
                NEENetworkHandler.getInstance().sendTo((IMessage)new PacketSyncInterfaceDataClient(SyncAction.SYNC_INTERFACE_DATA, tag), player);
            }
        }

        private <T extends IGridHost> NBTTagCompound packInterfaceData(ContainerPatternTerm term) {
            NBTTagCompound interfaceTag = new NBTTagCompound();
            Iterator<IPatternProvider<?>> iterator = IPatternProvider.PROVIDERS.iterator();
            while (iterator.hasNext()) {
                IPatternProvider<?> p;
                IPatternProvider<?> provider = p = iterator.next();
                IGrid grid = term.getNetworkNode().getGrid();
                for (IGridNode node : grid.getMachines(provider.getHostClass())) {
                    if (!node.isActive()) continue;
                    NBTTagCompound tag = new NBTTagCompound();
                    IGridHost host = node.getMachine();
                    IItemHandler patterns = provider.getPatterns(host);
                    tag.func_74778_a("uid", provider.uid(host));
                    tag.func_74782_a("patterns", (NBTBase)Handler.packPatterns(patterns));
                    tag.func_74782_a("identifier", (NBTBase)node.getGridBlock().getMachineRepresentation().func_77955_b(new NBTTagCompound()));
                    tag.func_74782_a("target", (NBTBase)provider.getTarget(host).func_77955_b(new NBTTagCompound()));
                    tag.func_74778_a("name", provider.getName(host));
                    interfaceTag.func_74782_a(provider.uid(host), (NBTBase)tag);
                    PatternContainerControl.putHandler(provider.uid(host), patterns);
                }
            }
            return interfaceTag;
        }

        private static NBTTagCompound packPatterns(IItemHandler patterns) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("size", patterns.getSlots());
            for (int i = 0; i < patterns.getSlots(); ++i) {
                NBTTagCompound pattern = new NBTTagCompound();
                patterns.getStackInSlot(i).func_77955_b(pattern);
                tag.func_74782_a("#" + i, (NBTBase)pattern);
            }
            return tag;
        }
    }
}

