/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.network.packet;

import com.github.vfyjxf.nee.network.SyncAction;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketSyncInterfaceDataClient
implements IMessage {
    private int actionId;
    private NBTTagCompound data;

    public PacketSyncInterfaceDataClient() {
    }

    public PacketSyncInterfaceDataClient(SyncAction action, NBTTagCompound data) {
        this.actionId = action.ordinal();
        this.data = data;
    }

    public void fromBytes(ByteBuf byteBuf) {
        this.actionId = byteBuf.readInt();
        this.data = ByteBufUtils.readTag((ByteBuf)byteBuf);
    }

    public void toBytes(ByteBuf byteBuf) {
        byteBuf.writeInt(this.actionId);
        ByteBufUtils.writeTag((ByteBuf)byteBuf, (NBTTagCompound)this.data);
    }

    public static class Handler
    implements IMessageHandler<PacketSyncInterfaceDataClient, IMessage> {
        public IMessage onMessage(PacketSyncInterfaceDataClient packet, MessageContext ctx) {
            SyncAction action = SyncAction.values()[packet.actionId];
            if (Objects.requireNonNull(action) != SyncAction.SYNC_INTERFACE_DATA) {
                return null;
            }
            this.handleSyncInterfaceData(packet, ctx);
            return null;
        }

        private void handleSyncInterfaceData(PacketSyncInterfaceDataClient packet, MessageContext ctx) {
        }
    }
}

