/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.network.packet;

import appeng.container.AEBaseContainer;
import appeng.container.slot.SlotFake;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketSlotStackSwitch
implements IMessage {
    private ItemStack stack;
    private List<Integer> slots;

    public PacketSlotStackSwitch() {
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public List<Integer> getSlots() {
        return this.slots;
    }

    public PacketSlotStackSwitch(ItemStack stack, List<Integer> craftingSlots) {
        this.stack = stack;
        this.slots = craftingSlots;
    }

    public void fromBytes(ByteBuf buf) {
        this.stack = ByteBufUtils.readItemStack((ByteBuf)buf);
        int craftingSlotsSize = buf.readInt();
        this.slots = new ArrayList<Integer>(craftingSlotsSize);
        for (int i = 0; i < craftingSlotsSize; ++i) {
            int slotNumber = buf.readInt();
            this.slots.add(slotNumber);
        }
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.stack);
        buf.writeInt(this.slots.size());
        for (Integer craftingSlot : this.slots) {
            buf.writeInt(craftingSlot.intValue());
        }
    }

    public static class Handler
    implements IMessageHandler<PacketSlotStackSwitch, IMessage> {
        public IMessage onMessage(PacketSlotStackSwitch message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            Container container = player.field_71070_bA;
            player.func_71121_q().func_152344_a(() -> {
                if (!(container instanceof AEBaseContainer)) {
                    return;
                }
                ItemStack nextStack = message.getStack();
                if (nextStack == null) {
                    return;
                }
                for (Integer craftingSlot : message.getSlots()) {
                    Slot currentSlot = container.func_75139_a(craftingSlot.intValue());
                    if (!(currentSlot instanceof SlotFake)) continue;
                    ItemStack next = nextStack.func_77946_l();
                    ItemStack stackInSlot = currentSlot.func_75211_c();
                    next.func_190920_e(!stackInSlot.func_190926_b() ? stackInSlot.func_190916_E() : 1);
                    currentSlot.func_75215_d(next);
                }
            });
            return null;
        }
    }
}

