/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.network.packet;

import com.github.vfyjxf.nee.network.PlayerAction;
import com.github.vfyjxf.nee.utils.PatternContainerControl;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketPlayerAction
implements IMessage {
    private int action;
    private NBTTagCompound data;

    public PacketPlayerAction() {
    }

    public PacketPlayerAction(PlayerAction action, NBTTagCompound data) {
        this.action = action.ordinal();
        this.data = data;
    }

    public void fromBytes(ByteBuf buf) {
        this.action = buf.readInt();
        this.data = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.action);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.data);
    }

    public static class Handler
    implements IMessageHandler<PacketPlayerAction, IMessage> {
        public IMessage onMessage(PacketPlayerAction message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            player.func_71121_q().func_152344_a(() -> {
                PlayerAction action = PlayerAction.values()[message.action];
                switch (action) {
                    case PICK: {
                        Handler.pick(player, message.data);
                        break;
                    }
                    case PUT: {
                        Handler.put(player, message.data);
                        break;
                    }
                    case DROP: {
                        Handler.drop(player, message.data);
                        break;
                    }
                }
            });
            return null;
        }

        private static void pick(EntityPlayerMP player, NBTTagCompound data) {
            int slot = data.func_74762_e("slot");
            String uid = data.func_74779_i("uid");
            ItemStack extract = PatternContainerControl.extractPattern(uid, slot);
            if (!extract.func_190926_b()) {
                player.field_71071_by.func_70437_b(extract);
                player.field_71070_bA.func_75142_b();
            }
        }

        private static void put(EntityPlayerMP player, NBTTagCompound data) {
            ItemStack left;
            int slot = data.func_74762_e("slot");
            String uid = data.func_74779_i("uid");
            ItemStack stack = player.field_71071_by.func_70445_o();
            if (!stack.func_190926_b() && (left = PatternContainerControl.insertPattern(uid, slot, stack)) != null) {
                player.field_71071_by.func_70437_b(left);
                player.field_71070_bA.func_75142_b();
            }
        }

        private static void drop(EntityPlayerMP player, NBTTagCompound data) {
            int slot = data.func_74762_e("slot");
            String uid = data.func_74779_i("uid");
            ItemStack extract = PatternContainerControl.extractPattern(uid, slot);
            if (!extract.func_190926_b()) {
                player.func_71019_a(extract, false);
            }
        }
    }
}

