/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.network.packet;

import appeng.api.AEApi;
import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.container.AEBaseContainer;
import appeng.container.ContainerNull;
import appeng.container.ContainerOpenContext;
import appeng.container.implementations.ContainerCraftConfirm;
import appeng.container.implementations.ContainerCraftingTerm;
import appeng.container.interfaces.IInventorySlotAware;
import appeng.core.AELog;
import appeng.util.item.AEItemStack;
import com.github.vfyjxf.nee.block.tile.TilePatternInterface;
import com.github.vfyjxf.nee.container.ContainerCraftingAmount;
import com.github.vfyjxf.nee.container.ContainerCraftingConfirmWrapper;
import com.github.vfyjxf.nee.container.WCTContainerCraftingConfirm;
import com.github.vfyjxf.nee.helper.PlatformHelper;
import com.github.vfyjxf.nee.network.NEEGuiHandler;
import com.github.vfyjxf.nee.utils.GuiUtils;
import com.github.vfyjxf.nee.utils.ReflectionHelper;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.Future;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.apache.commons.lang3.tuple.Pair;
import p455w0rd.wct.api.IWCTContainer;

public class PacketCraftingRequest
implements IMessage {
    private IAEItemStack requireToCraftStack;
    private boolean isAutoStart;
    private int craftAmount;

    public PacketCraftingRequest() {
    }

    public PacketCraftingRequest(IAEItemStack requireToCraftStack, boolean isAutoStart) {
        this.requireToCraftStack = requireToCraftStack;
        this.isAutoStart = isAutoStart;
    }

    public PacketCraftingRequest(int craftAmount, boolean isAutoStart) {
        this.craftAmount = craftAmount;
        this.isAutoStart = isAutoStart;
    }

    public IAEItemStack getRequireToCraftStack() {
        return this.requireToCraftStack;
    }

    public boolean isAutoStart() {
        return this.isAutoStart;
    }

    public int getCraftAmount() {
        return this.craftAmount;
    }

    public void fromBytes(ByteBuf buf) {
        if (buf.readBoolean()) {
            this.requireToCraftStack = AEItemStack.fromPacket((ByteBuf)buf);
        }
        this.isAutoStart = buf.readBoolean();
        this.craftAmount = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        if (this.requireToCraftStack != null) {
            buf.writeBoolean(true);
            try {
                this.requireToCraftStack.writeToPacket(buf);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            buf.writeBoolean(false);
        }
        buf.writeBoolean(this.isAutoStart);
        buf.writeInt(this.craftAmount);
    }

    public static class Handler
    implements IMessageHandler<PacketCraftingRequest, IMessage> {
        public IMessage onMessage(PacketCraftingRequest message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            Container container = player.field_71070_bA;
            if (!(container instanceof AEBaseContainer)) {
                return null;
            }
            player.func_71121_q().func_152344_a(() -> {
                IActionHost ah;
                IGridNode gn;
                IGrid grid;
                ISecurityGrid security;
                AEBaseContainer baseContainer = (AEBaseContainer)container;
                Object target = baseContainer.getTarget();
                if (target instanceof IActionHost && (security = (ISecurityGrid)(grid = (gn = (ah = (IActionHost)target).getActionableNode()).getGrid()).getCache(ISecurityGrid.class)).hasPermission((EntityPlayer)player, SecurityPermissions.CRAFT)) {
                    if (container instanceof ContainerCraftingTerm || PlatformHelper.isWirelessContainer(container)) {
                        this.handlerCraftingTermRequest(baseContainer, message, grid, ah, player);
                    }
                    if (container instanceof ContainerCraftingAmount) {
                        this.handlerCraftingAmountRequest((ContainerCraftingAmount)baseContainer, message, grid, player);
                    }
                    if (GuiUtils.isWirelessCraftingTermContainer(container)) {
                        this.handlerWirelessCraftingRequest(baseContainer, message, grid, player);
                    }
                }
            });
            return null;
        }

        private void handlerCraftingTermRequest(AEBaseContainer container, PacketCraftingRequest message, IGrid grid, IActionHost ah, EntityPlayerMP player) {
            if (message.getRequireToCraftStack() != null) {
                Future futureJob = null;
                try {
                    ICraftingGrid cg = (ICraftingGrid)grid.getCache(ICraftingGrid.class);
                    futureJob = cg.beginCraftingJob(player.field_70170_p, grid, container.getActionSource(), message.getRequireToCraftStack(), null);
                    ContainerOpenContext context = container.getOpenContext();
                    if (context != null) {
                        TileEntity te = context.getTile();
                        if (te == null) {
                            Handler.unofficialHelper(ah, (EntityPlayer)player);
                        } else {
                            NEEGuiHandler.openGui((EntityPlayer)player, 3, te, context.getSide());
                        }
                        if (player.field_71070_bA instanceof ContainerCraftConfirm) {
                            ContainerCraftConfirm ccc = (ContainerCraftConfirm)player.field_71070_bA;
                            ccc.setAutoStart(message.isAutoStart());
                            ccc.setJob(futureJob);
                            ccc.func_75142_b();
                        }
                    }
                }
                catch (Throwable e) {
                    if (futureJob != null) {
                        futureJob.cancel(true);
                    }
                    AELog.debug((Throwable)e);
                }
            }
        }

        private static void unofficialHelper(IActionHost host, EntityPlayer player) {
            if (host instanceof IInventorySlotAware) {
                IInventorySlotAware slotAware = (IInventorySlotAware)host;
                boolean isBauble = Boolean.TRUE.equals(ReflectionHelper.invoke(IInventorySlotAware.class, slotAware, "isBauble", new Object[0]));
                NEEGuiHandler.openWirelessGui(player, 201, slotAware.getInventorySlot(), isBauble);
            }
        }

        private void handlerCraftingAmountRequest(ContainerCraftingAmount container, PacketCraftingRequest message, IGrid grid, EntityPlayerMP player) {
            Pair<TilePatternInterface, Integer> pair;
            if (!container.getResultStack().func_190926_b() && (pair = this.setRecipe(grid, container.getRecipe(), (EntityPlayer)player)) != null) {
                IStorageGrid inv = (IStorageGrid)grid.getCache(IStorageGrid.class);
                IMEMonitor storage = inv.getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class));
                IItemList all = storage.getStorageList();
                ItemStack resultStack = container.getResultStack().func_77946_l();
                IAEItemStack result = null;
                for (IAEItemStack aeStack : all) {
                    if (!resultStack.func_77969_a(aeStack.asItemStackRepresentation()) || !aeStack.isCraftable()) continue;
                    result = aeStack.copy();
                    break;
                }
                if (result != null) {
                    result.setStackSize((long)message.craftAmount);
                    Future futureJob = null;
                    try {
                        ICraftingGrid cg = (ICraftingGrid)grid.getCache(ICraftingGrid.class);
                        futureJob = cg.beginCraftingJob(player.field_70170_p, grid, container.getActionSource(), result, null);
                        ContainerOpenContext context = container.getOpenContext();
                        if (context != null) {
                            TileEntity te = context.getTile();
                            NEEGuiHandler.openGui((EntityPlayer)player, 1, te, context.getSide());
                            if (player.field_71070_bA instanceof ContainerCraftingConfirmWrapper) {
                                ContainerCraftingConfirmWrapper ccc = (ContainerCraftingConfirmWrapper)player.field_71070_bA;
                                ccc.setAutoStart(message.isAutoStart());
                                ccc.setJob(futureJob);
                                ccc.setTile((TilePatternInterface)((Object)pair.getLeft()));
                                ccc.setPatternIndex((Integer)pair.getRight());
                                ccc.func_75142_b();
                            }
                        } else if (Loader.isModLoaded((String)"wct") && container.isWirelessTerm()) {
                            NEEGuiHandler.openGui((EntityPlayer)player, 101, player.field_70170_p);
                            if (player.field_71070_bA instanceof WCTContainerCraftingConfirm) {
                                WCTContainerCraftingConfirm ccc = (WCTContainerCraftingConfirm)player.field_71070_bA;
                                ccc.setAutoStart(message.isAutoStart());
                                ccc.setJob(futureJob);
                                ccc.setTile((TilePatternInterface)((Object)pair.getLeft()));
                                ccc.setPatternIndex((Integer)pair.getRight());
                                ccc.func_75142_b();
                            }
                        }
                    }
                    catch (Throwable e) {
                        if (futureJob != null) {
                            futureJob.cancel(true);
                        }
                        AELog.debug((Throwable)e);
                    }
                }
            }
        }

        private void handlerWirelessCraftingRequest(AEBaseContainer container, PacketCraftingRequest message, IGrid grid, EntityPlayerMP player) {
            block4: {
                if (message.getRequireToCraftStack() != null) {
                    IWCTContainer iwtContainer = (IWCTContainer)container;
                    Future futureJob = null;
                    try {
                        ICraftingGrid cg = (ICraftingGrid)grid.getCache(ICraftingGrid.class);
                        futureJob = cg.beginCraftingJob(player.field_70170_p, grid, container.getActionSource(), message.getRequireToCraftStack(), null);
                        int x = (int)player.field_70165_t;
                        int y = (int)player.field_70163_u;
                        int z = (int)player.field_70161_v;
                        NEEGuiHandler.openGui((EntityPlayer)player, 103, player.field_70170_p);
                        if (player.field_71070_bA instanceof p455w0rd.wct.container.ContainerCraftConfirm) {
                            p455w0rd.wct.container.ContainerCraftConfirm ccc = (p455w0rd.wct.container.ContainerCraftConfirm)player.field_71070_bA;
                            ccc.setAutoStart(message.isAutoStart());
                            ccc.setJob(futureJob);
                            ccc.func_75142_b();
                        }
                    }
                    catch (Throwable e) {
                        if (futureJob == null) break block4;
                        futureJob.cancel(true);
                    }
                }
            }
        }

        private Pair<TilePatternInterface, Integer> setRecipe(IGrid grid, NBTTagCompound recipe, EntityPlayer player) {
            for (IGridNode gridNode : grid.getMachines(TilePatternInterface.class)) {
                int patternIndex;
                ItemStack patternStack;
                ItemStack result;
                if (!(gridNode.getMachine() instanceof TilePatternInterface)) continue;
                TilePatternInterface tpi = (TilePatternInterface)gridNode.getMachine();
                NBTTagCompound currentTag = recipe.func_74775_l("O");
                ItemStack itemStack = result = currentTag.func_82582_d() ? ItemStack.field_190927_a : new ItemStack(currentTag);
                if (!tpi.getProxy().isActive() || !tpi.canPutPattern(result) || (patternStack = this.getPatternStack(player, recipe)).func_190926_b() || (patternIndex = tpi.putPattern(patternStack)) < 0) continue;
                return Pair.of((Object)((Object)tpi), (Object)patternIndex);
            }
            return null;
        }

        private ItemStack getPatternStack(EntityPlayer player, NBTTagCompound recipe) {
            ItemStack outputStack;
            ItemStack[] recipeInputs = new ItemStack[9];
            for (int i = 0; i < recipeInputs.length; ++i) {
                NBTTagCompound currentStack = recipe.func_74775_l("#" + i);
                recipeInputs[i] = currentStack.func_82582_d() ? ItemStack.field_190927_a : new ItemStack(currentStack);
            }
            InventoryCrafting ic = new InventoryCrafting((Container)new ContainerNull(), 3, 3);
            for (int i = 0; i < 9; ++i) {
                ic.func_70299_a(i, recipeInputs[i]);
            }
            IRecipe iRecipe = CraftingManager.func_192413_b((InventoryCrafting)ic, (World)player.field_70170_p);
            if (iRecipe != null && !(outputStack = iRecipe.func_77572_b(ic)).func_190926_b()) {
                ItemStack patternStack = null;
                Optional maybePattern = AEApi.instance().definitions().items().encodedPattern().maybeStack(1);
                if (maybePattern.isPresent()) {
                    patternStack = (ItemStack)maybePattern.get();
                }
                if (patternStack != null && !patternStack.func_190926_b()) {
                    NBTTagCompound patternValue = new NBTTagCompound();
                    NBTTagList tagIn = new NBTTagList();
                    for (ItemStack stack : recipeInputs) {
                        tagIn.func_74742_a((NBTBase)this.crateItemTag(stack));
                    }
                    patternValue.func_74782_a("in", (NBTBase)tagIn);
                    patternValue.func_74782_a("out", (NBTBase)outputStack.func_77955_b(new NBTTagCompound()));
                    patternValue.func_74757_a("crafting", true);
                    patternValue.func_74757_a("substitute", false);
                    patternStack.func_77982_d(patternValue);
                    return patternStack;
                }
            }
            return ItemStack.field_190927_a;
        }

        private NBTTagCompound crateItemTag(ItemStack itemStack) {
            NBTTagCompound tag = new NBTTagCompound();
            if (!itemStack.func_190926_b()) {
                itemStack.func_77955_b(tag);
            }
            return tag;
        }
    }
}

