/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.network;

import appeng.api.AEApi;
import appeng.api.features.IWirelessTermHandler;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.storage.ITerminalHost;
import appeng.api.util.AEPartLocation;
import appeng.client.gui.implementations.GuiCraftConfirm;
import appeng.container.AEBaseContainer;
import appeng.container.ContainerOpenContext;
import appeng.container.implementations.ContainerCraftConfirm;
import appeng.helpers.WirelessTerminalGuiObject;
import appeng.parts.reporting.PartCraftingTerminal;
import com.github.vfyjxf.nee.NotEnoughEnergistics;
import com.github.vfyjxf.nee.block.tile.TilePatternInterface;
import com.github.vfyjxf.nee.client.gui.ConfirmWrapperGui;
import com.github.vfyjxf.nee.client.gui.CraftingAmountGui;
import com.github.vfyjxf.nee.client.gui.PatternInterfaceGui;
import com.github.vfyjxf.nee.client.gui.WirelessConfirmWrapperGui;
import com.github.vfyjxf.nee.container.ContainerCraftingAmount;
import com.github.vfyjxf.nee.container.ContainerCraftingConfirmWrapper;
import com.github.vfyjxf.nee.container.ContainerPatternInterface;
import com.github.vfyjxf.nee.container.WCTContainerCraftingConfirm;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.network.IGuiHandler;
import org.apache.commons.lang3.tuple.Pair;
import p455w0rd.ae2wtlib.api.ICustomWirelessTerminalItem;
import p455w0rd.ae2wtlib.api.WTApi;
import p455w0rd.wct.api.IWirelessCraftingTerminalItem;
import p455w0rd.wct.container.ContainerWCT;
import p455w0rd.wct.init.ModGuiHandler;
import p455w0rd.wct.util.WCTUtils;

public class NEEGuiHandler
implements IGuiHandler {
    public static final int CRAFTING_AMOUNT_ID = 0;
    public static final int CRAFTING_CONFIRM_ID = 1;
    public static final int PATTERN_INTERFACE_ID = 2;
    public static final int CONFIRM_WRAPPER_ID = 3;
    public static final int WIRELESS_START_INDEX = 100;
    public static final int WIRELESS_CRAFTING_CONFIRM_ID = 101;
    public static final int WIRELESS_CRAFTING_AMOUNT_ID = 102;
    public static final int WIRELESS_CONFIRM_WRAPPER_ID = 103;
    public static final int UNOFFICIAL_START_INDEX = 200;
    public static final int WIRELESS_CRAFTING_CONFIRM_UNOFFICIAL_ID = 201;

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public Object getServerGuiElement(int ordinal, EntityPlayer player, World world, int x, int y, int z) {
        WirelessTerminalGuiObject guiObject;
        int guiId = ordinal >> 8;
        if (guiId < 100) {
            AEPartLocation side = AEPartLocation.fromOrdinal((int)(ordinal & 7));
            TileEntity tile = world.func_175625_s(new BlockPos(x, y, z));
            if (side == AEPartLocation.INTERNAL) {
                if (tile == null) return null;
                if (guiId != 2) return null;
                if (!(tile instanceof TilePatternInterface)) return null;
                return new ContainerPatternInterface(player.field_71071_by, (TilePatternInterface)tile);
            }
            if (!(tile instanceof IPartHost)) return null;
            IPartHost partHost = (IPartHost)tile;
            IPart part = partHost.getPart(side);
            switch (guiId) {
                case 0: {
                    if (!(part instanceof PartCraftingTerminal)) return null;
                    return this.updateGui((Object)new ContainerCraftingAmount(player.field_71071_by, part), world, x, y, z, side, part);
                }
                case 1: {
                    if (!(part instanceof PartCraftingTerminal)) return null;
                    return this.updateGui((Object)new ContainerCraftingConfirmWrapper(player.field_71071_by, (ITerminalHost)part), world, x, y, z, side, part);
                }
                case 3: {
                    if (!(part instanceof PartCraftingTerminal)) return null;
                    return this.updateGui(new ContainerCraftConfirm(player.field_71071_by, (ITerminalHost)part), world, x, y, z, side, part);
                }
            }
            return null;
        }
        if (guiId > 100 && guiId < 200 && Loader.isModLoaded((String)"wct")) {
            ITerminalHost craftingTerminal = this.getCraftingTerminal(player, ModGuiHandler.isBauble(), ModGuiHandler.getSlot());
            if (craftingTerminal == null) return null;
            Container container = player.field_71070_bA;
            if (guiId != 102) return new WCTContainerCraftingConfirm(player.field_71071_by, craftingTerminal, ModGuiHandler.isBauble(), ModGuiHandler.getSlot());
            if (!(container instanceof ContainerWCT)) return null;
            return new ContainerCraftingAmount(player.field_71071_by, craftingTerminal);
        }
        if (guiId < 200) return null;
        if (guiId != 201) return null;
        ItemStack it = ItemStack.field_190927_a;
        if (x >= 0 && x < player.field_71071_by.field_70462_a.size()) {
            it = player.field_71071_by.func_70301_a(x);
        }
        if ((guiObject = this.getGuiObject(it, player, world, x, y, z)) == null) return null;
        return this.updateGui((Object)new ContainerCraftingConfirmWrapper(player.field_71071_by, (ITerminalHost)guiObject), world, x, y, z, AEPartLocation.INTERNAL, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public Object getClientGuiElement(int ordinal, EntityPlayer player, World world, int x, int y, int z) {
        WirelessTerminalGuiObject guiObject;
        int guiId = ordinal >> 8;
        if (guiId < 100) {
            AEPartLocation side = AEPartLocation.fromOrdinal((int)(ordinal & 7));
            TileEntity tile = world.func_175625_s(new BlockPos(x, y, z));
            if (side == AEPartLocation.INTERNAL) {
                if (tile == null) return null;
                if (guiId != 2) return null;
                if (!(tile instanceof TilePatternInterface)) return null;
                return new PatternInterfaceGui(player.field_71071_by, (TilePatternInterface)tile);
            }
            if (!(tile instanceof IPartHost)) return null;
            IPartHost partHost = (IPartHost)tile;
            IPart part = partHost.getPart(side);
            switch (guiId) {
                case 0: {
                    if (!(part instanceof PartCraftingTerminal)) return null;
                    return this.updateGui((Object)new CraftingAmountGui(player.field_71071_by, (ITerminalHost)part), world, x, y, z, side, part);
                }
                case 1: {
                    if (!(part instanceof PartCraftingTerminal)) return null;
                    return this.updateGui(new GuiCraftConfirm(player.field_71071_by, (ITerminalHost)part), world, x, y, z, side, part);
                }
                case 3: {
                    if (!(part instanceof PartCraftingTerminal)) return null;
                    return this.updateGui((Object)new ConfirmWrapperGui(player.field_71071_by, (ITerminalHost)part), world, x, y, z, side, part);
                }
            }
            return null;
        }
        if (guiId > 100 && guiId < 200 && Loader.isModLoaded((String)"wct")) {
            ITerminalHost craftingTerminal = this.getCraftingTerminal(player, ModGuiHandler.isBauble(), ModGuiHandler.getSlot());
            if (craftingTerminal == null) return null;
            Container container = player.field_71070_bA;
            if (guiId == 102) {
                if (!(container instanceof ContainerWCT)) return null;
                return new CraftingAmountGui(player.field_71071_by, craftingTerminal, (ContainerWCT)container);
            }
            if (guiId != 103) return new p455w0rd.wct.client.gui.GuiCraftConfirm(player.field_71071_by, craftingTerminal, ModGuiHandler.isBauble(), ModGuiHandler.getSlot());
            return new WirelessConfirmWrapperGui(player.field_71071_by, craftingTerminal, ModGuiHandler.isBauble(), ModGuiHandler.getSlot());
        }
        if (guiId < 200) return null;
        if (guiId != 201) return null;
        ItemStack it = ItemStack.field_190927_a;
        if (x >= 0 && x < player.field_71071_by.field_70462_a.size()) {
            it = player.field_71071_by.func_70301_a(x);
        }
        if ((guiObject = this.getGuiObject(it, player, world, x, y, z)) == null) return null;
        return new ConfirmWrapperGui(player.field_71071_by, (ITerminalHost)guiObject);
    }

    private Object updateGui(Object newContainer, World w, int x, int y, int z, AEPartLocation side, Object myItem) {
        if (newContainer instanceof AEBaseContainer) {
            AEBaseContainer bc = (AEBaseContainer)newContainer;
            bc.setOpenContext(new ContainerOpenContext(myItem));
            bc.getOpenContext().setWorld(w);
            bc.getOpenContext().setX(x);
            bc.getOpenContext().setY(y);
            bc.getOpenContext().setZ(z);
            bc.getOpenContext().setSide(side);
        }
        return newContainer;
    }

    private WirelessTerminalGuiObject getGuiObject(ItemStack it, EntityPlayer player, World w, int x, int y, int z) {
        IWirelessTermHandler wh;
        if (!it.func_190926_b() && (wh = AEApi.instance().registries().wireless().getWirelessTerminalHandler(it)) != null) {
            return new WirelessTerminalGuiObject(wh, it, player, w, x, y, z);
        }
        return null;
    }

    public static void openGui(EntityPlayer player, int id, TileEntity tile, AEPartLocation side) {
        int x = tile.func_174877_v().func_177958_n();
        int y = tile.func_174877_v().func_177956_o();
        int z = tile.func_174877_v().func_177952_p();
        player.openGui((Object)NotEnoughEnergistics.instance, id << 8 | side.ordinal(), tile.func_145831_w(), x, y, z);
    }

    public static void openWirelessGui(@Nonnull EntityPlayer player, int id, int slot, boolean isBauble) {
        player.openGui((Object)NotEnoughEnergistics.instance, id << 8, player.func_130014_f_(), slot, isBauble ? 1 : 0, Integer.MIN_VALUE);
    }

    public static void openGui(EntityPlayer player, int id, World world) {
        int x = (int)player.field_70165_t;
        int y = (int)player.field_70163_u;
        int z = (int)player.field_70161_v;
        player.openGui((Object)NotEnoughEnergistics.instance, id << 8, world, x, y, z);
    }

    @Optional.Method(modid="wct")
    private ITerminalHost getCraftingTerminal(EntityPlayer player, boolean isBauble, int slot) {
        ItemStack wirelessTerminal;
        if (slot >= 0) {
            wirelessTerminal = isBauble ? WTApi.instance().getBaublesUtility().getWTBySlot(player, slot, IWirelessCraftingTerminalItem.class) : WTApi.instance().getWTBySlot(player, slot);
        } else {
            Pair firstTerm = WCTUtils.getFirstWirelessCraftingTerminal((InventoryPlayer)player.field_71071_by);
            wirelessTerminal = (ItemStack)((Pair)firstTerm.getRight()).getRight();
            ModGuiHandler.setSlot((int)((Integer)((Pair)firstTerm.getRight()).getLeft()));
            ModGuiHandler.setIsBauble((boolean)((Boolean)firstTerm.getLeft()));
        }
        ICustomWirelessTerminalItem wh = (ICustomWirelessTerminalItem)AEApi.instance().registries().wireless().getWirelessTerminalHandler(wirelessTerminal);
        return wh == null ? null : WTApi.instance().getGUIObject(wh, wirelessTerminal, player);
    }
}

