/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.jei;

import appeng.api.storage.data.IAEItemStack;
import appeng.client.gui.implementations.GuiMEMonitorable;
import appeng.client.gui.implementations.GuiPatternTerm;
import appeng.client.me.ItemRepo;
import appeng.container.implementations.ContainerPatternTerm;
import com.github.vfyjxf.nee.NotEnoughEnergistics;
import com.github.vfyjxf.nee.config.NEEConfig;
import com.github.vfyjxf.nee.helper.BlackListHelper;
import com.github.vfyjxf.nee.helper.PreferenceHelper;
import com.github.vfyjxf.nee.helper.RecipeAnalyzer;
import com.github.vfyjxf.nee.jei.CraftingInfoError;
import com.github.vfyjxf.nee.network.NEENetworkHandler;
import com.github.vfyjxf.nee.network.packet.PacketRecipeTransfer;
import com.github.vfyjxf.nee.utils.GuiUtils;
import com.github.vfyjxf.nee.utils.ItemUtils;
import com.github.vfyjxf.nee.utils.StackWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.tuple.Pair;

public class PatternTransferHandler
implements IRecipeTransferHandler<ContainerPatternTerm> {
    private static final Map<String, List<ItemStack>> SWITCHER_DATA = new HashMap<String, List<ItemStack>>();
    private static String lastRecipeType = "";

    @Nonnull
    public Class<ContainerPatternTerm> getContainerClass() {
        return ContainerPatternTerm.class;
    }

    public static Map<String, List<ItemStack>> getSwitcherData() {
        return SWITCHER_DATA;
    }

    public static String getLastRecipeType() {
        return lastRecipeType;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(@Nonnull ContainerPatternTerm container, IRecipeLayout recipeLayout, @Nonnull EntityPlayer player, boolean maxTransfer, boolean doTransfer) {
        String recipeType = recipeLayout.getRecipeCategory().getUid();
        boolean isCraftingRecipe = this.isCraftingRecipe(recipeType);
        GuiScreen parent = GuiUtils.getParentScreen();
        if (parent instanceof GuiPatternTerm) {
            GuiPatternTerm patternTerm = (GuiPatternTerm)parent;
            if (doTransfer) {
                Pair<NBTTagCompound, NBTTagCompound> recipePair = this.packRecipe(this.getRepo(patternTerm), container, recipeLayout, recipeType);
                NEENetworkHandler.getInstance().sendToServer((IMessage)new PacketRecipeTransfer((NBTTagCompound)recipePair.getLeft(), (NBTTagCompound)recipePair.getRight(), isCraftingRecipe));
                if (NEEConfig.isPrintRecipeType()) {
                    NotEnoughEnergistics.logger.info("RecipeType is : " + recipeType);
                }
            } else {
                Supplier<ItemRepo> repoSupplier = () -> this.getRepo(patternTerm);
                return new CraftingInfoError(new RecipeAnalyzer((GuiContainer)patternTerm, true, repoSupplier), recipeLayout, false);
            }
        }
        return null;
    }

    private Pair<NBTTagCompound, NBTTagCompound> packRecipe(ItemRepo repo, ContainerPatternTerm container, IRecipeLayout recipeLayout, String recipeType) {
        SWITCHER_DATA.clear();
        boolean isCraftingRecipe = this.isCraftingRecipe(recipeType);
        boolean shouldMerge = this.shouldMerge(recipeType);
        NBTTagCompound inputs = new NBTTagCompound();
        NBTTagCompound outputs = new NBTTagCompound();
        Map ingredients = recipeLayout.getItemStacks().getGuiIngredients();
        List<IAEItemStack> storage = ItemUtils.getStorage(repo);
        ArrayList<StackWrapper> inputsList = new ArrayList<StackWrapper>();
        int inputIndex = 0;
        int outputIndex = 0;
        for (Map.Entry entry : ingredients.entrySet()) {
            ItemStack stack;
            IGuiIngredient ingredient = (IGuiIngredient)entry.getValue();
            if (ingredient == null) continue;
            ItemStack itemStack = stack = NEEConfig.isUseDisplayed() ? (ItemStack)ingredient.getDisplayedIngredient() : ItemUtils.getFirstStack((IGuiIngredient<ItemStack>)ingredient);
            if (stack == null) {
                stack = ItemStack.field_190927_a;
            }
            if (ingredient.isInput()) {
                StackWrapper current = new StackWrapper(stack.func_77946_l(), ingredient.getAllIngredients());
                if (!isCraftingRecipe) {
                    boolean merged;
                    if (stack.func_190926_b() || (merged = shouldMerge && inputsList.stream().anyMatch(wrapper -> wrapper.merge(current)))) continue;
                    inputsList.add(current);
                    continue;
                }
                inputsList.add(current);
                continue;
            }
            if (outputIndex >= 3 || stack.func_190926_b() || isCraftingRecipe) continue;
            outputs.func_74782_a("O" + outputIndex, (NBTBase)stack.func_77955_b(new NBTTagCompound()));
            ++outputIndex;
        }
        for (StackWrapper preference : this.mapToPreference(inputsList, recipeType)) {
            if (BlackListHelper.isBlacklistItem(preference.getStack(), recipeType)) continue;
            ItemStack finalStack = preference.getStack().func_77946_l();
            if (NEEConfig.isNetworkOrInventoryFirst() && !storage.isEmpty() && !finalStack.func_190926_b()) {
                ItemStack origin = finalStack;
                finalStack = storage.stream().filter(stored -> ItemUtils.contains(origin, stored.getDefinition())).min((o1, o2) -> {
                    if (o1.isCraftable() && o2.isCraftable()) {
                        return 0;
                    }
                    if (o1.isCraftable()) {
                        return -1;
                    }
                    if (o2.isCraftable()) {
                        return 1;
                    }
                    return Long.compare(o2.getStackSize(), o1.getStackSize());
                }).map(stored -> stored.getDefinition().func_77946_l()).orElse(origin);
            }
            finalStack.func_190920_e(preference.getCount());
            inputs.func_74782_a("#" + inputIndex, (NBTBase)finalStack.func_77955_b(new NBTTagCompound()));
            SWITCHER_DATA.put("#" + inputIndex, preference.getIngredients());
            ++inputIndex;
        }
        lastRecipeType = recipeType;
        return Pair.of((Object)inputs, (Object)outputs);
    }

    private boolean isCraftingRecipe(String recipeType) {
        if (!recipeType.equals("jei.information") && !recipeType.equals("minecraft.fuel")) {
            return recipeType.equals("minecraft.crafting");
        }
        return false;
    }

    private boolean shouldMerge(String recipeType) {
        switch (NEEConfig.getMergeMode()) {
            case ENABLED: {
                return !NEEConfig.getMergeBlacklist().contains(recipeType);
            }
        }
        return false;
    }

    private List<StackWrapper> mapToPreference(List<StackWrapper> wrappers, String recipeType) {
        return wrappers.stream().map(wrapper -> new StackWrapper(PreferenceHelper.getFromPreference(wrapper.getIngredients(), wrapper.getStack(), recipeType), wrapper.getIngredients(), wrapper.getCount())).collect(Collectors.toList());
    }

    private ItemRepo getRepo(GuiPatternTerm patternTerm) {
        return (ItemRepo)ObfuscationReflectionHelper.getPrivateValue(GuiMEMonitorable.class, (Object)patternTerm, (String)"repo");
    }
}

