/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.jei;

import appeng.api.storage.data.IAEItemStack;
import appeng.container.AEBaseContainer;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketInventoryAction;
import appeng.helpers.InventoryAction;
import appeng.util.item.AEItemStack;
import com.github.vfyjxf.nee.config.KeyBindings;
import com.github.vfyjxf.nee.config.NEEConfig;
import com.github.vfyjxf.nee.helper.RecipeAnalyzer;
import com.github.vfyjxf.nee.jei.CraftingTransferHandler;
import com.github.vfyjxf.nee.utils.IngredientStatus;
import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.gui.TooltipRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class CraftingInfoError
implements IRecipeTransferError {
    private final boolean crafting;
    private final RecipeAnalyzer analyzer;

    public CraftingInfoError(RecipeAnalyzer analyzer, IRecipeLayout recipeLayout, boolean isCrafting) {
        this.analyzer = analyzer;
        this.crafting = isCrafting;
        recipeLayout.getItemStacks().addTooltipCallback((ITooltipCallback)new CraftingInfoCallback(analyzer));
    }

    @Nonnull
    public IRecipeTransferError.Type getType() {
        return IRecipeTransferError.Type.USER_FACING;
    }

    public void showError(@Nonnull Minecraft minecraft, int mouseX, int mouseY, @Nonnull IRecipeLayout recipeLayout, int recipeX, int recipeY) {
        this.analyzer.update();
        List<RecipeAnalyzer.RecipeIngredient> ingredients = this.analyzer.analyzeRecipe(recipeLayout);
        for (RecipeAnalyzer.RecipeIngredient ingredient2 : ingredients) {
            if (ingredient2.getStatus() == IngredientStatus.CRAFTABLE) {
                ingredient2.drawHighlight(minecraft, NEEConfig.getCraftableHighlightColor(), recipeX, recipeY);
                continue;
            }
            if (ingredient2.getStatus() != IngredientStatus.MISSING) continue;
            ingredient2.drawHighlight(minecraft, NEEConfig.getMissingHighlightColor(), recipeX, recipeY);
        }
        boolean autoCraftingAvailable = false;
        boolean patternExists = false;
        boolean missingItems = false;
        ArrayList<String> tooltips = new ArrayList<String>();
        if (this.crafting) {
            if (!CraftingTransferHandler.isIsPatternInterfaceExists()) {
                autoCraftingAvailable = ingredients.stream().anyMatch(ingredient -> ingredient.getStatus() == IngredientStatus.CRAFTABLE);
                missingItems = ingredients.stream().anyMatch(ingredient -> ingredient.getStatus() == IngredientStatus.MISSING);
            }
        } else {
            patternExists = ingredients.stream().anyMatch(ingredient -> ingredient.getStatus() == IngredientStatus.CRAFTABLE);
        }
        if (autoCraftingAvailable) {
            tooltips.add(String.format("%s" + TextFormatting.GRAY + " + " + TextFormatting.BLUE + I18n.func_135052_a((String)"jei.tooltip.nee.helper.crafting.text1", (Object[])new Object[0]), TextFormatting.YELLOW + Keyboard.getKeyName((int)KeyBindings.AUTO_CRAFT_WITH_PREVIEW.func_151463_i())));
        }
        if (patternExists) {
            tooltips.add(TextFormatting.BLUE + I18n.func_135052_a((String)"jei.tooltip.nee.helper.pattern", (Object[])new Object[0]));
        }
        if (missingItems) {
            tooltips.add(TextFormatting.RED + I18n.func_135052_a((String)"jei.tooltip.error.recipe.transfer.missing", (Object[])new Object[0]));
        }
        if (CraftingTransferHandler.isIsPatternInterfaceExists()) {
            tooltips.add(String.format("%s" + TextFormatting.GRAY + " + " + TextFormatting.BLUE + I18n.func_135052_a((String)"jei.tooltip.nee.helper.crafting.text2", (Object[])new Object[0]), TextFormatting.YELLOW + Keyboard.getKeyName((int)KeyBindings.AUTO_CRAFT_WITH_PREVIEW.func_151463_i())));
        }
        TooltipRenderer.drawHoveringText((Minecraft)minecraft, tooltips, (int)mouseX, (int)mouseY);
    }

    private static class CraftingInfoCallback
    implements ITooltipCallback<ItemStack> {
        private static final List<ItemStack> SUCCESS = new ArrayList<ItemStack>();
        private final Stopwatch lastClicked = Stopwatch.createStarted();
        private final RecipeAnalyzer analyzer;
        private List<IAEItemStack> craftables;

        private CraftingInfoCallback(RecipeAnalyzer analyzer) {
            this.analyzer = analyzer;
            this.craftables = analyzer.getCraftables();
            analyzer.addUpdateListener(pair -> {
                this.craftables = analyzer.getCraftables();
                SUCCESS.clear();
            });
        }

        public void onTooltip(int slotIndex, boolean input, @Nonnull ItemStack ingredient, @Nonnull List<String> tooltip) {
            boolean anyMatch;
            this.analyzer.update();
            if (!input | ingredient.func_190926_b() | this.craftables.isEmpty()) {
                return;
            }
            boolean isCache = SUCCESS.stream().anyMatch(arg_0 -> ((ItemStack)ingredient).func_77969_a(arg_0));
            boolean bl = anyMatch = isCache || this.craftables.stream().anyMatch(craftable -> {
                boolean match = craftable.isSameType(ingredient);
                if (match) {
                    SUCCESS.add(ingredient);
                }
                return match;
            });
            if (anyMatch) {
                tooltip.add(TextFormatting.BLUE + String.format("[%s]", I18n.func_135052_a((String)"jei.tooltip.nee.helper.craftable", (Object[])new Object[0])));
                if (Mouse.isButtonDown((int)2) && this.lastClicked.elapsed(TimeUnit.MILLISECONDS) > 200L) {
                    this.lastClicked.reset().start();
                    AEItemStack target = AEItemStack.fromItemStack((ItemStack)ingredient);
                    if (target != null && this.analyzer.getTerm().field_147002_h instanceof AEBaseContainer) {
                        AEBaseContainer container = (AEBaseContainer)this.analyzer.getTerm().field_147002_h;
                        container.setTargetStack((IAEItemStack)target);
                        NetworkHandler.instance().sendToServer((AppEngPacket)new PacketInventoryAction(InventoryAction.AUTO_CRAFT, container.func_75138_a().size(), 0L));
                    }
                }
            }
        }
    }
}

