/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.integration;

import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.implementations.tiles.ICraftingMachine;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.util.AEPartLocation;
import appeng.helpers.DualityInterface;
import appeng.helpers.ICustomNameObject;
import appeng.helpers.IInterfaceHost;
import appeng.tile.grid.AENetworkInvTile;
import appeng.tile.misc.TileInterface;
import appeng.util.InventoryAdaptor;
import com.github.vfyjxf.nee.integration.IPatternProvider;
import java.util.EnumSet;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;

public class InterfacePatternProvider
implements IPatternProvider<TileInterface> {
    @Override
    @Nonnull
    public Class<? extends IGridHost> getHostClass() {
        return TileInterface.class;
    }

    @Override
    public IItemHandler getPatterns(TileInterface tileEntity) {
        DualityInterface dual = tileEntity.getInterfaceDuality();
        IGridNode node = tileEntity.getGridNode(AEPartLocation.INTERNAL);
        if (node != null && node.isActive() && dual.getConfigManager().getSetting(Settings.INTERFACE_TERMINAL) == YesNo.YES) {
            return null;
        }
        return dual.getPatterns();
    }

    @Override
    public ItemStack getTarget(TileInterface tileEntity) {
        DualityInterface dual = tileEntity.getInterfaceDuality();
        IInterfaceHost iHost = (IInterfaceHost)dual.getHost();
        TileEntity hostTile = iHost.getTile();
        World hostWorld = hostTile.func_145831_w();
        if (((ICustomNameObject)iHost).hasCustomInventoryName()) {
            IBlockState blockState = hostWorld.func_180495_p(hostTile.func_174877_v());
            return new ItemStack(blockState.func_177230_c(), 1, blockState.func_177230_c().func_176201_c(blockState));
        }
        EnumSet possibleDirections = iHost.getTargets();
        for (EnumFacing direction : possibleDirections) {
            ItemStack g;
            Vec3d to;
            BlockPos target = hostTile.func_174877_v().func_177972_a(direction);
            TileEntity directedTile = hostWorld.func_175625_s(target);
            if (directedTile == null || directedTile instanceof IInterfaceHost && directedTile instanceof AENetworkInvTile && IPatternProvider.sameGird(dual, ((IInterfaceHost)directedTile).getInterfaceDuality())) continue;
            InventoryAdaptor adaptor = InventoryAdaptor.getAdaptor((TileEntity)directedTile, (EnumFacing)direction.func_176734_d());
            if (!(directedTile instanceof ICraftingMachine) && adaptor == null || adaptor != null && !adaptor.hasSlots()) continue;
            IBlockState directedBlockState = hostWorld.func_180495_p(target);
            Block directedBlock = directedBlockState.func_177230_c();
            ItemStack what = new ItemStack(directedBlock, 1, directedBlock.func_176201_c(directedBlockState));
            Vec3d from = new Vec3d((double)hostTile.func_174877_v().func_177958_n() + 0.5, (double)hostTile.func_174877_v().func_177956_o() + 0.5, (double)hostTile.func_174877_v().func_177952_p() + 0.5);
            RayTraceResult mop = hostWorld.func_72901_a(from = from.func_72441_c((double)direction.func_82601_c() * 0.501, (double)direction.func_96559_d() * 0.501, (double)direction.func_82599_e() * 0.501), to = from.func_72441_c((double)direction.func_82601_c(), (double)direction.func_96559_d(), (double)direction.func_82599_e()), true);
            if (mop != null && mop.func_178782_a().equals((Object)directedTile.func_174877_v()) && !(g = directedBlock.getPickBlock(directedBlockState, mop, hostWorld, directedTile.func_174877_v(), null)).func_190926_b()) {
                what = g;
            }
            if (what.func_77973_b() != Items.field_190931_a) {
                return what.func_77946_l();
            }
            Item item = Item.func_150898_a((Block)directedBlock);
            if (item != Items.field_190931_a) continue;
            return new ItemStack(directedBlock, 1, directedBlock.func_176201_c(directedBlockState));
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public String getName(TileInterface tileEntity) {
        return tileEntity.getInterfaceDuality().getTermName();
    }

    @Override
    public String uid(TileInterface tileEntity) {
        return Long.toString(tileEntity.getInterfaceDuality().getSortValue());
    }
}

