/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.helper;

import appeng.client.gui.implementations.GuiMEMonitorable;
import appeng.client.me.ItemRepo;
import com.github.vfyjxf.nee.utils.ReflectionHelper;
import com.google.common.collect.Lists;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraftforge.fml.common.Loader;

public class PlatformHelper {
    private static boolean unofficial;
    public static Class<?> containerPatternEncoderClass;
    public static Class<?> containerPatternTermClass;
    public static Class<?> guiWCTClass;
    public static Class<?> guiMEMonitorable;
    public static Class<?> containerWirelessCraftingTermClass;
    public static Class<?> wirelessCraftingGuiClass;

    private PlatformHelper() {
    }

    public static void init() {
        unofficial = Loader.instance().getModList().stream().anyMatch(modContainer -> modContainer.getModId().equals("appliedenergistics2") && modContainer.getVersion().contains("extended_life"));
        containerPatternEncoderClass = ReflectionHelper.getClassForName("appeng.container.implementations.ContainerPatternEncoder");
        guiWCTClass = ReflectionHelper.getClassForName("p455w0rd.wct.client.gui.GuiWCT");
        containerWirelessCraftingTermClass = ReflectionHelper.getClassForName("appeng.container.implementations.ContainerWirelessCraftingTerminal");
        wirelessCraftingGuiClass = ReflectionHelper.getClassForName("appeng.client.gui.implementations.GuiWirelessCraftingTerminal");
        guiMEMonitorable = ReflectionHelper.getClassForName("appeng.client.gui.implementations.GuiMEMonitorable");
        containerPatternTermClass = ReflectionHelper.getClassForName("appeng.container.implementations.ContainerPatternTerm");
    }

    public static boolean issUnofficial() {
        return unofficial;
    }

    public static boolean isCraftingMode(Container container) {
        return Boolean.TRUE.equals(ReflectionHelper.compositeInvoker(Lists.newArrayList((Object[])new Class[]{containerPatternEncoderClass, containerPatternTermClass}), container, false, "isCraftingMode", new Object[0]));
    }

    public static ItemRepo getRepo(GuiContainer gui) {
        return (ItemRepo)ReflectionHelper.possibleValueGetter(Lists.newArrayList((Object[])new Class[]{guiWCTClass, guiMEMonitorable}), gui, "repo");
    }

    public static ItemRepo getRepo(GuiMEMonitorable term) {
        return (ItemRepo)ReflectionHelper.getFieldValue(GuiMEMonitorable.class, term, "repo");
    }

    public static boolean isWirelessContainer(Container container) {
        return containerWirelessCraftingTermClass != null && containerWirelessCraftingTermClass.isInstance(container);
    }

    public static boolean isWirelessGui(GuiScreen gui) {
        return wirelessCraftingGuiClass != null && wirelessCraftingGuiClass.isInstance(gui);
    }

    public static boolean isWctGui(GuiScreen screen) {
        return guiWCTClass != null && guiWCTClass.isInstance(screen);
    }

    static {
        containerPatternEncoderClass = null;
        containerPatternTermClass = null;
        guiWCTClass = null;
        guiMEMonitorable = null;
        containerWirelessCraftingTermClass = null;
        wirelessCraftingGuiClass = null;
    }
}

