/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.helper;

import com.github.vfyjxf.nee.helper.RecipeAnalyzer;
import com.github.vfyjxf.nee.network.NEENetworkHandler;
import com.github.vfyjxf.nee.network.packet.PacketCraftingRequest;
import com.github.vfyjxf.nee.utils.IngredientStatus;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IngredientRequester {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final IngredientRequester INSTANCE = new IngredientRequester();
    private boolean isWireless;
    private boolean nonPreview;
    private List<RecipeAnalyzer.RecipeIngredient> requested;
    private int currentIndex;
    private boolean finished;

    private IngredientRequester() {
    }

    public static IngredientRequester getInstance() {
        return INSTANCE;
    }

    public boolean requestNext() {
        if (this.finished) {
            return false;
        }
        RecipeAnalyzer.RecipeIngredient ingredient = this.requested.get(this.currentIndex);
        try {
            NEENetworkHandler.getInstance().sendToServer((IMessage)new PacketCraftingRequest(ingredient.createAeStack(), this.nonPreview));
            ++this.currentIndex;
        }
        catch (Exception e) {
            LOGGER.error("Fail to request ingredient: {} ,try to request next ingredient.", (Object)ingredient.getIdentifier().func_82833_r());
            ++this.currentIndex;
            this.finished = this.currentIndex >= this.requested.size();
            return this.requestNext();
        }
        this.finished = this.currentIndex >= this.requested.size();
        return true;
    }

    public void setRequested(boolean isWireless, boolean nonPreview, List<RecipeAnalyzer.RecipeIngredient> ingredients) {
        this.isWireless = isWireless;
        this.nonPreview = nonPreview;
        this.requested = ingredients.stream().filter(ingredient -> ingredient.getStatus() == IngredientStatus.CRAFTABLE).collect(Collectors.toList());
        this.currentIndex = 0;
        this.finished = this.currentIndex >= this.requested.size();
    }
}

