/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.client.gui;

import appeng.client.gui.widgets.MEGuiTextField;
import com.github.vfyjxf.nee.client.gui.IInnerWidget;
import com.github.vfyjxf.nee.helper.RecipeHelper;
import com.github.vfyjxf.nee.jei.PatternTransferHandler;
import com.github.vfyjxf.nee.network.NEENetworkHandler;
import com.github.vfyjxf.nee.network.PlayerAction;
import com.github.vfyjxf.nee.network.packet.PacketPlayerAction;
import com.github.vfyjxf.nee.utils.ItemUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class QuickPusherWidget
extends Gui
implements IInnerWidget {
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private final GuiContainer screen;
    private final MEGuiTextField searchField;
    private final Map<String, PatternGroup> allGroups = new HashMap<String, PatternGroup>();
    private final Map<String, PatternGroup> recommend = new HashMap<String, PatternGroup>();
    private final Supplier<Boolean> craftingMode;
    private PatternGroup focusedGroup;
    private int scrollOffset;
    private int maxScroll;

    public QuickPusherWidget(int x, int y, int width, int height, GuiContainer screen, Supplier<Boolean> craftingMode) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.screen = screen;
        this.craftingMode = craftingMode;
        this.searchField = null;
    }

    @Override
    public void draw(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
    }

    @Override
    public void drawTooltips(Minecraft mc, int mouseX, int mouseY) {
    }

    @Override
    public boolean handleKeyPressed(char typedChar, int eventKey) {
        return false;
    }

    @Override
    public boolean handleMouseClicked(int eventButton, int mouseX, int mouseY) {
        return false;
    }

    public void syncFromServer(NBTTagCompound tag) {
        this.allGroups.clear();
        this.recommend.clear();
        for (String uid : tag.func_150296_c()) {
            NBTTagCompound faceTag = tag.func_74775_l(uid);
            String name = faceTag.func_74779_i("name");
            PatternGroup group = this.allGroups.computeIfAbsent(name, PatternGroup::new);
            NBTTagCompound patternTag = faceTag.func_74775_l("pattern");
            ItemStack[] patterns = new ItemStack[patternTag.func_74762_e("size")];
            for (int i = 0; i < patterns.length; ++i) {
                patterns[i] = ItemUtils.fromTagOrEmpty(patternTag.func_74775_l("#" + i));
            }
            ItemStack identity = ItemUtils.fromTagOrEmpty(faceTag.func_74775_l("identity"));
            ItemStack target = ItemUtils.fromTagOrEmpty(faceTag.func_74775_l("target"));
            ClientPatternProvider provider = new ClientPatternProvider(uid, name, patterns, identity, target);
            group.getProviders().add(provider);
            if (!this.isRecommend(provider)) continue;
            this.recommend.computeIfAbsent(name, PatternGroup::new).getProviders().add(provider);
        }
    }

    private boolean isRecommend(ClientPatternProvider provider) {
        if (this.craftingMode.get().booleanValue()) {
            return RecipeHelper.checkCatalysts(provider.getTarget(), "minecraft.crafting");
        }
        return RecipeHelper.checkCatalysts(provider.getTarget(), PatternTransferHandler.getLastRecipeType());
    }

    public static class ClientPatternProvider {
        private final String uid;
        private final String name;
        private final ItemStack identifier;
        private final ItemStack target;
        private final ItemStack[] patterns;

        public ClientPatternProvider(String uid, String name, ItemStack[] patterns, ItemStack identifier, ItemStack target) {
            this.uid = uid;
            this.name = name;
            this.identifier = identifier;
            this.target = target;
            this.patterns = patterns;
        }

        public String getName() {
            return this.name;
        }

        public ItemStack getIdentifier() {
            return this.identifier;
        }

        public ItemStack getTarget() {
            return this.target;
        }

        public ItemStack[] getPatterns() {
            return this.patterns;
        }

        public void pickPattern(int slot) {
            NBTTagCompound data = new NBTTagCompound();
            data.func_74778_a("uid", this.uid);
            data.func_74768_a("slot", slot);
            NEENetworkHandler.getInstance().sendToServer((IMessage)new PacketPlayerAction(PlayerAction.PICK, data));
        }

        public void putPattern(ItemStack pattern, int slot) {
            NBTTagCompound data = new NBTTagCompound();
            data.func_74778_a("uid", this.uid);
            data.func_74768_a("slot", slot);
            data.func_74782_a("pattern", (NBTBase)pattern.serializeNBT());
            NEENetworkHandler.getInstance().sendToServer((IMessage)new PacketPlayerAction(PlayerAction.PUT, data));
        }

        public void dropPattern(int slot) {
            NBTTagCompound data = new NBTTagCompound();
            data.func_74778_a("uid", this.uid);
            data.func_74768_a("slot", slot);
            NEENetworkHandler.getInstance().sendToServer((IMessage)new PacketPlayerAction(PlayerAction.DROP, data));
        }

        public boolean isFull() {
            return Arrays.stream(this.patterns).noneMatch(Objects::nonNull);
        }
    }

    public static class PatternGroup
    extends Gui
    implements IInnerWidget {
        private final String groupName;
        private final List<ClientPatternProvider> providers;
        private boolean focused;

        public PatternGroup(String groupName) {
            this.groupName = groupName;
            this.providers = new ArrayList<ClientPatternProvider>();
        }

        public String getGroupName() {
            return this.groupName;
        }

        public List<ClientPatternProvider> getProviders() {
            return this.providers;
        }

        @Override
        public boolean isFocused() {
            return this.focused;
        }

        @Override
        public void setFocused(boolean focused) {
            this.focused = focused;
        }

        @Override
        public void draw(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        }

        @Override
        public void drawTooltips(Minecraft mc, int mouseX, int mouseY) {
        }

        @Override
        public boolean handleKeyPressed(char typedChar, int eventKey) {
            return false;
        }

        @Override
        public boolean handleMouseClicked(int eventButton, int mouseX, int mouseY) {
            return false;
        }
    }
}

