/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.client;

import appeng.client.gui.implementations.GuiPatternTerm;
import appeng.container.slot.SlotFake;
import com.github.vfyjxf.nee.client.gui.IngredientSwitcherWidget;
import com.github.vfyjxf.nee.client.gui.widgets.MergeConfigButton;
import com.github.vfyjxf.nee.config.NEEConfig;
import com.github.vfyjxf.nee.helper.CraftingHelper;
import com.github.vfyjxf.nee.helper.RecipeAnalyzer;
import com.github.vfyjxf.nee.jei.PatternTransferHandler;
import com.github.vfyjxf.nee.utils.ItemUtils;
import java.lang.reflect.Method;
import java.util.List;
import mezz.jei.gui.recipes.RecipesGui;
import mezz.jei.input.MouseHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiEventHandler {
    private static final GuiEventHandler INSTANCE = new GuiEventHandler();
    private MergeConfigButton buttonCombination;
    private IngredientSwitcherWidget switcherWidget;

    public static GuiEventHandler getInstance() {
        return INSTANCE;
    }

    private GuiEventHandler() {
    }

    @SubscribeEvent
    public void beforeScreenInit(GuiScreenEvent.InitGuiEvent.Pre event) {
        GuiScreen screen = event.getGui();
        if (screen instanceof RecipesGui) {
            RecipesGui recipesGui = (RecipesGui)screen;
            GuiScreen parent = recipesGui.getParentScreen();
            if (CraftingHelper.isSupportedGui(parent)) {
                RecipeAnalyzer.setCleanCache(true);
            }
        } else {
            RecipeAnalyzer.setCleanCache(false);
        }
    }

    @SubscribeEvent
    public void onMouseInput(GuiScreenEvent.MouseInputEvent.Pre event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (this.handleMouseInput(mc.field_71462_r)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onKeyboardInput(GuiScreenEvent.KeyboardInputEvent.Pre event) {
        char typedChar = Keyboard.getEventCharacter();
        int eventKey = Keyboard.getEventKey();
        event.setCanceled((eventKey == 0 && typedChar >= ' ' || Keyboard.getEventKeyState()) && this.handleKeyInput(typedChar, eventKey, event.getGui()));
    }

    private boolean handleMouseInput(GuiScreen screen) {
        return this.handleSwitcherMouseInput(screen);
    }

    private boolean handleKeyInput(char typedChar, int eventKey, GuiScreen screen) {
        return this.handleSwitcherKeyInput(typedChar, eventKey);
    }

    private boolean handleSwitcherMouseInput(GuiScreen screen) {
        if (screen instanceof GuiPatternTerm) {
            List<ItemStack> ingredients;
            Slot slot;
            GuiPatternTerm patternTerm = (GuiPatternTerm)screen;
            if (GuiScreen.func_146272_n() && Mouse.getEventButton() == 2 && (slot = patternTerm.getSlotUnderMouse()) instanceof SlotFake && slot.func_75216_d() && (ingredients = PatternTransferHandler.getSwitcherData().get("#" + slot.getSlotIndex())) != null) {
                ItemStack slotStack = slot.func_75211_c();
                boolean findAny = ingredients.stream().anyMatch(itemStack -> ItemUtils.matches(slotStack, itemStack));
                if (findAny) {
                    this.switcherWidget = new IngredientSwitcherWidget(slot.field_75223_e + patternTerm.getGuiLeft() + 18, slot.field_75221_f, 94, 97, ingredients, (GuiContainer)patternTerm, slot, () -> {
                        this.switcherWidget = null;
                    });
                    return true;
                }
            }
        }
        if (screen != null && screen.field_146297_k != null) {
            int mouseX = MouseHelper.getX();
            int mouseY = MouseHelper.getY();
            int eventButton = Mouse.getEventButton();
            if (eventButton > -1 && Mouse.getEventButtonState()) {
                if (this.switcherWidget != null) {
                    return this.switcherWidget.handleMouseClicked(eventButton, mouseX, mouseY);
                }
            } else if (Mouse.getEventDWheel() != 0) {
                return this.handleMouseScroll(Mouse.getEventDWheel(), mouseX, mouseY);
            }
        }
        return false;
    }

    private boolean handleSwitcherKeyInput(char typedChar, int eventKey) {
        return this.switcherWidget != null && this.switcherWidget.handleKeyPressed(typedChar, eventKey);
    }

    private boolean handleMouseScroll(int dWheel, int mouseX, int mouseY) {
        if (this.switcherWidget != null) {
            return this.switcherWidget.mouseScroll(dWheel, mouseX, mouseY);
        }
        return false;
    }

    @SubscribeEvent
    public void onTooltipRender(RenderTooltipEvent.Pre event) {
        if (this.switcherWidget != null) {
            event.setCanceled(!this.switcherWidget.isRenderingTooltip());
        }
    }

    @SubscribeEvent
    public void onInitGui(GuiScreenEvent.InitGuiEvent.Post event) {
        if (event.getGui() instanceof GuiPatternTerm) {
            GuiPatternTerm gui = (GuiPatternTerm)event.getGui();
            this.buttonCombination = new MergeConfigButton(gui.getGuiLeft() + 84, gui.getGuiTop() + gui.getYSize() - 163, NEEConfig.getMergeMode());
            event.getButtonList().add(this.buttonCombination);
        }
    }

    @SubscribeEvent
    public void onDrawScreen(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (event.getGui() instanceof GuiPatternTerm) {
            try {
                Container container = ((GuiPatternTerm)event.getGui()).field_147002_h;
                Method saveMethod = container.getClass().getMethod("isCraftingMode", new Class[0]);
                if (((Boolean)saveMethod.invoke((Object)container, new Object[0])).booleanValue()) {
                    this.buttonCombination.field_146124_l = false;
                    this.buttonCombination.field_146125_m = false;
                } else {
                    this.buttonCombination.field_146124_l = true;
                    this.buttonCombination.field_146125_m = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.switcherWidget != null) {
                int mouseX = event.getMouseX();
                int mouseY = event.getMouseY();
                Minecraft mc = event.getGui().field_146297_k;
                if (this.switcherWidget.isMouseOverSlot(mouseX, mouseY) || this.switcherWidget.isMouseOver(mouseX, mouseY)) {
                    this.switcherWidget.draw(mc, event.getMouseX(), event.getMouseY(), event.getRenderPartialTicks());
                } else {
                    this.switcherWidget = null;
                }
            }
        } else {
            this.switcherWidget = null;
        }
    }
}

