/*
 * Decompiled with CFR 0.152.
 */
package com.Denfop.ssp.tiles;

import com.Denfop.ssp.gui.BackgroundlessDynamicGUI;
import com.Denfop.ssp.tiles.InvSlotMultiCharge;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import ic2.core.ContainerBase;
import ic2.core.IHasGui;
import ic2.core.block.ITeBlock;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlot;
import ic2.core.gui.dynamic.DynamicContainer;
import ic2.core.gui.dynamic.GuiParser;
import ic2.core.gui.dynamic.IGuiValueProvider;
import ic2.core.init.Localization;
import ic2.core.network.GuiSynced;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileEntityMoonPanel
extends TileEntityInventory
implements IEnergySource,
IHasGui,
IGuiValueProvider {
    public final int maxStorage;
    protected final int nightPower;
    protected final int tier;
    protected final InvSlotMultiCharge chargeSlots;
    private final double tierPower;
    @GuiSynced
    public int storage;
    @GuiSynced
    protected GenerationState active = GenerationState.NONE;
    protected int ticker;
    protected boolean canRain;
    protected boolean hasSky;
    private boolean addedToEnet;

    public TileEntityMoonPanel(SolarConfig config) {
        this(config.nightPower, config.storage, config.tier);
    }

    public TileEntityMoonPanel(int nightPower, int storage, int tier) {
        this.nightPower = nightPower;
        this.maxStorage = storage;
        this.tier = tier;
        this.tierPower = EnergyNet.instance.getPowerFromTier(tier);
        this.chargeSlots = new InvSlotMultiCharge(this, tier, 4, InvSlot.Access.IO);
    }

    protected void onLoaded() {
        super.onLoaded();
        if (!this.field_145850_b.field_72995_K) {
            this.addedToEnet = !MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.canRain = this.field_145850_b.func_180494_b(this.field_174879_c).func_76738_d() || this.field_145850_b.func_180494_b(this.field_174879_c).func_76727_i() > 0.0f;
            this.hasSky = !this.field_145850_b.field_73011_w.func_177495_o();
        }
    }

    protected void onUnloaded() {
        super.onUnloaded();
        if (this.addedToEnet) {
            this.addedToEnet = MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.storage = nbt.func_74762_e("storage");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("storage", this.storage);
        return nbt;
    }

    protected void updateEntityServer() {
        super.updateEntityServer();
        if (this.ticker++ % this.tickRate() == 0) {
            this.checkTheSky();
        }
        switch (this.active) {
            case NIGHT: {
                this.tryGenerateEnergy(this.nightPower);
            }
        }
        if (this.storage > 0) {
            this.storage = (int)((double)this.storage - this.chargeSlots.charge(this.storage));
        }
    }

    protected int tickRate() {
        return 128;
    }

    public void checkTheSky() {
        this.active = this.hasSky && this.field_145850_b.func_175710_j(this.field_174879_c.func_177984_a()) ? (this.field_145850_b.func_72935_r() && (!this.canRain || !this.field_145850_b.func_72896_J() && !this.field_145850_b.func_72911_I()) ? GenerationState.NONE : GenerationState.NIGHT) : GenerationState.NONE;
    }

    public void tryGenerateEnergy(int amount) {
        this.storage = this.storage + amount <= this.maxStorage ? (this.storage += amount) : this.maxStorage;
    }

    public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing side) {
        return true;
    }

    public int getSourceTier() {
        return this.tier;
    }

    public double getOfferedEnergy() {
        return (double)this.storage < this.tierPower ? (double)this.storage : this.tierPower;
    }

    public void drawEnergy(double amount) {
        this.storage = (int)((double)this.storage - amount);
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, List<String> tooltip, ITooltipFlag advanced) {
        super.addInformation(stack, tooltip, advanced);
        tooltip.add(Localization.translate((String)"ic2.item.tooltip.PowerTier", (Object[])new Object[]{this.tier}));
    }

    public ContainerBase<? extends TileEntityMoonPanel> getGuiContainer(EntityPlayer player) {
        return DynamicContainer.create((IInventory)this, (EntityPlayer)player, (GuiParser.GuiNode)GuiParser.parse((ITeBlock)this.teBlock));
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer player, boolean isAdmin) {
        return BackgroundlessDynamicGUI.create(this, player, GuiParser.parse((ITeBlock)this.teBlock));
    }

    public void onGuiClosed(EntityPlayer player) {
    }

    public double getGuiValue(String name) {
        if ("progress".equals(name)) {
            return this.storage / this.maxStorage;
        }
        throw new IllegalArgumentException("Unexpected GUI value requested: " + name);
    }

    public boolean getGuiState(String name) {
        if ("moonlight".equals(name)) {
            return this.active == GenerationState.NIGHT;
        }
        return super.getGuiState(name);
    }

    public String getMaxOutput() {
        return String.format("%s %.0f %s", Localization.translate((String)"super_solar_panels.gui.maxOutput"), EnergyNet.instance.getPowerFromTier(this.tier + 1), Localization.translate((String)"ic2.generic.text.EUt"));
    }

    public String getOutput() {
        switch (this.active) {
            case NIGHT: {
                return String.format("%s %d %s", Localization.translate((String)"super_solar_panels.gui.generating"), this.nightPower, Localization.translate((String)"ic2.generic.text.EUt"));
            }
        }
        return String.format("%s 0 %s", Localization.translate((String)"super_solar_panels.gui.generating"), Localization.translate((String)"ic2.generic.text.EUt"));
    }

    public static final class SolarConfig {
        public final int nightPower;
        final int storage;
        final int tier;

        public SolarConfig(int nightPower, int storage, int tier) {
            this.nightPower = nightPower;
            this.storage = storage;
            this.tier = tier;
        }
    }

    public static enum GenerationState {
        NONE,
        NIGHT;

    }
}

