/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.persistence;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MultiblockWorldSavedData {
    @SideOnly(value=Side.CLIENT)
    public static final ThreadLocal<Boolean> isBuildingChunk = ThreadLocal.withInitial(() -> Boolean.FALSE);
    @SideOnly(value=Side.CLIENT)
    public static final Set<BlockPos> modelDisabled = new HashSet<BlockPos>();
    @SideOnly(value=Side.CLIENT)
    public static final Map<BlockPos, Collection<BlockPos>> multiDisabled = new HashMap<BlockPos, Collection<BlockPos>>();

    public static void clearDisabled() {
        modelDisabled.clear();
        multiDisabled.clear();
    }

    @SideOnly(value=Side.CLIENT)
    public static void removeDisableModel(BlockPos controllerPos) {
        Collection<BlockPos> poses = multiDisabled.remove(controllerPos);
        if (poses == null) {
            return;
        }
        modelDisabled.clear();
        multiDisabled.values().forEach(modelDisabled::addAll);
        MultiblockWorldSavedData.updateRenderChunk(poses);
    }

    @SideOnly(value=Side.CLIENT)
    private static void updateRenderChunk(Collection<BlockPos> poses) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world != null) {
            for (BlockPos pos : poses) {
                world.func_147458_c(pos.func_177958_n() - 1, pos.func_177956_o() - 1, pos.func_177952_p() - 1, pos.func_177958_n() + 1, pos.func_177956_o() + 1, pos.func_177952_p() + 1);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void addDisableModel(BlockPos controllerPos, Collection<BlockPos> poses) {
        multiDisabled.put(controllerPos, poses);
        modelDisabled.addAll(poses);
        MultiblockWorldSavedData.updateRenderChunk(poses);
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isModelDisabled(BlockPos pos) {
        if (isBuildingChunk.get().booleanValue()) {
            return modelDisabled.contains(pos);
        }
        return false;
    }
}

