/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.mixin.vintagefix;

import com.llamalad7.mixinextras.sugar.Local;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import org.embeddedt.vintagefix.VintageFixClient;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={VintageFixClient.class}, remap=false)
public class MixinVintageFixClient {
    @Inject(method={"collectTextures"}, at={@At(value="INVOKE", target="Ljava/util/Set;iterator()Ljava/util/Iterator;")})
    private void injectCollectTextures(TextureStitchEvent.Pre event, CallbackInfo ci, @Local(name={"allTextures"}) Set<ResourceLocation> allTextures, @Local(name={"map"}) TextureMap map) {
        if (!FMLClientHandler.instance().hasOptifine()) {
            return;
        }
        String emissiveSuffix = MixinVintageFixClient.stellar_core$getEmissiveSuffix();
        allTextures.parallelStream().forEach(texture -> {
            String replacement;
            ResourceLocation resourceLocation = this.stellar_core$getResourceLocation((ResourceLocation)texture, map);
            Minecraft.func_71410_x().field_110450_ap.func_110589_b(resourceLocation);
            if (emissiveSuffix == null || emissiveSuffix.isEmpty()) {
                return;
            }
            String path = resourceLocation.func_110623_a();
            if (path.endsWith(replacement = emissiveSuffix + ".png")) {
                return;
            }
            Minecraft.func_71410_x().field_110450_ap.func_110589_b(new ResourceLocation(resourceLocation.func_110624_b(), path.replace(".png", replacement)));
        });
    }

    @Unique
    private ResourceLocation stellar_core$getResourceLocation(ResourceLocation loc, TextureMap map) {
        String path = loc.func_110623_a().toLowerCase();
        boolean absPath = path.startsWith("mcpatcher/") || path.startsWith("optifine/");
        return absPath ? new ResourceLocation(loc.func_110624_b(), loc.func_110623_a() + ".png") : new ResourceLocation(loc.func_110624_b(), String.format("%s/%s%s", map.getBasePath(), loc.func_110623_a(), ".png"));
    }

    @Unique
    private static String stellar_core$getEmissiveSuffix() {
        String suffixEmissive;
        Class<?> EmissiveTextures;
        try {
            EmissiveTextures = Class.forName("net.optifine.EmissiveTextures");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        try {
            suffixEmissive = (String)EmissiveTextures.getMethod("getSuffixEmissive", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Throwable e) {
            return null;
        }
        return suffixEmissive;
    }
}

