/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.mixin.mekanism;

import github.kasuminova.stellarcore.common.config.StellarCoreConfig;
import java.util.Collections;
import java.util.Set;
import mekanism.common.base.target.FluidHandlerTarget;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.EmitUtils;
import mekanism.common.util.PipeUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PipeUtils.class})
public class MixinPipeUtils {
    @Inject(method={"emit"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private static void emit(Set<EnumFacing> sides, FluidStack stack, TileEntity from, CallbackInfoReturnable<Integer> cir) {
        if (!StellarCoreConfig.PERFORMANCE.mekanism.pipeUtils) {
            return;
        }
        if (stack == null || stack.amount == 0) {
            cir.setReturnValue((Object)0);
            return;
        }
        FluidHandlerTarget target = new FluidHandlerTarget(stack);
        EmitUtils.forEachSide((World)from.func_145831_w(), (BlockPos)from.func_174877_v(), sides, (acceptor, side) -> {
            EnumFacing accessSide = side.func_176734_d();
            CapabilityUtils.runIfCap((ICapabilityProvider)acceptor, (Capability)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, (EnumFacing)accessSide, handler -> {
                if (PipeUtils.canFill((IFluidHandler)handler, (FluidStack)stack)) {
                    target.addHandler(accessSide, handler);
                }
            });
        });
        int curHandlers = target.getHandlers().size();
        if (curHandlers == 0) {
            cir.setReturnValue((Object)0);
            return;
        }
        cir.setReturnValue((Object)EmitUtils.sendToAcceptors(Collections.singleton(target), (int)curHandlers, (int)stack.amount, (Object)stack));
    }
}

