/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.mixin.ic2_energynet;

import github.kasuminova.stellarcore.common.config.StellarCoreConfig;
import github.kasuminova.stellarcore.common.util.StellarEnvironment;
import github.kasuminova.stellarcore.common.util.StellarLog;
import github.kasuminova.stellarcore.mixin.util.IC2EnergySyncCalcTask;
import github.kasuminova.stellarcore.mixin.util.IStellarEnergyCalculatorLeg;
import github.kasuminova.stellarcore.shaded.org.jctools.queues.MpmcArrayQueue;
import github.kasuminova.stellarcore.shaded.org.jctools.queues.atomic.MpscLinkedAtomicQueue;
import ic2.core.energy.grid.EnergyNetGlobal;
import ic2.core.energy.grid.EnergyNetLocal;
import ic2.core.energy.grid.Grid;
import ic2.core.energy.grid.IEnergyCalculator;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Queue;
import java.util.concurrent.ForkJoinPool;
import java.util.stream.IntStream;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(targets={"ic2.core.energy.grid.GridUpdater"}, remap=false)
public class MixinGridUpdater {
    @Shadow
    private boolean busy;
    @Shadow
    private boolean isChangeStep;
    @Shadow
    @Final
    private EnergyNetLocal enet;
    @Unique
    private static volatile MethodHandle stellar_core$gridCalcTaskConstructor = null;
    @Unique
    private static volatile MethodHandle stellar_core$gridCalcTaskGridSetter = null;
    @Unique
    private static volatile MethodHandle stellar_core$EnergyNetGlobal$getCalculator = null;
    @Unique
    private static volatile MethodHandle stellar_core$EnergyNetLocal$hasGrids = null;
    @Unique
    private static volatile MethodHandle stellar_core$EnergyNetLocal$getGrids = null;
    @Unique
    private static volatile MethodHandle stellar_core$EnergyNetLocal$shuffleGrids = null;
    @Unique
    private final Queue<IC2EnergySyncCalcTask> stellar_core$syncTaskQueue = MixinGridUpdater.stellar_core$createMpscQueue();

    @Inject(method={"startTransferCalc"}, at={@At(value="HEAD")}, cancellable=true)
    void startTransferCalc(CallbackInfo ci) {
        if (!StellarCoreConfig.PERFORMANCE.industrialCraft2.energyCalculatorLeg || !StellarEnvironment.shouldParallel()) {
            return;
        }
        ci.cancel();
        assert (!this.busy);
        this.isChangeStep = false;
        IEnergyCalculator energyCalculator = MixinGridUpdater.stellar_core$EnergyNetGlobal$getCalculator();
        if (!MixinGridUpdater.stellar_core$EnergyNetLocal$hasGrids(this.enet) || !energyCalculator.runSyncStep(this.enet)) {
            return;
        }
        this.busy = true;
        Collection<Grid> grids = MixinGridUpdater.stellar_core$EnergyNetLocal$getGrids(this.enet);
        IStellarEnergyCalculatorLeg stellarCalculator = (IStellarEnergyCalculatorLeg)energyCalculator;
        Queue<Grid> calculateQueue = MixinGridUpdater.stellar_core$createMpmcQueue(grids.size());
        calculateQueue.addAll(grids);
        int tasks = grids.size();
        ForkJoinPool.commonPool().submit(() -> {
            int concurrency = Math.min(tasks, Math.max(StellarEnvironment.getConcurrency(), 2));
            IntStream.range(0, concurrency).parallel().forEach(i -> {
                Grid grid;
                while ((grid = (Grid)calculateQueue.poll()) != null) {
                    this.stellar_core$syncTaskQueue.offer(stellarCalculator.doParallelCalc(grid));
                }
            });
        });
        this.stellar_core$executeSyncTasks(tasks, stellarCalculator, calculateQueue);
        if (!this.stellar_core$syncTaskQueue.isEmpty()) {
            StellarLog.LOG.warn("[StellarCore-IC2GridUpdater] Unable to complete all tasks, {} tasks left.", (Object)this.stellar_core$syncTaskQueue.size());
            this.stellar_core$syncTaskQueue.forEach(stellarCalculator::doSyncCalc);
            this.stellar_core$syncTaskQueue.clear();
        }
        this.busy = false;
    }

    @Unique
    private void stellar_core$executeSyncTasks(int totalTasks, IStellarEnergyCalculatorLeg stellarCalculator, Queue<Grid> calculateQueue) {
        int completedTask = 0;
        while (completedTask < totalTasks) {
            IC2EnergySyncCalcTask task;
            boolean syncBusy = true;
            while ((task = this.stellar_core$syncTaskQueue.poll()) != null) {
                stellarCalculator.doSyncCalc(task);
                ++completedTask;
                syncBusy = false;
            }
            if (MixinGridUpdater.stellar_core$helpComplete(stellarCalculator, calculateQueue)) {
                ++completedTask;
                syncBusy = false;
            }
            if (!syncBusy) continue;
            MixinGridUpdater.stellar_core$awaitCompletion();
        }
    }

    @Unique
    private static boolean stellar_core$helpComplete(IStellarEnergyCalculatorLeg stellarCalculator, Queue<Grid> calculateQueue) {
        Grid grid = calculateQueue.poll();
        if (grid != null) {
            stellarCalculator.doSyncCalc(stellarCalculator.doParallelCalc(grid));
            return true;
        }
        return false;
    }

    @Unique
    private static void stellar_core$awaitCompletion() {
        try {
            Thread.sleep(0L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Unique
    private static Object stellar_core$newGridCalcTask(Object gridUpdater) {
        if (stellar_core$gridCalcTaskConstructor == null) {
            Object object = gridUpdater;
            synchronized (object) {
                if (stellar_core$gridCalcTaskConstructor == null) {
                    try {
                        Constructor<?> constructor = Class.forName("ic2.core.energy.grid.GridUpdater$GridCalcTask").getDeclaredConstructor(Class.forName("ic2.core.energy.grid.GridUpdater"));
                        constructor.setAccessible(true);
                        stellar_core$gridCalcTaskConstructor = MethodHandles.lookup().unreflectConstructor(constructor);
                    }
                    catch (Throwable e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        try {
            return stellar_core$gridCalcTaskConstructor.invoke(gridUpdater);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Unique
    private static void stellar_core$setGridCalcTaskGrid(Object gridCalcTask, Grid grid) {
        if (stellar_core$gridCalcTaskGridSetter == null) {
            Object object = gridCalcTask;
            synchronized (object) {
                if (stellar_core$gridCalcTaskGridSetter == null) {
                    try {
                        Field gridField = Class.forName("ic2.core.energy.grid.GridUpdater$GridCalcTask").getDeclaredField("grid");
                        stellar_core$gridCalcTaskGridSetter = MethodHandles.lookup().unreflectSetter(gridField);
                    }
                    catch (Throwable e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        try {
            stellar_core$gridCalcTaskGridSetter.invoke(gridCalcTask, grid);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Unique
    private static IEnergyCalculator stellar_core$EnergyNetGlobal$getCalculator() {
        if (stellar_core$EnergyNetGlobal$getCalculator == null) {
            Class<EnergyNetGlobal> clazz = EnergyNetGlobal.class;
            // MONITORENTER : ic2.core.energy.grid.EnergyNetGlobal.class
            if (stellar_core$EnergyNetGlobal$getCalculator == null) {
                try {
                    stellar_core$EnergyNetGlobal$getCalculator = MethodHandles.lookup().unreflect(Class.forName("ic2.core.energy.grid.EnergyNetGlobal").getDeclaredMethod("getCalculator", new Class[0]));
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
            // MONITOREXIT : clazz
        }
        try {
            return stellar_core$EnergyNetGlobal$getCalculator.invoke();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Unique
    private static boolean stellar_core$EnergyNetLocal$hasGrids(EnergyNetLocal enet) {
        if (stellar_core$EnergyNetLocal$hasGrids == null) {
            Class<EnergyNetLocal> clazz = EnergyNetLocal.class;
            // MONITORENTER : ic2.core.energy.grid.EnergyNetLocal.class
            if (stellar_core$EnergyNetLocal$hasGrids == null) {
                try {
                    stellar_core$EnergyNetLocal$hasGrids = MethodHandles.lookup().unreflect(Class.forName("ic2.core.energy.grid.EnergyNetLocal").getDeclaredMethod("hasGrids", new Class[0]));
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
            // MONITOREXIT : clazz
        }
        try {
            return stellar_core$EnergyNetLocal$hasGrids.invoke(enet);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Unique
    private static Collection<Grid> stellar_core$EnergyNetLocal$getGrids(EnergyNetLocal enet) {
        if (stellar_core$EnergyNetLocal$getGrids == null) {
            Class<EnergyNetLocal> clazz = EnergyNetLocal.class;
            // MONITORENTER : ic2.core.energy.grid.EnergyNetLocal.class
            if (stellar_core$EnergyNetLocal$getGrids == null) {
                try {
                    stellar_core$EnergyNetLocal$getGrids = MethodHandles.lookup().unreflect(Class.forName("ic2.core.energy.grid.EnergyNetLocal").getDeclaredMethod("getGrids", new Class[0]));
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
            // MONITOREXIT : clazz
        }
        try {
            return stellar_core$EnergyNetLocal$getGrids.invoke(enet);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Unique
    private static void stellar_core$EnergyNetLocal$shuffleGrids(EnergyNetLocal enet) {
        if (stellar_core$EnergyNetLocal$shuffleGrids == null) {
            Class<EnergyNetLocal> clazz = EnergyNetLocal.class;
            // MONITORENTER : ic2.core.energy.grid.EnergyNetLocal.class
            if (stellar_core$EnergyNetLocal$shuffleGrids == null) {
                try {
                    stellar_core$EnergyNetLocal$shuffleGrids = MethodHandles.lookup().unreflect(Class.forName("ic2.core.energy.grid.EnergyNetLocal").getDeclaredMethod("shuffleGrids", new Class[0]));
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
            // MONITOREXIT : clazz
        }
        try {
            stellar_core$EnergyNetLocal$shuffleGrids.invoke(enet);
            return;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Unique
    private static <E> Queue<E> stellar_core$createMpscQueue() {
        return new MpscLinkedAtomicQueue();
    }

    @Unique
    private static <E> Queue<E> stellar_core$createMpmcQueue(int capacity) {
        return new MpmcArrayQueue(Math.max(capacity, 2));
    }
}

