/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.mixin.ic2_energynet;

import github.kasuminova.stellarcore.common.config.StellarCoreConfig;
import github.kasuminova.stellarcore.common.util.StellarEnvironment;
import github.kasuminova.stellarcore.mixin.util.AccessorGridData;
import github.kasuminova.stellarcore.mixin.util.IC2EnergySyncCalcTask;
import github.kasuminova.stellarcore.mixin.util.IStellarEnergyCalculatorLeg;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.energy.tile.IMultiEnergySource;
import ic2.core.IC2;
import ic2.core.energy.grid.EnergyNetLocal;
import ic2.core.energy.grid.EnergyNetSettings;
import ic2.core.energy.grid.Grid;
import ic2.core.energy.grid.Node;
import ic2.core.energy.grid.NodeType;
import ic2.core.energy.grid.Tile;
import ic2.core.energy.leg.EnergyCalculatorLeg;
import ic2.core.util.LogCategory;
import ic2.core.util.Util;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EnergyCalculatorLeg.class}, remap=false)
public abstract class MixinEnergyCalculatorLeg
implements IStellarEnergyCalculatorLeg {
    @Unique
    private static volatile MethodHandle stellar_core$distribute = null;
    @Unique
    private static volatile MethodHandle stellar_core$getData = null;

    @Shadow
    private static void applyCableEffects(Collection eventPaths, World world) {
    }

    @Inject(method={"runSyncStep(Lic2/core/energy/grid/EnergyNetLocal;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    public void runSyncStep(EnergyNetLocal enet, CallbackInfoReturnable<Boolean> cir) {
        if (!StellarCoreConfig.PERFORMANCE.industrialCraft2.energyCalculatorLeg || !StellarEnvironment.shouldParallel()) {
            return;
        }
        AtomicBoolean foundAny = new AtomicBoolean(false);
        enet.getSources().parallelStream().forEach(tile -> {
            double amount;
            int packets;
            IEnergySource source;
            block6: {
                block5: {
                    IMultiEnergySource multiSource;
                    double d;
                    source = (IEnergySource)tile.getMainTile();
                    packets = 1;
                    if (tile.isDisabled()) break block5;
                    amount = source.getOfferedEnergy();
                    if (d > 0.0 && (!(source instanceof IMultiEnergySource) || !(multiSource = (IMultiEnergySource)source).sendMultipleEnergyPackets() || (packets = multiSource.getMultipleEnergyPacketAmount()) > 0)) break block6;
                }
                tile.setSourceData(0.0, 0);
                return;
            }
            int tier = source.getSourceTier();
            if (tier < 0) {
                if (EnergyNetSettings.logGridCalculationIssues) {
                    IC2.log.warn(LogCategory.EnergyNet, "Tile %s reported an invalid tier (%d).", new Object[]{Util.toString((Object)source, (IBlockAccess)enet.getWorld(), (BlockPos)EnergyNet.instance.getPos((IEnergyTile)source)), tier});
                }
                tile.setSourceData(0.0, 0);
                return;
            }
            foundAny.set(true);
            double power = EnergyNet.instance.getPowerFromTier(tier);
            amount = Math.min(amount, power * (double)packets);
            tile.setSourceData(amount, packets);
        });
        cir.setReturnValue((Object)foundAny.get());
    }

    @Override
    @Unique
    public IC2EnergySyncCalcTask doParallelCalc(Grid grid) {
        AccessorGridData gridData = MixinEnergyCalculatorLeg.stellar_core$getData(grid);
        if (!gridData.isActive()) {
            return IC2EnergySyncCalcTask.EMPTY;
        }
        List<Node> activeSources = gridData.getActiveSources();
        Map<Node, MutableDouble> activeSinks = gridData.getActiveSinks();
        activeSources.clear();
        activeSinks.clear();
        int calcId = gridData.incrementCurrentCalcId();
        for (Node node : grid.getNodes()) {
            double d;
            Tile tile = node.getTile();
            if (tile.isDisabled()) continue;
            if (node.getType() == NodeType.Source && gridData.getEnergySourceToEnergyPathMap().containsKey(node) && tile.getAmount() > 0.0) {
                activeSources.add(node);
                continue;
            }
            if (node.getType() != NodeType.Sink) continue;
            double amount = ((IEnergySink)tile.getMainTile()).getDemandedEnergy();
            if (!(d > 0.0)) continue;
            activeSinks.put(node, new MutableDouble(amount));
        }
        if (activeSources.isEmpty() || activeSinks.isEmpty()) {
            return IC2EnergySyncCalcTask.EMPTY;
        }
        World world = grid.getEnergyNet().getWorld();
        return new IC2EnergySyncCalcTask(world, calcId, grid, gridData, activeSources, activeSinks);
    }

    @Override
    public void doSyncCalc(IC2EnergySyncCalcTask task) {
        int i;
        if (task == IC2EnergySyncCalcTask.EMPTY) {
            return;
        }
        World world = task.world();
        List<Node> activeSources = task.activeSources();
        Map<Node, MutableDouble> activeSinks = task.activeSinks();
        AccessorGridData gridData = task.gridData();
        int calcID = task.calcID();
        Grid grid = task.grid();
        Random rand = world.field_73012_v;
        boolean shufflePaths = (world.func_82737_E() & 3L) != 0L;
        int sourcesOffset = activeSources.size() > 1 ? rand.nextInt(activeSources.size()) : 0;
        for (i = sourcesOffset; i < activeSources.size() && !activeSinks.isEmpty(); ++i) {
            MixinEnergyCalculatorLeg.stellar_core$distribute(activeSources.get(i), gridData, shufflePaths, calcID, rand);
        }
        for (i = 0; i < sourcesOffset && !activeSinks.isEmpty(); ++i) {
            MixinEnergyCalculatorLeg.stellar_core$distribute(activeSources.get(i), gridData, shufflePaths, calcID, rand);
        }
        Set<Object> eventPaths = gridData.getEventPaths();
        if (!eventPaths.isEmpty()) {
            MixinEnergyCalculatorLeg.applyCableEffects(eventPaths, grid.getEnergyNet().getWorld());
            eventPaths.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Unique
    private static void stellar_core$distribute(Node srcNode, AccessorGridData gridData, boolean shufflePaths, int calcId, Random rand) {
        if (stellar_core$distribute == null) {
            Class<EnergyCalculatorLeg> clazz = EnergyCalculatorLeg.class;
            // MONITORENTER : ic2.core.energy.leg.EnergyCalculatorLeg.class
            if (stellar_core$distribute == null) {
                try {
                    stellar_core$distribute = MethodHandles.lookup().unreflect(EnergyCalculatorLeg.class.getDeclaredMethod("distribute", Node.class, Class.forName("ic2.core.energy.leg.EnergyCalculatorLeg$GridData"), Boolean.TYPE, Integer.TYPE, Random.class));
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
            // MONITOREXIT : clazz
        }
        try {
            stellar_core$distribute.invoke(srcNode, gridData, shufflePaths, calcId, rand);
            return;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Unique
    private static AccessorGridData stellar_core$getData(Grid grid) {
        if (stellar_core$getData == null) {
            Class<EnergyCalculatorLeg> clazz = EnergyCalculatorLeg.class;
            // MONITORENTER : ic2.core.energy.leg.EnergyCalculatorLeg.class
            if (stellar_core$getData == null) {
                try {
                    stellar_core$getData = MethodHandles.lookup().unreflect(EnergyCalculatorLeg.class.getDeclaredMethod("getData", Grid.class));
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
            // MONITOREXIT : clazz
        }
        try {
            return stellar_core$getData.invoke(grid);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

