/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.mixin.ic2;

import github.kasuminova.stellarcore.common.config.StellarCoreConfig;
import ic2.core.item.BaseElectricItem;
import ic2.core.item.ItemBattery;
import ic2.core.item.ItemIC2;
import ic2.core.ref.ItemName;
import ic2.core.util.Util;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.client.model.ModelLoader;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={ItemBattery.class})
public class MixinItemBattery
extends BaseElectricItem {
    @Shadow(remap=false)
    private static int maxLevel;

    public MixinItemBattery(ItemName name, double maxCharge, double transferLimit, int tier) {
        super(name, maxCharge, transferLimit, tier);
    }

    @Redirect(method={"registerModels"}, at=@At(value="INVOKE", target="Lnet/minecraftforge/client/model/ModelLoader;setCustomMeshDefinition(Lnet/minecraft/item/Item;Lnet/minecraft/client/renderer/ItemMeshDefinition;)V", remap=false), remap=false)
    private void redirectRegisterModels(Item item, ItemMeshDefinition meshDefinition, ItemName name) {
        ModelLoader.setCustomMeshDefinition((Item)item, stack -> {
            if (!StellarCoreConfig.FEATURES.ic2.electricItemNonDurability) {
                return meshDefinition.func_178113_a(stack);
            }
            NBTTagCompound tNBT = stack.func_77978_p();
            double charge = tNBT == null ? 0.0 : tNBT.func_74769_h("charge");
            double maxCharge = this.getMaxCharge(stack);
            int level = maxCharge > 0.0 ? (int)Math.round(Util.limit((double)(charge / maxCharge * (double)maxLevel), (double)0.0, (double)maxLevel)) : 0;
            return ItemIC2.getModelLocation((ItemName)name, (String)String.valueOf(level));
        });
    }
}

