/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.mixin.ic2;

import github.kasuminova.stellarcore.common.config.StellarCoreConfig;
import github.kasuminova.stellarcore.common.util.BlockPos2ValueMap;
import github.kasuminova.stellarcore.mixin.ic2.AccessorGridChange;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.tile.IEnergyTile;
import ic2.core.energy.grid.EnergyNetLocal;
import ic2.core.energy.grid.Tile;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import net.minecraft.util.math.BlockPos;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EnergyNetLocal.class}, remap=false)
public abstract class MixinEnergyNetLocal {
    @Final
    @Shadow
    @Mutable
    Map<BlockPos, Tile> registeredTiles;
    @Unique
    private final BlockPos2ValueMap<List<AccessorGridChange>> stellar_core$gridChangesMap = new BlockPos2ValueMap();
    @Unique
    private static final Object STELLAR_CORE$QUEUE_DELAY_CHANGE = MixinEnergyNetLocal.stellar_core$getQueueDelayChange();

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void injectInit(CallbackInfo ci) {
        if (!StellarCoreConfig.PERFORMANCE.industrialCraft2.energyNetLocal) {
            return;
        }
        this.registeredTiles = new BlockPos2ValueMap<Tile>();
    }

    @Inject(method={"getIoTile"}, at={@At(value="INVOKE", target="Ljava/util/Queue;iterator()Ljava/util/Iterator;")}, cancellable=true)
    private void injectGetIOTileBeforeScanQueue(BlockPos pos, CallbackInfoReturnable<IEnergyTile> cir) {
        if (!StellarCoreConfig.PERFORMANCE.industrialCraft2.getIoAndSubTile) {
            return;
        }
        List<AccessorGridChange> gridChanges = this.stellar_core$gridChangesMap.get(pos);
        if (gridChanges == null) {
            cir.setReturnValue(null);
            return;
        }
        gridChanges.stream().filter(gridChange -> gridChange.getPos().equals((Object)pos)).findFirst().ifPresent(gridChange -> cir.setReturnValue((Object)gridChange.getIoTile()));
    }

    @Inject(method={"getSubTile"}, at={@At(value="INVOKE", target="Ljava/util/Queue;iterator()Ljava/util/Iterator;")}, cancellable=true)
    private void injectGetSubTileBeforeScan(BlockPos pos, CallbackInfoReturnable<IEnergyTile> cir) {
        if (!StellarCoreConfig.PERFORMANCE.industrialCraft2.getIoAndSubTile) {
            return;
        }
        List<AccessorGridChange> gridChanges = this.stellar_core$gridChangesMap.get(pos);
        if (gridChanges == null) {
            cir.setReturnValue(null);
            return;
        }
        for (AccessorGridChange gridChange : gridChanges) {
            if (!gridChange.getPos().equals((Object)pos)) continue;
            List<IEnergyTile> subTiles = gridChange.getSubTiles();
            if (subTiles == null) {
                subTiles = Collections.singletonList(gridChange.getIoTile());
            }
            for (IEnergyTile subTile : subTiles) {
                if (!EnergyNet.instance.getPos(subTile).equals((Object)pos)) continue;
                cir.setReturnValue((Object)subTile);
                return;
            }
        }
    }

    @Redirect(method={"addTile", "removeTile"}, at=@At(value="INVOKE", target="Ljava/util/Queue;add(Ljava/lang/Object;)Z"))
    private boolean redirectQueueAdd(Queue<Object> instance, Object e) {
        if (e != STELLAR_CORE$QUEUE_DELAY_CHANGE && e instanceof AccessorGridChange) {
            AccessorGridChange gridChange = (AccessorGridChange)e;
            this.stellar_core$gridChangesMap.computeIfAbsent(gridChange.getPos(), key -> new ObjectArrayList()).add(gridChange);
        }
        return instance.add(e);
    }

    @Redirect(method={"removeTile"}, at=@At(value="INVOKE", target="Ljava/util/Queue;remove(Ljava/lang/Object;)Z"))
    private boolean redirectQueueRemove(Queue<Object> instance, Object e) {
        AccessorGridChange gridChange;
        List<AccessorGridChange> gridChanges;
        boolean removed = instance.remove(e);
        if (removed && e != STELLAR_CORE$QUEUE_DELAY_CHANGE && e instanceof AccessorGridChange && (gridChanges = this.stellar_core$gridChangesMap.get((gridChange = (AccessorGridChange)e).getPos())) != null) {
            gridChanges.remove(gridChange);
            if (gridChanges.isEmpty()) {
                this.stellar_core$gridChangesMap.remove(gridChange.getPos());
            }
        }
        return removed;
    }

    @Redirect(method={"onTickEnd"}, at=@At(value="INVOKE", target="Ljava/util/Queue;poll()Ljava/lang/Object;"))
    private Object redirectQueuePoll(Queue<Object> instance) {
        AccessorGridChange gridChange;
        List<AccessorGridChange> gridChanges;
        Object polled = instance.poll();
        if (polled != STELLAR_CORE$QUEUE_DELAY_CHANGE && polled instanceof AccessorGridChange && (gridChanges = this.stellar_core$gridChangesMap.get((gridChange = (AccessorGridChange)polled).getPos())) != null) {
            gridChanges.remove(gridChange);
            if (gridChanges.isEmpty()) {
                this.stellar_core$gridChangesMap.remove(gridChange.getPos());
            }
        }
        return polled;
    }

    @Unique
    private static Object stellar_core$getQueueDelayChange() {
        try {
            Field queueDelayChange = EnergyNetLocal.class.getDeclaredField("QUEUE_DELAY_CHANGE");
            queueDelayChange.setAccessible(true);
            return queueDelayChange.get(null);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

