/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.mixin.enderioconduits;

import crazypants.enderio.base.capability.ItemTools;
import crazypants.enderio.base.filter.item.IItemFilter;
import crazypants.enderio.conduits.conduit.item.IItemConduit;
import crazypants.enderio.conduits.conduit.item.NetworkedInventory;
import crazypants.enderio.util.Prep;
import github.kasuminova.stellarcore.common.config.StellarCoreConfig;
import github.kasuminova.stellarcore.mixin.enderioconduits.AccessorTarget;
import github.kasuminova.stellarcore.mixin.enderioconduits.InvokerNetworkedInventory;
import github.kasuminova.stellarcore.mixin.util.CachedItemConduit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={NetworkedInventory.class})
public abstract class MixinNetworkedInventory {
    @Nonnull
    @Shadow(remap=false)
    @Final
    private IItemConduit con;
    @Shadow(remap=false)
    @Final
    private static boolean EXECUTE;

    @Shadow(remap=false)
    protected abstract int insertIntoTargets(@Nonnull ItemStack var1);

    @Shadow(remap=false)
    protected abstract void onItemExtracted(int var1, int var2);

    @Shadow(remap=false)
    protected abstract Iterable<Object> getTargetIterator();

    @Shadow(remap=false)
    private static IItemFilter valid(IItemFilter filter) {
        return null;
    }

    @Shadow(remap=false)
    private static int positive(int x) {
        return 0;
    }

    @Unique
    private static int stellarcore$insertItemSimulate(NetworkedInventory targetInv, @Nonnull ItemStack item, IItemFilter filter) {
        InvokerNetworkedInventory inv = (InvokerNetworkedInventory)targetInv;
        if (!inv.callCanInsert() || Prep.isInvalid((ItemStack)item)) {
            return 0;
        }
        IItemHandler inventory = inv.callGetInventory();
        if (inventory == null) {
            return 0;
        }
        if (filter == null) {
            return MixinNetworkedInventory.stellarcore$simulateInsertItem(inventory, item);
        }
        if (filter.isLimited()) {
            int count = filter.getMaxCountThatPassesFilter(inventory, item);
            if (count <= 0) {
                return 0;
            }
            int maxInsert = ItemTools.getInsertLimit((IItemHandler)inventory, (ItemStack)item, (int)count);
            if (maxInsert <= 0) {
                return 0;
            }
            if (maxInsert < item.func_190916_E()) {
                item = item.func_77946_l();
                item.func_190920_e(maxInsert);
            }
        } else if (!filter.doesItemPassFilter(inventory, item)) {
            return 0;
        }
        return MixinNetworkedInventory.stellarcore$simulateInsertItem(inventory, item);
    }

    @Unique
    private static int stellarcore$simulateInsertItem(@Nullable IItemHandler inventory, @Nonnull ItemStack item) {
        if (inventory == null || Prep.isInvalid((ItemStack)item)) {
            return 0;
        }
        int startSize = item.func_190916_E();
        ItemStack res = ItemTools.insertItemStacked((IItemHandler)inventory, (ItemStack)item.func_77946_l(), (boolean)true);
        return startSize - res.func_190916_E();
    }

    @Inject(method={"doTransfer"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void doTransfer(IItemHandler inventory, ItemStack extractedItem, int slot, CallbackInfoReturnable<Boolean> cir) {
        if (!StellarCoreConfig.BUG_FIXES.enderIOConduits.cachedItemConduit) {
            return;
        }
        IItemConduit iItemConduit = this.con;
        if (!(iItemConduit instanceof CachedItemConduit)) {
            return;
        }
        CachedItemConduit cachedItemConduit = (CachedItemConduit)iItemConduit;
        if (!cachedItemConduit.getCachedStack().func_190926_b()) {
            cir.setReturnValue((Object)false);
            return;
        }
        int simulateInserted = this.stellarcore$insertIntoTargetsSimulate(extractedItem.func_77946_l());
        if (simulateInserted <= 0) {
            cir.setReturnValue((Object)false);
            return;
        }
        ItemStack extracted = inventory.extractItem(slot, simulateInserted, EXECUTE);
        int inserted = this.insertIntoTargets(extracted.func_77946_l());
        int notInserted = extracted.func_190916_E() - inserted;
        if (notInserted > 0) {
            ItemStack notInsertedStack = extracted.func_77946_l();
            notInsertedStack.func_190920_e(notInserted);
            cachedItemConduit.setCachedStack(notInsertedStack);
        }
        this.onItemExtracted(slot, inserted);
        cir.setReturnValue((Object)(inserted > 0 ? 1 : 0));
    }

    @Inject(method={"transferItems"}, at={@At(value="INVOKE", target="Lcrazypants/enderio/conduits/conduit/item/IItemConduit;getMaximumExtracted(Lnet/minecraft/util/EnumFacing;)I", remap=false)}, cancellable=true, remap=false)
    public void onTransferItems(CallbackInfoReturnable<Boolean> cir) {
        if (!StellarCoreConfig.BUG_FIXES.enderIOConduits.cachedItemConduit) {
            return;
        }
        IItemConduit iItemConduit = this.con;
        if (!(iItemConduit instanceof CachedItemConduit)) {
            return;
        }
        CachedItemConduit cachedItemConduit = (CachedItemConduit)iItemConduit;
        ItemStack cachedStack = cachedItemConduit.getCachedStack();
        if (cachedStack.func_190926_b()) {
            return;
        }
        int inserted = this.insertIntoTargets(cachedStack.func_77946_l());
        if (inserted == cachedStack.func_190916_E()) {
            cachedItemConduit.setCachedStack(ItemStack.field_190927_a);
            return;
        }
        if (inserted == 0) {
            cir.setReturnValue((Object)false);
            return;
        }
        cachedStack.func_190918_g(inserted);
    }

    @Unique
    private int stellarcore$insertIntoTargetsSimulate(@Nonnull ItemStack toInsert) {
        if (Prep.isInvalid((ItemStack)toInsert)) {
            return 0;
        }
        int totalToInsert = toInsert.func_190916_E();
        boolean matchedStickyOutput = false;
        for (Object targetObj : this.getTargetIterator()) {
            AccessorTarget target = (AccessorTarget)targetObj;
            NetworkedInventory inv = target.getInv();
            IItemFilter filter = MixinNetworkedInventory.valid(inv.getCon().getOutputFilter(inv.getConDir()));
            if (target.getStickyInput() && !matchedStickyOutput && filter != null) {
                matchedStickyOutput = filter.doesItemPassFilter(inv.getInventory(), toInsert);
            }
            if (target.getStickyInput() || !matchedStickyOutput) {
                toInsert.func_190918_g(MixinNetworkedInventory.positive(MixinNetworkedInventory.stellarcore$insertItemSimulate(inv, toInsert, filter)));
                if (!Prep.isInvalid((ItemStack)toInsert)) continue;
                break;
            }
            if (target.getStickyInput()) continue;
            break;
        }
        return totalToInsert - toInsert.func_190916_E();
    }
}

