/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.mixin.betterchat;

import com.llamalad7.betterchat.gui.GuiBetterChat;
import github.kasuminova.stellarcore.common.config.StellarCoreConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ChatLine;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiUtilRenderComponents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GuiBetterChat.class})
public abstract class MixinGuiBetterChat {
    @Unique
    private static final Pattern STELLAR_CORE$PATTERN = Pattern.compile("(?:\u00a77)?\\s+\\[+\\d+]");
    @Shadow(remap=false)
    @Final
    private List<ChatLine> drawnChatLines = new ArrayList<ChatLine>();
    @Shadow(remap=false)
    @Final
    private List<ChatLine> chatLines = new ArrayList<ChatLine>();
    @Shadow(remap=false)
    @Final
    private Minecraft mc;

    @Shadow
    public abstract float func_146244_h();

    @Shadow
    public abstract int func_146228_f();

    @Inject(method={"setChatLine"}, at={@At(value="HEAD")}, remap=false)
    private void compactMessage(ITextComponent chatComponent, int chatLineId, int updateCounter, boolean displayOnly, CallbackInfo ci) {
        if (!StellarCoreConfig.FEATURES.betterChat.messageCompat) {
            return;
        }
        int count = 1;
        int chatSize = MathHelper.func_76141_d((float)((float)this.func_146228_f() / this.func_146244_h()));
        List split = GuiUtilRenderComponents.func_178908_a((ITextComponent)chatComponent, (int)chatSize, (FontRenderer)this.mc.field_71466_p, (boolean)false, (boolean)false);
        ITextComponent textComponent = (ITextComponent)split.get(split.size() - 1);
        for (int i = 0; i < this.drawnChatLines.size(); ++i) {
            ChatLine chatLine = this.drawnChatLines.get(i);
            ITextComponent lineComponent = chatLine.func_151461_a();
            if (lineComponent.func_150254_d().trim().isEmpty() || !this.stellar_core$isMessageEqual(lineComponent.func_150259_f(), textComponent.func_150259_f())) continue;
            if (!lineComponent.func_150253_a().isEmpty()) {
                for (ITextComponent sibling : lineComponent.func_150253_a()) {
                    if (!STELLAR_CORE$PATTERN.matcher(sibling.func_150261_e()).matches()) continue;
                    count += Integer.parseInt(sibling.func_150261_e().replaceAll("(?:\u00a77)?\\D?", ""));
                    break;
                }
            }
            this.drawnChatLines.removeIf(chatLine1 -> split.contains(chatLine1.func_151461_a()) || chatLine1.equals(chatLine));
            this.chatLines.removeIf(chatLine1 -> chatLine1.func_151461_a().func_150261_e().equals(chatComponent.func_150261_e()));
            chatComponent.func_150257_a(new TextComponentString(" [" + count + "]").func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)));
            break;
        }
    }

    @Unique
    private boolean stellar_core$isMessageEqual(ITextComponent left, ITextComponent right) {
        if (left.equals(right) || left.func_150260_c().equals(right.func_150260_c())) {
            return true;
        }
        if (left.func_150253_a().isEmpty()) {
            return false;
        }
        left.func_150253_a().removeIf(sibling -> STELLAR_CORE$PATTERN.matcher(sibling.func_150261_e()).matches());
        return left.equals(right) || left.func_150260_c().equals(right.func_150260_c());
    }
}

