/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.mixin.astralsorcery;

import github.kasuminova.stellarcore.common.config.StellarCoreConfig;
import hellfirepvp.astralsorcery.common.constellation.perk.AbstractPerk;
import hellfirepvp.astralsorcery.common.constellation.perk.PerkConverter;
import hellfirepvp.astralsorcery.common.constellation.perk.PlayerAttributeMap;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.PerkAttributeModifier;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.PerkAttributeType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import net.minecraftforge.fml.relauncher.Side;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerAttributeMap.class})
public class MixinPlayerAttributeMap {
    @Shadow(remap=false)
    private Map<PerkAttributeType, List<PerkAttributeModifier>> attributes;
    @Shadow(remap=false)
    private Set<AbstractPerk> cacheAppliedPerks;
    @Shadow(remap=false)
    private List<PerkConverter> converters;

    @Inject(method={"<init>"}, at={@At(value="RETURN")}, remap=false)
    public void injectInit(Side side, CallbackInfo ci) {
        if (!StellarCoreConfig.BUG_FIXES.astralSorcery.playerAttributeMap) {
            return;
        }
        this.attributes = new ConcurrentHashMap<PerkAttributeType, List<PerkAttributeModifier>>();
        this.cacheAppliedPerks = Collections.newSetFromMap(new ConcurrentHashMap());
        this.converters = Collections.synchronizedList(new LinkedList());
    }

    @Redirect(method={"applyModifier"}, at=@At(value="INVOKE", target="Ljava/util/Map;computeIfAbsent(Ljava/lang/Object;Ljava/util/function/Function;)Ljava/lang/Object;", remap=false), remap=false)
    public Object redirectApplyModifierComputeIfAbsent(Map map, Object key, Function _f) {
        if (!StellarCoreConfig.BUG_FIXES.astralSorcery.playerAttributeMap) {
            return map.computeIfAbsent(key, t -> new ArrayList());
        }
        return map.computeIfAbsent(key, t -> new CopyOnWriteArrayList());
    }

    @Redirect(method={"removeModifier"}, at=@At(value="INVOKE", target="Ljava/util/Map;computeIfAbsent(Ljava/lang/Object;Ljava/util/function/Function;)Ljava/lang/Object;", remap=false), remap=false)
    public Object redirectRemoveModifierComputeIfAbsent(Map map, Object key, Function _f) {
        if (!StellarCoreConfig.BUG_FIXES.astralSorcery.playerAttributeMap) {
            return map.computeIfAbsent(key, t -> new ArrayList());
        }
        return map.computeIfAbsent(key, t -> new CopyOnWriteArrayList());
    }

    @Redirect(method={"getModifiersByType"}, at=@At(value="INVOKE", target="Ljava/util/Map;computeIfAbsent(Ljava/lang/Object;Ljava/util/function/Function;)Ljava/lang/Object;", remap=false), remap=false)
    public Object redirectGetModifiersByTypeComputeIfAbsent(Map map, Object key, Function _f) {
        if (!StellarCoreConfig.BUG_FIXES.astralSorcery.playerAttributeMap) {
            return map.computeIfAbsent(key, t -> new ArrayList());
        }
        return map.computeIfAbsent(key, t -> new CopyOnWriteArrayList());
    }
}

