/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.common.world;

import github.kasuminova.stellarcore.common.util.StellarEnvironment;
import github.kasuminova.stellarcore.shaded.org.jctools.queues.MpmcUnboundedXaddArrayQueue;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.Random;
import java.util.stream.IntStream;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.profiler.Profiler;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;

public class ParallelRandomBlockTicker {
    public static final ParallelRandomBlockTicker INSTANCE = new ParallelRandomBlockTicker();
    private final Queue<Tuple<Chunk, List<TickData>>> enqueuedChunks = new MpmcUnboundedXaddArrayQueue<Tuple<Chunk, List<TickData>>>(1000);
    private World currentWorld = null;
    private Random currentRand = null;
    private Profiler profiler = null;

    private ParallelRandomBlockTicker() {
    }

    public void enqueueChunk(Chunk chunk, List<TickData> data) {
        this.enqueuedChunks.offer((Tuple<Chunk, List<TickData>>)new Tuple((Object)chunk, data));
    }

    public void execute(World world, Random rand, Profiler profiler, int randomTickSpeed) {
        Queue<Tuple<Chunk, List<TickData>>> enqueuedChunks = this.enqueuedChunks;
        if (enqueuedChunks.isEmpty()) {
            return;
        }
        this.currentWorld = world;
        this.currentRand = rand;
        this.profiler = profiler;
        boolean parallel = StellarEnvironment.shouldParallel();
        int concurrency = parallel ? StellarEnvironment.getConcurrency() : 1;
        List randomTickData = parallel ? Collections.synchronizedList(new LinkedList()) : new LinkedList();
        IntStream stream = parallel ? IntStream.range(0, concurrency).parallel() : IntStream.range(0, concurrency);
        stream.forEach(i -> {
            Tuple data;
            while ((data = (Tuple)enqueuedChunks.poll()) != null) {
                ObjectArrayList collectedData = new ObjectArrayList();
                for (TickData tickData : (List)data.func_76340_b()) {
                    List<RandomTickTask> tasks = ParallelRandomBlockTicker.getRandomTickData((Chunk)data.func_76341_a(), tickData);
                    if (tasks.isEmpty()) continue;
                    collectedData.addAll(tasks);
                }
                if (collectedData.isEmpty()) continue;
                randomTickData.add(collectedData);
            }
        });
        for (List randomTickDatum : randomTickData) {
            this.executeTask(randomTickDatum);
        }
        enqueuedChunks.clear();
    }

    private static List<RandomTickTask> getRandomTickData(Chunk chunk, TickData tickData) {
        ExtendedBlockStorage storage = tickData.blockStorage();
        IntList lcgList = tickData.lcgList();
        int chunkXPos = chunk.field_76635_g << 4;
        int chunkZPos = chunk.field_76647_h << 4;
        ObjectArrayList enqueuedData = new ObjectArrayList(lcgList.size());
        IntListIterator it = lcgList.iterator();
        while (it.hasNext()) {
            int z;
            int y;
            int lcg = it.nextInt() >> 2;
            int x = lcg & 0xF;
            IBlockState blockState = storage.func_177485_a(x, y = lcg >> 16 & 0xF, z = lcg >> 8 & 0xF);
            Block block = blockState.func_177230_c();
            if (!block.func_149653_t()) continue;
            BlockPos pos = new BlockPos(x + chunkXPos, y + storage.func_76662_d(), z + chunkZPos);
            enqueuedData.add(new RandomTickTask(storage, pos, x, y, z));
        }
        return enqueuedData;
    }

    private void executeTask(List<RandomTickTask> tickDataList) {
        Profiler profiler = this.profiler;
        profiler.func_76320_a("randomTick");
        World world = this.currentWorld;
        Random rand = this.currentRand;
        for (RandomTickTask tickData : tickDataList) {
            ExtendedBlockStorage storage = tickData.storage();
            IBlockState blockState = storage.func_177485_a(tickData.storageX(), tickData.storageY(), tickData.storageZ());
            Block block = blockState.func_177230_c();
            if (!block.func_149653_t()) continue;
            block.func_180645_a(world, tickData.worldPos(), blockState, rand);
        }
        profiler.func_76319_b();
    }

    public static final class TickData {
        private final ExtendedBlockStorage blockStorage;
        private final IntList lcgList;

        public TickData(ExtendedBlockStorage blockStorage, IntList lcgList) {
            this.blockStorage = blockStorage;
            this.lcgList = lcgList;
        }

        public String toString() {
            return "TickData[" + "blockStorage=" + this.blockStorage + "," + "lcgList=" + this.lcgList + "]";
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (this.blockStorage != null ? this.blockStorage.hashCode() : 0);
            result = 31 * result + (this.lcgList != null ? this.lcgList.hashCode() : 0);
            return result;
        }

        public final boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0.getClass() != this.getClass()) {
                return false;
            }
            if (!Objects.equals(((TickData)arg0).blockStorage, this.blockStorage)) {
                return false;
            }
            return Objects.equals(((TickData)arg0).lcgList, this.lcgList);
            {
            }
        }

        public ExtendedBlockStorage blockStorage() {
            return this.blockStorage;
        }

        public IntList lcgList() {
            return this.lcgList;
        }
    }

    public static final class RandomTickTask {
        private final ExtendedBlockStorage storage;
        private final BlockPos worldPos;
        private final int storageX;
        private final int storageY;
        private final int storageZ;

        public RandomTickTask(ExtendedBlockStorage storage, BlockPos worldPos, int storageX, int storageY, int storageZ) {
            this.storage = storage;
            this.worldPos = worldPos;
            this.storageX = storageX;
            this.storageY = storageY;
            this.storageZ = storageZ;
        }

        public String toString() {
            return "RandomTickTask[" + "storage=" + this.storage + "," + "worldPos=" + this.worldPos + "," + "storageX=" + this.storageX + "," + "storageY=" + this.storageY + "," + "storageZ=" + this.storageZ + "]";
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (this.storage != null ? this.storage.hashCode() : 0);
            result = 31 * result + (this.worldPos != null ? this.worldPos.hashCode() : 0);
            result = 31 * result + this.storageX;
            result = 31 * result + this.storageY;
            result = 31 * result + this.storageZ;
            return result;
        }

        public final boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0.getClass() != this.getClass()) {
                return false;
            }
            if (!Objects.equals(((RandomTickTask)arg0).storage, this.storage)) {
                return false;
            }
            if (!Objects.equals(((RandomTickTask)arg0).worldPos, this.worldPos)) {
                return false;
            }
            if (((RandomTickTask)arg0).storageX != this.storageX) {
                return false;
            }
            if (((RandomTickTask)arg0).storageY != this.storageY) {
                return false;
            }
            return ((RandomTickTask)arg0).storageZ == this.storageZ;
            {
            }
        }

        public ExtendedBlockStorage storage() {
            return this.storage;
        }

        public BlockPos worldPos() {
            return this.worldPos;
        }

        public int storageX() {
            return this.storageX;
        }

        public int storageY() {
            return this.storageY;
        }

        public int storageZ() {
            return this.storageZ;
        }
    }
}

