/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.common.util;

import github.kasuminova.stellarcore.common.util.StellarLog;

public class StellarEnvironment {
    private static int processors = 0;

    public static void init() {
        processors = Runtime.getRuntime().availableProcessors();
        StellarLog.LOG.info("[StellarEnvironment] Processor count: {}", (Object)processors);
        if (!StellarEnvironment.shouldParallel()) {
            StellarLog.LOG.warn("[StellarEnvironment] Processor count is less than 3, parallel processing is disabled.");
        } else {
            StellarLog.LOG.info("[StellarEnvironment] Parallel execution is enabled.");
        }
    }

    public static boolean shouldParallel() {
        return processors > 2;
    }

    public static int getConcurrency() {
        return StellarEnvironment.shouldParallel() ? processors : 1;
    }
}

