/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class LinkedFakeArrayList<E>
extends ArrayList<E> {
    protected final LinkedList<E> internal;

    public LinkedFakeArrayList(int initialCapacity) {
        super(0);
        this.internal = new LinkedList();
    }

    public LinkedFakeArrayList() {
        this.internal = new LinkedList();
    }

    public LinkedFakeArrayList(Collection<? extends E> c) {
        super(0);
        this.internal = new LinkedList<E>(c);
    }

    @Override
    public int size() {
        return this.internal.size();
    }

    @Override
    public boolean isEmpty() {
        return this.internal.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.internal.contains(o);
    }

    @Override
    public int indexOf(Object o) {
        return this.internal.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.internal.lastIndexOf(o);
    }

    @Override
    public Object clone() {
        return new LinkedFakeArrayList<E>(this.internal);
    }

    @Override
    @Nonnull
    public Object[] toArray() {
        return this.internal.toArray();
    }

    @Override
    @Nonnull
    public <T> T[] toArray(T[] a) {
        return this.internal.toArray(a);
    }

    @Override
    public E get(int index) {
        return this.internal.get(index);
    }

    @Override
    public E set(int index, E element) {
        return this.internal.set(index, element);
    }

    @Override
    public boolean add(E e) {
        return this.internal.add(e);
    }

    @Override
    public void add(int index, E element) {
        this.internal.add(index, element);
    }

    @Override
    public E remove(int index) {
        return this.internal.remove(index);
    }

    @Override
    public boolean remove(Object o) {
        return this.internal.remove(o);
    }

    @Override
    public void clear() {
        this.internal.clear();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.internal.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        return this.internal.addAll(index, c);
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        ListIterator<E> it = this.internal.listIterator(fromIndex);
        int n = toIndex - fromIndex;
        for (int i = 0; i < n; ++i) {
            it.next();
            it.remove();
        }
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.internal.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.internal.retainAll(c);
    }

    @Override
    @Nonnull
    public ListIterator<E> listIterator(int index) {
        return this.internal.listIterator(index);
    }

    @Override
    @Nonnull
    public ListIterator<E> listIterator() {
        return this.internal.listIterator();
    }

    @Override
    @Nonnull
    public Iterator<E> iterator() {
        return this.internal.iterator();
    }

    @Override
    @Nonnull
    public List<E> subList(int fromIndex, int toIndex) {
        return this.internal.subList(fromIndex, toIndex);
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        this.internal.forEach(action);
    }

    @Override
    public Spliterator<E> spliterator() {
        return this.internal.spliterator();
    }

    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        return this.internal.removeIf(filter);
    }

    @Override
    public void replaceAll(UnaryOperator<E> operator) {
        this.internal.replaceAll(operator);
    }

    @Override
    public void sort(Comparator<? super E> c) {
        this.internal.sort(c);
    }

    @Override
    public boolean containsAll(@Nonnull Collection<?> c) {
        return this.internal.containsAll(c);
    }

    @Override
    public Stream<E> stream() {
        return this.internal.stream();
    }

    @Override
    public Stream<E> parallelStream() {
        return this.internal.parallelStream();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        return this.internal.equals(o);
    }

    @Override
    public int hashCode() {
        return this.internal.hashCode();
    }
}

