/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.common.util;

import github.kasuminova.stellarcore.common.config.StellarCoreConfig;
import github.kasuminova.stellarcore.common.util.StellarLog;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;

public class ContainerTECache {
    private static final Map<Class<? extends Container>, Function<Container, List<TileEntity>>> CACHE = new ConcurrentHashMap<Class<? extends Container>, Function<Container, List<TileEntity>>>();
    private static final Map<Class<?>, Map<Class<?>, List<Field>>> CLASS_FILED_TYPE_CACHE = new ConcurrentHashMap();

    public static List<TileEntity> getTileEntityList(Container container) {
        Function<Container, List<TileEntity>> func = CACHE.get(container.getClass());
        return func == null ? ContainerTECache.register(container.getClass()).apply(container) : func.apply(container);
    }

    public static Function<Container, List<TileEntity>> register(Class<? extends Container> cClass) {
        List<Field> availableFields = ContainerTECache.scanTileEntityField(cClass);
        Function<Container, List<TileEntity>> func = container -> {
            if (container == null) {
                return Collections.emptyList();
            }
            return availableFields.stream().map(field -> ContainerTECache.safeGetField(container, field, TileEntity.class)).filter(Objects::nonNull).collect(Collectors.toList());
        };
        if (StellarCoreConfig.DEBUG.enableDebugLog && !availableFields.isEmpty()) {
            StringBuilder sb = new StringBuilder("[DEBUG] Registered TileEntity container, available fields: \n");
            Iterator<Field> it = availableFields.iterator();
            while (it.hasNext()) {
                Field field = it.next();
                sb.append(field.getType().getName()).append(": ").append(field.getName());
                if (!it.hasNext()) continue;
                sb.append(";\n");
            }
            StellarLog.LOG.info(sb.toString());
        }
        CACHE.put(cClass, func);
        return func;
    }

    private static <T> T safeGetField(Object instance, Field field, Class<T> type) {
        try {
            Object obj = field.get(instance);
            if (type.isInstance(obj)) {
                return type.cast(obj);
            }
            if (StellarCoreConfig.DEBUG.enableDebugLog) {
                StellarLog.LOG.warn("[DEBUG] Field {} {} is not assignable to {}", field.getType(), (Object)field.getName(), (Object)type.getName());
            }
        }
        catch (Throwable e) {
            StellarLog.LOG.warn((Object)e);
        }
        return null;
    }

    public static List<Field> scanTileEntityField(Class<? extends Container> containerClass) {
        return ContainerTECache.scanTileEntityFieldRecursive(containerClass, TileEntity.class);
    }

    private static List<Field> scanTileEntityFieldRecursive(Class<?> aClass, Class<?> target) {
        Map cachedFieldMap = CLASS_FILED_TYPE_CACHE.computeIfAbsent(aClass, v -> new ConcurrentHashMap());
        List fieldCache = (List)cachedFieldMap.get(target);
        if (fieldCache != null) {
            return fieldCache;
        }
        ArrayList<Field> teFields = new ArrayList<Field>();
        try {
            Field[] fields = aClass.getDeclaredFields();
            if (StellarCoreConfig.DEBUG.enableDebugLog) {
                StellarLog.LOG.info("[StellarCore-DEBUG] Scanning fields for class {}, required: {}", (Object)aClass.getName(), (Object)target.getName());
            }
            for (Field field : fields) {
                boolean assignable = target.isAssignableFrom(field.getType());
                if (StellarCoreConfig.DEBUG.enableDebugLog) {
                    StellarLog.LOG.info("[StellarCore-DEBUG] Field: {} {} (targetAssignable = {})", (Object)field.getType().getName(), (Object)field.getName(), (Object)assignable);
                }
                if (!assignable) continue;
                field.setAccessible(true);
                teFields.add(field);
            }
        }
        catch (Throwable fields) {
            // empty catch block
        }
        try {
            Class<?> superClass = aClass.getSuperclass();
            if (superClass != null && superClass != Object.class) {
                List<Field> parentFields = ContainerTECache.scanTileEntityFieldRecursive(superClass, target);
                teFields.addAll(parentFields);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        cachedFieldMap.put(target, teFields);
        return teFields;
    }
}

