/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.common.pool;

import github.kasuminova.stellarcore.common.mod.Mods;
import github.kasuminova.stellarcore.common.pool.AsyncCanonicalizePoolBase;
import github.kasuminova.stellarcore.common.pool.CanonicalizeTask;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Locale;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import mirror.normalasm.api.NormalStringPool;
import net.minecraftforge.fml.common.Optional;
import zone.rong.loliasm.api.LoliStringPool;

public class ResourceLocationPool
extends AsyncCanonicalizePoolBase<String> {
    public static final ResourceLocationPool INSTANCE = new ResourceLocationPool();
    private final Object2ObjectOpenHashMap<String, String> lowerCasePool = new Object2ObjectOpenHashMap();
    private volatile long processedCount = 0L;

    private ResourceLocationPool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String canonicalize(@Nullable String target) {
        if (target == null) {
            return null;
        }
        Object2ObjectOpenHashMap<String, String> object2ObjectOpenHashMap = this.lowerCasePool;
        synchronized (object2ObjectOpenHashMap) {
            ++this.processedCount;
            return (String)this.lowerCasePool.computeIfAbsent((Object)target, key -> {
                String value = key.toLowerCase(Locale.ROOT);
                if (Mods.CENSORED_ASM.loaded()) {
                    this.canonicalizeFromLoliStringPool((String)key, value);
                } else if (Mods.FERMIUM_OR_BLAHAJ_ASM.loaded()) {
                    this.canonicalizeFromNormalStringPool((String)key, value);
                }
                return value;
            });
        }
    }

    @Override
    public void canonicalizeAsync(String target, Consumer<String> callback) {
        throw new UnsupportedOperationException("ResourceLocationPool does not supported yet.");
    }

    @Override
    public long getProcessedCount() {
        return this.processedCount;
    }

    @Override
    public int getUniqueCount() {
        return this.lowerCasePool.size();
    }

    @Override
    protected String getName() {
        return "ResourceLocationPool";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object2ObjectOpenHashMap<String, String> object2ObjectOpenHashMap = this.lowerCasePool;
        synchronized (object2ObjectOpenHashMap) {
            this.processedCount = 0L;
            this.lowerCasePool.clear();
        }
    }

    @Optional.Method(modid="loliasm")
    protected void canonicalizeFromLoliStringPool(String t, String ret) {
        this.worker.offer(new CanonicalizeTask<String>(() -> {
            String key = ResourceLocationPool.canonicalizeFromLoliStringPool(t);
            String value = ResourceLocationPool.canonicalizeFromLoliStringPool(ret);
            Object2ObjectOpenHashMap<String, String> object2ObjectOpenHashMap = this.lowerCasePool;
            synchronized (object2ObjectOpenHashMap) {
                this.lowerCasePool.put((Object)key, (Object)value);
            }
            return null;
        }, null));
    }

    @Optional.Method(modid="normalasm")
    protected void canonicalizeFromNormalStringPool(String t, String ret) {
        this.worker.offer(new CanonicalizeTask<String>(() -> {
            String key = ResourceLocationPool.canonicalizeFromNormalStringPool(t);
            String value = ResourceLocationPool.canonicalizeFromNormalStringPool(ret);
            Object2ObjectOpenHashMap<String, String> object2ObjectOpenHashMap = this.lowerCasePool;
            synchronized (object2ObjectOpenHashMap) {
                this.lowerCasePool.put((Object)key, (Object)value);
            }
            return null;
        }, null));
    }

    @Optional.Method(modid="loliasm")
    private static String canonicalizeFromLoliStringPool(String target) {
        return LoliStringPool.canonicalize((String)target);
    }

    @Optional.Method(modid="normalasm")
    private static String canonicalizeFromNormalStringPool(String target) {
        return NormalStringPool.canonicalize((String)target);
    }
}

