/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.client.util;

import github.kasuminova.stellarcore.common.mod.Mods;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.Function;
import mirror.normalasm.api.NormalStringPool;
import net.minecraftforge.fml.common.Optional;
import zone.rong.loliasm.api.LoliStringPool;

public class AutoCanonizingStringMap<V>
extends Object2ObjectOpenHashMap<String, V> {
    private Function<String, String> canonicalizer = null;

    public AutoCanonizingStringMap() {
    }

    public AutoCanonizingStringMap(Map<String, V> map) {
        super(map);
    }

    public V put(String key, V value) {
        Function<String, String> canonicalizer = this.getCanonicalizer();
        key = canonicalizer.apply(key);
        if (value instanceof String) {
            value = canonicalizer.apply((String)value);
        }
        return (V)super.put((Object)key, value);
    }

    private Function<String, String> getCanonicalizer() {
        if (this.canonicalizer == null) {
            this.canonicalizer = AutoCanonizingStringMap.initCanonicalizer();
        }
        return this.canonicalizer;
    }

    private static Function<String, String> initCanonicalizer() {
        if (Mods.CENSORED_ASM.loaded()) {
            return AutoCanonizingStringMap::canonicalizeFromLoliStringPool;
        }
        if (Mods.FERMIUM_OR_BLAHAJ_ASM.loaded()) {
            return AutoCanonizingStringMap::canonicalizeFromNormalStringPool;
        }
        throw new IllegalStateException("No valid StringPool implementation found!");
    }

    @Optional.Method(modid="loliasm")
    private static String canonicalizeFromLoliStringPool(String target) {
        return LoliStringPool.canonicalize((String)target);
    }

    @Optional.Method(modid="normalasm")
    private static String canonicalizeFromNormalStringPool(String target) {
        return NormalStringPool.canonicalize((String)target);
    }
}

