/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.client.pool;

import github.kasuminova.stellarcore.common.config.StellarCoreConfig;
import github.kasuminova.stellarcore.common.pool.AsyncCanonicalizePool;
import github.kasuminova.stellarcore.common.util.StellarLog;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.floats.FloatList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Collection;
import java.util.List;

public class TLMCubesItemPool
extends AsyncCanonicalizePool<List<Float>> {
    public static final TLMCubesItemPool INSTANCE = new TLMCubesItemPool();
    private final ObjectOpenHashSet<List<Float>> pool = new ObjectOpenHashSet();

    private TLMCubesItemPool() {
    }

    @Override
    protected List<Float> preProcess(List<Float> list) {
        return list instanceof FloatList ? list : new FloatArrayList((Collection)list);
    }

    @Override
    protected List<Float> canonicalizeInternal(List<Float> target) {
        return (List)this.pool.addOrGet(target);
    }

    @Override
    public void onClearPre() {
        if (StellarCoreConfig.PERFORMANCE.tlm.texturedQuadFloatCanonicalization) {
            StellarLog.LOG.info("[StellarCore-TLMPositionTextureVertexPool] {} PositionTextureVertex processed. {} Unique, {} Deduplicated.", (Object)this.getProcessedCount(), (Object)this.pool.size(), (Object)(this.getProcessedCount() - (long)this.pool.size()));
        }
    }

    @Override
    public void onClearPost() {
        if (StellarCoreConfig.PERFORMANCE.tlm.texturedQuadFloatCanonicalization) {
            StellarLog.LOG.info("[StellarCore-TLMPositionTextureVertexPool] Pool cleared.");
        }
    }

    @Override
    protected String getName() {
        return "TLMPositionTextureVertexPool";
    }

    @Override
    protected ObjectSet<List<Float>> getPoolKeySet() {
        return this.pool;
    }

    @Override
    protected void clearPool() {
        this.pool.clear();
        this.pool.trim();
        this.worker.stop();
    }
}

