/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.client.pool;

import github.kasuminova.stellarcore.common.config.StellarCoreConfig;
import github.kasuminova.stellarcore.common.pool.AsyncCanonicalizePool;
import github.kasuminova.stellarcore.common.pool.CanonicalizeWorker;
import github.kasuminova.stellarcore.common.util.StellarLog;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.floats.FloatArrays;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;

public class StellarUnpackedDataPool {
    private static final UnpackedDataPoolLevel1 POOL_LEVEL1 = new UnpackedDataPoolLevel1();
    private static final UnpackedDataPoolLevel2 POOL_LEVEL2 = new UnpackedDataPoolLevel2();
    private static final UnpackedDataPoolLevel3 POOL_LEVEL3 = new UnpackedDataPoolLevel3();
    private static final VertexDataPool VERTEX_POOL = new VertexDataPool();

    public static void canonicalizeAsync(float[][][] unpackedData, Consumer<float[][][]> callback) {
        POOL_LEVEL1.canonicalizeAsync(unpackedData, floatsL1 -> {
            int level = StellarUnpackedDataPool.getLevel();
            if (unpackedData != floatsL1 && level >= 2) {
                for (int i = 0; i < ((float[][][])floatsL1).length; ++i) {
                    float[][] floatsL2 = POOL_LEVEL2.canonicalize(floatsL1[i]);
                    if (floatsL1[i] == floatsL2) continue;
                    floatsL1[i] = floatsL2;
                    if (level < 3) continue;
                    for (int j = 0; j < floatsL1[i].length; ++j) {
                        floatsL1[i][j] = POOL_LEVEL3.canonicalize(floatsL1[i][j]);
                    }
                }
            }
            callback.accept((float[][][])floatsL1);
        });
    }

    public static float[][][] canonicalize(float[][][] data) {
        int level = StellarUnpackedDataPool.getLevel();
        if (level == 1) {
            return POOL_LEVEL1.canonicalize(data);
        }
        if (level == 2) {
            for (int i = 0; i < data.length; ++i) {
                data[i] = POOL_LEVEL2.canonicalize(data[i]);
            }
            return data;
        }
        if (level == 3) {
            for (int i = 0; i < data.length; ++i) {
                for (int j = 0; j < data[i].length; ++j) {
                    data[i][j] = POOL_LEVEL3.canonicalize(data[i][j]);
                }
            }
            return data;
        }
        StellarLog.LOG.warn("[StellarCore-UnpackedDataPool] Invalid canonicalization level: {}", (Object)level);
        return data;
    }

    public static void canonicalizeAsync(int[] data, Consumer<int[]> callback) {
        VERTEX_POOL.canonicalizeAsync(data, callback);
    }

    public static int[] canonicalize(int[] data) {
        return VERTEX_POOL.canonicalize(data);
    }

    private static int getLevel() {
        return StellarCoreConfig.PERFORMANCE.forge.unpackedBakedQuadDataCanonicalizationLevel;
    }

    private static List<UnpackedDataPool<?>> getCurrentPools() {
        List<UnpackedDataPool<?>> list;
        int canonicalizationLevel = StellarUnpackedDataPool.getLevel();
        switch (canonicalizationLevel) {
            case 1: {
                list = Collections.singletonList(POOL_LEVEL1);
                break;
            }
            case 2: {
                list = Arrays.asList(POOL_LEVEL1, POOL_LEVEL2);
                break;
            }
            case 3: {
                list = Arrays.asList(POOL_LEVEL1, POOL_LEVEL2, POOL_LEVEL3);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid canonicalization level: " + canonicalizationLevel);
            }
        }
        return list;
    }

    public static boolean update() {
        boolean changed = false;
        int level = StellarUnpackedDataPool.getLevel();
        if (level < 2 && !POOL_LEVEL2.getPoolKeySet().isEmpty()) {
            POOL_LEVEL2.clearAndTrim();
            StellarLog.LOG.info("[StellarCore-UnpackedDataPool] Level {} Pool cleared.", (Object)level);
            changed = true;
        }
        if (level < 3 && !POOL_LEVEL3.getPoolKeySet().isEmpty()) {
            POOL_LEVEL3.clearAndTrim();
            StellarLog.LOG.info("[StellarCore-UnpackedDataPool] Level {} Pool cleared.", (Object)level);
            changed = true;
        }
        for (UnpackedDataPool<?> currentPool : StellarUnpackedDataPool.getCurrentPools()) {
            CanonicalizeWorker worker = currentPool.getWorker();
            if (worker.isRunning()) continue;
            worker.start();
        }
        return changed;
    }

    public static void reset() {
        int canonicalizationLevel = StellarUnpackedDataPool.getLevel();
        long currentPoolProcessedCount = StellarUnpackedDataPool.getProcessedUnpackedDataCount();
        long uniqueCount = StellarUnpackedDataPool.getUnpackedDataUniqueCount();
        if (StellarCoreConfig.PERFORMANCE.forge.unpackedBakedQuadDataCanonicalization) {
            StellarLog.LOG.info("[StellarCore-UnpackedDataPool] {} UnpackedData processed. {} Unique, {} Deduplicated.", (Object)currentPoolProcessedCount, (Object)uniqueCount, (Object)(currentPoolProcessedCount - uniqueCount));
        }
        if (StellarCoreConfig.PERFORMANCE.forge.unpackedBakedQuadVertexDataCanonicalization || StellarCoreConfig.PERFORMANCE.vanilla.bakedQuadVertexDataCanonicalization) {
            StellarLog.LOG.info("[StellarCore-VertexDataPool] {} VertexData processed. {} Unique, {} Deduplicated.", (Object)VERTEX_POOL.getProcessedCount(), (Object)VERTEX_POOL.getUniqueCount(), (Object)(VERTEX_POOL.getProcessedCount() - (long)VERTEX_POOL.getUniqueCount()));
        }
        long start = System.currentTimeMillis();
        if (canonicalizationLevel >= 1) {
            POOL_LEVEL1.clear();
        } else {
            POOL_LEVEL1.clearAndTrim();
        }
        if (canonicalizationLevel >= 2) {
            POOL_LEVEL2.clear();
        } else {
            POOL_LEVEL2.clearAndTrim();
        }
        if (canonicalizationLevel >= 3) {
            POOL_LEVEL3.clear();
        } else {
            POOL_LEVEL3.clearAndTrim();
        }
        VERTEX_POOL.clear();
        StellarLog.LOG.info("[StellarCore-UnpackedDataPool] Pool reset in {}ms.", (Object)(System.currentTimeMillis() - start));
    }

    public static long getProcessedUnpackedDataCount() {
        return StellarUnpackedDataPool.getCurrentPools().stream().mapToLong(AsyncCanonicalizePool::getProcessedCount).sum();
    }

    public static int getUnpackedDataUniqueCount() {
        return StellarUnpackedDataPool.getCurrentPools().stream().mapToInt(AsyncCanonicalizePool::getUniqueCount).sum();
    }

    public static long getProcessedVertexDataCount() {
        return VERTEX_POOL.getProcessedCount();
    }

    public static int getVertexDataUniqueCount() {
        return VERTEX_POOL.getPoolKeySet().size();
    }

    static {
        StellarUnpackedDataPool.update();
    }

    public static class UnpackedDataPoolLevel1
    extends UnpackedDataPool<float[][][]> {
        @Override
        protected Hash.Strategy<float[][][]> getStrategy() {
            return FloatArray3DHashStrategy.INSTANCE;
        }

        @Override
        protected String getName() {
            return "UnpackedDataPool-L1";
        }
    }

    public static class UnpackedDataPoolLevel2
    extends UnpackedDataPool<float[][]> {
        @Override
        protected Hash.Strategy<float[][]> getStrategy() {
            return FloatArray2DHashStrategy.INSTANCE;
        }

        @Override
        protected String getName() {
            return "UnpackedDataPool-L2";
        }
    }

    public static class UnpackedDataPoolLevel3
    extends UnpackedDataPool<float[]> {
        @Override
        protected Hash.Strategy<float[]> getStrategy() {
            return FloatArrays.HASH_STRATEGY;
        }

        @Override
        protected String getName() {
            return "UnpackedDataPool-L3";
        }
    }

    public static class VertexDataPool
    extends AsyncCanonicalizePool<int[]> {
        private final ObjectOpenCustomHashSet<int[]> pool = new ObjectOpenCustomHashSet(IntArrays.HASH_STRATEGY);

        @Override
        protected int[] canonicalizeInternal(int[] target) {
            return (int[])this.pool.addOrGet((Object)target);
        }

        @Override
        protected String getName() {
            return "VertexDataPool";
        }

        @Override
        protected ObjectSet<int[]> getPoolKeySet() {
            return this.pool;
        }

        @Override
        protected void clearPool() {
            this.pool.clear();
        }
    }

    public static abstract class UnpackedDataPool<T>
    extends AsyncCanonicalizePool<T> {
        private final ObjectOpenCustomHashSet<T> pool = new ObjectOpenCustomHashSet(this.getStrategy());
        private boolean trim = false;

        protected abstract Hash.Strategy<T> getStrategy();

        @Override
        protected T canonicalizeInternal(T target) {
            return (T)this.pool.addOrGet(target);
        }

        @Override
        protected ObjectSet<T> getPoolKeySet() {
            return this.pool;
        }

        @Override
        protected void clearPool() {
            this.pool.clear();
            if (this.trim) {
                this.pool.trim();
                this.trim = false;
                this.getWorker().stop();
            }
        }

        protected void clearAndTrim() {
            this.trim = true;
            this.clear();
        }
    }

    private static class FloatArray2DHashStrategy
    implements Hash.Strategy<float[][]> {
        private static final FloatArray2DHashStrategy INSTANCE = new FloatArray2DHashStrategy();

        private FloatArray2DHashStrategy() {
        }

        public int hashCode(float[][] o) {
            return Arrays.deepHashCode((Object[])o);
        }

        public boolean equals(float[][] a, float[][] b) {
            return Arrays.deepEquals((Object[])a, (Object[])b);
        }
    }

    private static class FloatArray3DHashStrategy
    implements Hash.Strategy<float[][][]> {
        private static final FloatArray3DHashStrategy INSTANCE = new FloatArray3DHashStrategy();

        private FloatArray3DHashStrategy() {
        }

        public int hashCode(float[][][] o) {
            return Arrays.deepHashCode((Object[])o);
        }

        public boolean equals(float[][][] a, float[][][] b) {
            return Arrays.deepEquals((Object[])a, (Object[])b);
        }
    }
}

