/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.world.attributes;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.block.BlockMarble;
import hellfirepvp.astralsorcery.common.data.config.Config;
import hellfirepvp.astralsorcery.common.data.config.entry.ConfigEntry;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.world.WorldGenAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class GenAttributeMarble
extends WorldGenAttribute {
    private WorldGenMinable marbleMineable = null;
    private List<IBlockState> replaceableStates = null;
    private List<String> replaceableStatesSerialized = new ArrayList<String>();

    public GenAttributeMarble() {
        super(0);
        Config.addDynamicEntry(new ConfigEntry(ConfigEntry.Section.WORLDGEN, "marble"){

            @Override
            public void loadFromConfig(Configuration cfg) {
                String[] applicableReplacements = cfg.getStringList("ReplacementStates", this.getConfigurationSection(), new String[]{"minecraft:stone:0"}, "Defines the blockstates that may be replaced by marble when trying to generate marble. format: <modid>:<name>:<meta> - Use meta -1 for wildcard");
                GenAttributeMarble.this.replaceableStatesSerialized = Arrays.asList(applicableReplacements);
            }
        });
    }

    private void resolveReplaceableStates() {
        this.replaceableStates = new LinkedList<IBlockState>();
        for (String stateStr : this.replaceableStatesSerialized) {
            Integer meta;
            String[] spl = stateStr.split(":");
            if (spl.length != 3) {
                AstralSorcery.log.info("Skipping invalid replacement state: " + stateStr);
                continue;
            }
            String strMeta = spl[2];
            try {
                meta = Integer.parseInt(strMeta);
            }
            catch (NumberFormatException exc) {
                AstralSorcery.log.error("Skipping invalid replacement state: " + stateStr + " - Its 'meta' is not a number!");
                continue;
            }
            Block b = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(spl[0], spl[1]));
            if (b == null || b == Blocks.field_150350_a) {
                AstralSorcery.log.error("Skipping invalid replacement state: " + stateStr + " - The block does not exist!");
                continue;
            }
            if (meta == -1) {
                this.replaceableStates.addAll((Collection<IBlockState>)b.func_176194_O().func_177619_a());
                continue;
            }
            this.replaceableStates.add(b.func_176203_a(meta.intValue()));
        }
    }

    @Override
    public void generate(Random random, int chunkX, int chunkZ, World world) {
        if (this.replaceableStates == null) {
            this.resolveReplaceableStates();
            this.marbleMineable = new WorldGenMinable(BlocksAS.blockMarble.func_176223_P().func_177226_a(BlockMarble.MARBLE_TYPE, (Comparable)((Object)BlockMarble.MarbleBlockType.RAW)), Config.marbleVeinSize, s -> MiscUtils.getMatchingState(this.replaceableStates, s) != null);
        }
        for (int i = 0; i < Config.marbleAmount; ++i) {
            int rX = chunkX * 16 + random.nextInt(16);
            int rY = 50 + random.nextInt(10);
            int rZ = chunkZ * 16 + random.nextInt(16);
            BlockPos pos = new BlockPos(rX, rY, rZ);
            this.marbleMineable.func_180709_b(world, random, pos);
        }
    }
}

