/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.network.packet.server.tileupdate;

import hellfirepvp.astralsorcery.common.network.packet.server.tileupdate.PktTileWillUpdateRequest;
import hellfirepvp.astralsorcery.common.tile.TileWell;
import hellfirepvp.astralsorcery.common.util.block.PrecisionSingleFluidCapabilityTank;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PktTileWillUpdate
implements IMessage,
IMessageHandler<PktTileWillUpdate, PktTileWillUpdateRequest> {
    private BlockPos pos = null;
    private Fluid fluidType = null;
    private int amount = 0;
    private TankUpdateType tankUpdateType = null;

    public PktTileWillUpdate() {
    }

    public PktTileWillUpdate(BlockPos pos, Fluid fluidType, int amount) {
        this.pos = pos;
        this.fluidType = fluidType;
        this.amount = amount;
        this.tankUpdateType = TankUpdateType.TANK_UPDATE;
    }

    public PktTileWillUpdate(BlockPos pos, int amount) {
        this.pos = pos;
        this.amount = amount;
        this.tankUpdateType = TankUpdateType.AMOUNT_UPDATE;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        this.tankUpdateType = TankUpdateType.values()[buf.readByte()];
        switch (this.tankUpdateType) {
            case TANK_UPDATE: {
                this.fluidType = FluidRegistry.getFluid((String)ByteBufUtils.readUTF8String((ByteBuf)buf));
            }
            case AMOUNT_UPDATE: {
                this.amount = buf.readShort();
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos.func_177986_g());
        buf.writeByte(this.tankUpdateType.ordinal());
        switch (this.tankUpdateType) {
            case TANK_UPDATE: {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.fluidType.getName());
            }
            case AMOUNT_UPDATE: {
                buf.writeShort(this.amount);
            }
        }
    }

    public PktTileWillUpdateRequest onMessage(PktTileWillUpdate message, MessageContext ctx) {
        if (FMLCommonHandler.instance().getSide() != Side.CLIENT) {
            return null;
        }
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (!world.func_175667_e(message.pos)) {
            return null;
        }
        TileEntity te = world.func_175625_s(message.pos);
        if (!(te instanceof TileWell)) {
            return null;
        }
        TileWell well = (TileWell)te;
        PrecisionSingleFluidCapabilityTank tank = well.getTank();
        switch (message.tankUpdateType) {
            case TANK_UPDATE: {
                tank.setFluid(message.fluidType);
            }
            case AMOUNT_UPDATE: {
                if (tank.getTankFluid() == null) {
                    return new PktTileWillUpdateRequest(message.pos);
                }
                tank.setAmount(message.amount);
            }
        }
        return null;
    }

    public static enum TankUpdateType {
        AMOUNT_UPDATE,
        TANK_UPDATE;

    }
}

