/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.network.packet.server;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.client.gui.GuiJournalPerkTree;
import hellfirepvp.astralsorcery.client.gui.GuiJournalProgression;
import hellfirepvp.astralsorcery.client.gui.journal.GuiScreenJournal;
import hellfirepvp.astralsorcery.common.data.research.ProgressionTier;
import hellfirepvp.astralsorcery.common.data.research.ResearchProgression;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PktProgressionUpdate
implements IMessage,
IMessageHandler<PktProgressionUpdate, IMessage> {
    public int tier = -1;
    public boolean isProg = false;
    public boolean isPresent = false;

    public PktProgressionUpdate() {
        this.isPresent = false;
    }

    public PktProgressionUpdate(ResearchProgression prog) {
        this.tier = prog.getProgressId();
        this.isPresent = true;
    }

    public PktProgressionUpdate(ProgressionTier tier) {
        this.isProg = true;
        this.tier = tier.ordinal();
        this.isPresent = true;
    }

    public void fromBytes(ByteBuf buf) {
        this.tier = buf.readInt();
        this.isProg = buf.readBoolean();
        this.isPresent = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.tier);
        buf.writeBoolean(this.isProg);
        buf.writeBoolean(this.isPresent);
    }

    public IMessage onMessage(PktProgressionUpdate message, MessageContext ctx) {
        AstralSorcery.proxy.scheduleClientside(() -> {
            if (message.isPresent) {
                if (message.isProg) {
                    this.addProgressChatMessage();
                } else {
                    this.addResearchChatMessage(message.tier);
                }
            }
            this.closeAndRefreshJournal();
        });
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private void closeAndRefreshJournal() {
        GuiScreen open = Minecraft.func_71410_x().field_71462_r;
        if (open != null && open instanceof GuiScreenJournal && !(open instanceof GuiJournalPerkTree)) {
            Minecraft.func_71410_x().func_147108_a(null);
        }
        GuiJournalProgression.resetJournal();
    }

    @SideOnly(value=Side.CLIENT)
    private void addResearchChatMessage(int resId) {
        ResearchProgression prog = ResearchProgression.getById(resId);
        String tr = I18n.func_135052_a((String)prog.getTranslationKey(), (Object[])new Object[0]);
        String out = I18n.func_135052_a((String)"progress.gain.research.chat", (Object[])new Object[]{tr});
        out = TextFormatting.AQUA + out;
        Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TextComponentString(out));
    }

    @SideOnly(value=Side.CLIENT)
    private void addProgressChatMessage() {
        String out = TextFormatting.BLUE + I18n.func_135052_a((String)"progress.gain.progress.chat", (Object[])new Object[0]);
        Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TextComponentString(out));
    }
}

