/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.item.tool.wand;

import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingDepthParticle;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.common.base.RockCrystalHandler;
import hellfirepvp.astralsorcery.common.block.BlockCustomOre;
import hellfirepvp.astralsorcery.common.block.network.BlockCollectorCrystalBase;
import hellfirepvp.astralsorcery.common.constellation.ConstellationRegistry;
import hellfirepvp.astralsorcery.common.constellation.IMajorConstellation;
import hellfirepvp.astralsorcery.common.constellation.distribution.ConstellationSkyHandler;
import hellfirepvp.astralsorcery.common.data.world.WorldCacheManager;
import hellfirepvp.astralsorcery.common.data.world.data.RockCrystalBuffer;
import hellfirepvp.astralsorcery.common.item.base.ISpecialInteractItem;
import hellfirepvp.astralsorcery.common.item.base.IWandInteract;
import hellfirepvp.astralsorcery.common.item.base.render.INBTModel;
import hellfirepvp.astralsorcery.common.item.tool.wand.WandAugment;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.server.PktParticleEvent;
import hellfirepvp.astralsorcery.common.network.packet.server.PktShootEntity;
import hellfirepvp.astralsorcery.common.registry.RegistryItems;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.awt.Color;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemWand
extends Item
implements ISpecialInteractItem,
INBTModel {
    public static final Color wandBlue = new Color(791926);
    private static final Random rand = new Random();

    public ItemWand() {
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.func_77637_a(RegistryItems.creativeTabAstralSorcery);
        this.func_185043_a(new ResourceLocation("blocking"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return ItemWand.getAugment(stack) == WandAugment.ARMARA && entityIn != null && entityIn.func_184587_cr() && entityIn.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            items.add((Object)new ItemStack((Item)this));
            for (WandAugment wa : WandAugment.values()) {
                ItemStack wand = new ItemStack((Item)this);
                ItemWand.setAugment(wand, wa);
                items.add((Object)wand);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        WandAugment wa = ItemWand.getAugment(stack);
        if (wa != null) {
            tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)wa.getAssociatedConstellation().getTranslationKey(), (Object[])new Object[0]));
        }
    }

    @Override
    public List<ResourceLocation> getAllPossibleLocations(ModelResourceLocation defaultLocation) {
        LinkedList<ResourceLocation> out = new LinkedList<ResourceLocation>();
        out.add((ResourceLocation)defaultLocation);
        for (WandAugment wa : WandAugment.values()) {
            out.add(new ResourceLocation(defaultLocation.func_110624_b(), defaultLocation.func_110623_a() + "_" + wa.name().toLowerCase()));
        }
        return out;
    }

    @Override
    public ModelResourceLocation getModelLocation(ItemStack stack, ModelResourceLocation suggestedDefaultLocation) {
        WandAugment wa = ItemWand.getAugment(stack);
        if (wa != null) {
            return new ModelResourceLocation(new ResourceLocation(suggestedDefaultLocation.func_110624_b(), suggestedDefaultLocation.func_110623_a() + "_" + wa.name().toLowerCase()), suggestedDefaultLocation.func_177518_c());
        }
        return suggestedDefaultLocation;
    }

    @Nullable
    public static WandAugment getAugment(@Nonnull ItemStack stack) {
        NBTTagCompound cmp = NBTHelper.getPersistentData(stack);
        if (!cmp.func_74764_b("AugmentName")) {
            return null;
        }
        IMajorConstellation cst = ConstellationRegistry.getMajorConstellationByName(cmp.func_74779_i("AugmentName"));
        if (cst == null) {
            return null;
        }
        return WandAugment.getByConstellation(cst);
    }

    public static ItemStack setAugment(@Nonnull ItemStack stack, @Nonnull WandAugment augment) {
        NBTTagCompound cmp = NBTHelper.getPersistentData(stack);
        cmp.func_74778_a("AugmentName", augment.getAssociatedConstellation().getTranslationKey());
        return stack;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        WandAugment wa = ItemWand.getAugment(stack);
        if (wa != null) {
            if (wa.equals((Object)WandAugment.ARMARA)) {
                return EnumAction.BLOCK;
            }
            if (wa.equals((Object)WandAugment.VICIO)) {
                return EnumAction.BOW;
            }
        }
        return EnumAction.NONE;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        WandAugment wa;
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (!(itemstack.func_190926_b() || (wa = ItemWand.getAugment(itemstack)) == null || wa != WandAugment.ARMARA && wa != WandAugment.VICIO)) {
            playerIn.func_184598_c(handIn);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
        World world = player.func_130014_f_();
        if (stack.func_190926_b()) {
            return;
        }
        WandAugment wa = ItemWand.getAugment(stack);
        if (wa != null && world.field_72995_K) {
            if (wa == WandAugment.VICIO) {
                this.playVicioEffect(stack, player, count);
            } else if (wa == WandAugment.ARMARA) {
                this.playArmaraEffect(player);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void playArmaraEffect(EntityLivingBase player) {
        if (player.field_70173_aa % 2 == 0) {
            List<Vector3> positions = MiscUtils.getCirclePositions(Vector3.atEntityCorner((Entity)player).addY(player.field_70131_O / 2.0f), Vector3.RotAxis.Y_AXIS, 0.8f - rand.nextFloat() * 0.1f, 20 + rand.nextInt(10));
            for (Vector3 v : positions) {
                EntityFXFacingParticle particle = EffectHelper.genericFlareParticle(v.getX(), v.getY(), v.getZ());
                particle.gravity(0.004);
                particle.motion(0.0, (double)((float)(rand.nextBoolean() ? 1 : -1) * rand.nextFloat()) * 0.01, 0.0);
                if (rand.nextInt(3) == 0) {
                    particle.setColor(Color.WHITE);
                    particle.scale(0.1f + rand.nextFloat() * 0.05f);
                    particle.setMaxAge(15 + rand.nextInt(10));
                    continue;
                }
                particle.setColor(wandBlue);
                particle.scale(0.15f + rand.nextFloat() * 0.1f);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void playVicioEffect(ItemStack stack, EntityLivingBase entity, int count) {
        int strTick = this.func_77626_a(stack) - count;
        if (strTick <= 2) {
            return;
        }
        float mul = MathHelper.func_76131_a((float)((float)strTick / 30.0f), (float)0.0f, (float)1.0f);
        Vector3 look = new Vector3(entity.func_70676_i(1.0f)).normalize().multiply(mul * 3.0f);
        Vector3 motionReverse = look.clone().normalize().multiply(-0.4 * (double)mul);
        Vector3 perp = look.clone().perpendicular();
        Vector3 origin = new Vector3(entity.field_70165_t + (double)(entity.field_70130_N / 2.0f), entity.field_70163_u + (double)entity.field_70131_O, entity.field_70161_v + (double)(entity.field_70130_N / 2.0f));
        for (int i = 0; i < 4; ++i) {
            if (!(rand.nextFloat() < mul)) continue;
            Vector3 at = look.clone().multiply(0.2 + (double)rand.nextFloat() * 2.5).add(perp.clone().rotate(rand.nextFloat() * 360.0f, look).multiply((double)rand.nextFloat() * 0.5)).add(origin);
            EntityFXFacingParticle p = EffectHelper.genericFlareParticle(at.getX(), at.getY(), at.getZ());
            p.scale(0.35f + rand.nextFloat() * 0.2f).setMaxAge(10 + rand.nextInt(10));
            p.enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT).setAlphaMultiplier(1.0f);
            p.gravity(0.004);
            p.setColor(wandBlue);
            p.motion(motionReverse.getX(), motionReverse.getY(), motionReverse.getZ());
        }
    }

    public int func_77626_a(ItemStack stack) {
        WandAugment wa = ItemWand.getAugment(stack);
        if (wa != null) {
            switch (wa) {
                case VICIO: {
                    return 72000;
                }
                case ARMARA: {
                    return 72000;
                }
            }
        }
        return super.func_77626_a(stack);
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        if (worldIn.field_72995_K) {
            return;
        }
        WandAugment wa = ItemWand.getAugment(stack);
        if (wa != null && wa.equals((Object)WandAugment.VICIO)) {
            int strTick = this.func_77626_a(stack) - timeLeft;
            if (strTick <= 2) {
                return;
            }
            float mul = MathHelper.func_76131_a((float)((float)strTick / 30.0f), (float)0.0f, (float)1.0f);
            Vec3d vec = entityLiving.func_70676_i(1.0f);
            Vector3 motionApply = new Vector3(vec).normalize().multiply(mul * 3.0f);
            if (motionApply.getY() > 0.0) {
                motionApply.setY(MathHelper.func_151237_a((double)(motionApply.getY() + (double)(0.7f * mul)), (double)(0.7f * mul), (double)3.4028234663852886E38));
            }
            entityLiving.field_70159_w = motionApply.getX();
            entityLiving.field_70181_x = motionApply.getY();
            entityLiving.field_70179_y = motionApply.getZ();
            entityLiving.field_70143_R = 0.0f;
            PktShootEntity pkt = new PktShootEntity(entityLiving.func_145782_y(), motionApply);
            pkt.setEffectLength(mul);
            PacketChannel.CHANNEL.sendToDimension((IMessage)pkt, worldIn.field_73011_w.getDimension());
        }
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!isSelected) {
            boolean bl = isSelected = entityIn instanceof EntityPlayer && ((EntityPlayer)entityIn).func_184592_cb() == stack;
        }
        if (!worldIn.field_72995_K) {
            if (isSelected) {
                WandAugment wa;
                if (worldIn.func_82737_E() % 20L == 0L && entityIn instanceof EntityPlayerMP) {
                    double dstr = ConstellationSkyHandler.getInstance().getCurrentDaytimeDistribution(worldIn);
                    if (dstr <= 1.0E-4) {
                        return;
                    }
                    RockCrystalBuffer buf = (RockCrystalBuffer)WorldCacheManager.getOrLoadData(worldIn, WorldCacheManager.SaveKey.ROCK_CRYSTAL);
                    ChunkPos pos = new ChunkPos(entityIn.func_180425_c());
                    HashSet<BlockPos> posList = new HashSet<BlockPos>(buf.collectPositions(pos, 4));
                    posList.addAll(RockCrystalHandler.INSTANCE.collectPositions(worldIn, pos, 4));
                    for (BlockPos rPos : posList) {
                        IBlockState state = worldIn.func_180495_p(rPos);
                        if (!(state.func_177230_c() instanceof BlockCustomOre) || state.func_177229_b(BlockCustomOre.ORE_TYPE) != BlockCustomOre.OreType.ROCK_CRYSTAL) {
                            RockCrystalHandler.INSTANCE.removeOre(worldIn, rPos, true);
                            continue;
                        }
                        BlockPos p = rPos.func_177984_a();
                        PktParticleEvent pkt = new PktParticleEvent(PktParticleEvent.ParticleEventType.WAND_CRYSTAL_HIGHLIGHT, p.func_177958_n(), p.func_177956_o(), p.func_177952_p());
                        PacketChannel.CHANNEL.sendTo((IMessage)pkt, (EntityPlayerMP)entityIn);
                    }
                }
                if ((wa = ItemWand.getAugment(stack)) != null && wa == WandAugment.AEVITAS) {
                    BlockPos playerPos = entityIn.func_180425_c();
                    for (int xx = -1; xx <= 1; ++xx) {
                        for (int zz = -1; zz <= 1; ++zz) {
                            BlockPos at = playerPos.func_177982_a(xx, -1, zz);
                            if (!MiscUtils.isChunkLoaded(worldIn, at) || worldIn.func_189509_E(at) || !worldIn.func_180495_p(at).func_177230_c().equals(Blocks.field_150350_a)) continue;
                            worldIn.func_175656_a(at, BlocksAS.blockVanishing.func_176223_P());
                        }
                    }
                }
            }
        } else if (isSelected) {
            this.playClientEffects(stack, entityIn);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void playClientEffects(ItemStack stack, Entity entityIn) {
        WandAugment wa = ItemWand.getAugment(stack);
        if (wa != null && rand.nextFloat() <= 0.7f) {
            EntityFXFacingParticle p = EffectHelper.genericFlareParticle(entityIn.field_70165_t - (double)(entityIn.field_70130_N / 2.0f) + (double)(rand.nextFloat() * entityIn.field_70130_N), entityIn.field_70163_u + (double)(rand.nextFloat() * (entityIn.field_70131_O / 2.0f)), entityIn.field_70161_v - (double)(entityIn.field_70130_N / 2.0f) + (double)(rand.nextFloat() * entityIn.field_70130_N));
            p.gravity(0.004).scale(0.3f + rand.nextFloat() * 0.2f).setMaxAge(45 + rand.nextInt(20));
            p.enableAlphaFade(EntityComplexFX.AlphaFunction.PYRAMID).setAlphaMultiplier(1.0f);
            p.motion(0.0, (double)(-rand.nextFloat()) * 0.001, 0.0);
            if (rand.nextInt(4) == 0) {
                p.setColor(Color.WHITE);
                p.scale(0.1f + rand.nextFloat() * 0.1f);
            } else {
                p.setColor(wandBlue);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void highlightEffects(PktParticleEvent event) {
        float dstMul;
        if (Minecraft.func_71410_x().field_71441_e == null) {
            return;
        }
        BlockPos orePos = event.getVec().toBlockPos();
        BlockPos pos = Minecraft.func_71410_x().field_71441_e.func_175672_r(orePos).func_177984_a();
        Vector3 display = new Vector3(pos);
        MiscUtils.applyRandomOffset(display, rand, 2.0f);
        double velX = rand.nextFloat() * 0.01f * (float)(rand.nextBoolean() ? 1 : -1);
        double velY = rand.nextFloat() * 0.3f;
        double velZ = rand.nextFloat() * 0.01f * (float)(rand.nextBoolean() ? 1 : -1);
        double dstr = ConstellationSkyHandler.getInstance().getCurrentDaytimeDistribution((World)Minecraft.func_71410_x().field_71441_e);
        for (int i = 0; i < 10; ++i) {
            EntityFXFacingParticle particle = EffectHelper.genericFlareParticle(display.getX(), display.getY(), display.getZ());
            particle.setColor(BlockCollectorCrystalBase.CollectorCrystalType.ROCK_CRYSTAL.displayColor);
            particle.motion(velX * (0.2 + 0.8 * (double)rand.nextFloat()), velY * (0.4 + 0.6 * (double)rand.nextFloat()), velZ * (0.2 + 0.8 * (double)rand.nextFloat()));
            particle.scale(0.7f).setMaxAge(70);
            particle.enableAlphaFade(EntityComplexFX.AlphaFunction.PYRAMID).setAlphaMultiplier((float)(150.0 * dstr / 255.0));
        }
        dstr = Math.sqrt(dstr);
        dstr = Math.sqrt(dstr);
        Vector3 plVec = Vector3.atEntityCorner((Entity)Minecraft.func_71410_x().field_71439_g);
        float dst = (float)event.getVec().distance(plVec);
        float f = dst <= 25.0f ? 1.0f : (dstMul = dst >= 50.0f ? 0.0f : 1.0f - (dst - 25.0f) / 25.0f);
        if ((double)dstMul >= 1.0E-4) {
            EntityFXFacingDepthParticle p = EffectHelper.genericDepthIgnoringFlareParticle((float)(orePos.func_177958_n() - 1) + rand.nextFloat() * 3.0f, (float)(orePos.func_177956_o() - 1) + rand.nextFloat() * 3.0f, (float)(orePos.func_177952_p() - 1) + rand.nextFloat() * 3.0f);
            p.setColor(BlockCollectorCrystalBase.CollectorCrystalType.ROCK_CRYSTAL.displayColor);
            p.gravity(0.004).scale(0.4f).setAlphaMultiplier((float)(150.0 * dstr / 255.0) * dstMul);
            p.enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT).setMaxAge(30 + rand.nextInt(10));
        }
    }

    @Override
    public boolean needsSpecialHandling(World world, BlockPos at, EntityPlayer player, ItemStack stack) {
        return true;
    }

    @Override
    public boolean onRightClick(World world, BlockPos pos, EntityPlayer entityPlayer, EnumFacing side, EnumHand hand, ItemStack stack) {
        IBlockState state = world.func_180495_p(pos);
        Block b = state.func_177230_c();
        if (b instanceof IWandInteract) {
            ((IWandInteract)b).onInteract(world, pos, entityPlayer, side, entityPlayer.func_70093_af());
            return true;
        }
        IWandInteract wandTe = MiscUtils.getTileAt((IBlockAccess)world, pos, IWandInteract.class, true);
        if (wandTe != null) {
            wandTe.onInteract(world, pos, entityPlayer, side, entityPlayer.func_70093_af());
            return true;
        }
        return false;
    }
}

