/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.item.tool.sextant;

import com.google.common.collect.Iterables;
import hellfirepvp.astralsorcery.client.util.resource.AbstractRenderableTexture;
import hellfirepvp.astralsorcery.client.util.resource.AssetLoader;
import hellfirepvp.astralsorcery.client.util.resource.TextureQuery;
import hellfirepvp.astralsorcery.client.util.resource.TextureSubQuery;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ProgressionTier;
import hellfirepvp.astralsorcery.common.data.world.data.StructureGenBuffer;
import hellfirepvp.astralsorcery.common.item.tool.sextant.ItemSextant;
import hellfirepvp.astralsorcery.common.item.tool.sextant.SextantTargets;
import hellfirepvp.astralsorcery.common.util.StructureFinder;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SextantFinder {
    private static boolean initialized = false;
    private static List<TargetObject> selectableTargets = new LinkedList<TargetObject>();

    public static void register(TargetObject object) {
        for (TargetObject to : selectableTargets) {
            if (!to.getRegistryName().equalsIgnoreCase(object.getRegistryName())) continue;
            throw new IllegalArgumentException("Duplicate Sextant Target: " + to.getRegistryName() + " - tried to add: " + object.getRegistryName());
        }
        selectableTargets.add(object);
    }

    public static void initialize() {
        if (initialized) {
            return;
        }
        SextantFinder.register(SextantTargets.TARGET_MOUNTAIN_SHRINE);
        SextantFinder.register(SextantTargets.TARGET_DESERT_SHRINE);
        SextantFinder.register(SextantTargets.TARGET_SMALL_SHRINE);
        SextantFinder.register(SextantTargets.TARGET_VANILLA_VILLAGE);
        SextantFinder.register(SextantTargets.TARGET_VANILLA_TEMPLE);
        SextantFinder.register(SextantTargets.TARGET_VANILLA_MONUMENT);
        SextantFinder.register(SextantTargets.TARGET_VANILLA_FORTRESS);
        SextantFinder.register(SextantTargets.TARGET_VANILLA_ENDCITY);
        SextantFinder.register(SextantTargets.TARGET_BIOME_PLAINS);
        SextantFinder.register(SextantTargets.TARGET_BIOME_DESERT);
        SextantFinder.register(SextantTargets.TARGET_BIOME_COLD);
        SextantFinder.register(SextantTargets.TARGET_BIOME_FOREST);
        SextantFinder.register(SextantTargets.TARGET_BIOME_JUNGLE);
        SextantFinder.register(SextantTargets.TARGET_BIOME_MESA);
        SextantFinder.register(SextantTargets.TARGET_BIOME_OCEAN);
        SextantFinder.register(SextantTargets.TARGET_BIOME_MOUNTAINS);
        MinecraftForge.EVENT_BUS.post((Event)new RegisterEvent());
        initialized = true;
    }

    @Nonnull
    public static TargetObject getOrReturnFirst(String registryName) {
        TargetObject to = SextantFinder.getByName(registryName);
        if (to != null) {
            return to;
        }
        return SextantFinder.getFirst();
    }

    @Nullable
    public static TargetObject getByName(String registryName) {
        for (TargetObject to : selectableTargets) {
            if (!to.getRegistryName().equalsIgnoreCase(registryName)) continue;
            return to;
        }
        return null;
    }

    @Nonnull
    public static TargetObject getFirst() {
        for (TargetObject to : selectableTargets) {
            if (!(to instanceof ASStructure) || ((ASTargetObject)to).advanced) continue;
            return to;
        }
        TargetObject first = (TargetObject)Iterables.getFirst(selectableTargets, null);
        if (first == null) {
            throw new IllegalStateException("There has to be at least ONE sextant target!");
        }
        return first;
    }

    public static List<TargetObject> getSelectableTargets() {
        return selectableTargets;
    }

    public static class Biome
    extends ASTargetObject {
        private final BiomeDictionary.Type biomeType;

        public Biome(AssetLoader.TextureLocation texLocation, String iconName, String targetName, int color, boolean advanced, BiomeDictionary.Type biomeType) {
            super(texLocation, iconName, targetName, advanced, color);
            this.biomeType = biomeType;
        }

        public Biome(AssetLoader.TextureLocation texLocation, String iconName, String targetName, int color, boolean advanced, BiomeDictionary.Type biomeType, double iconUOffset, double iconVOffset, double iconULength, double iconVLength) {
            super(texLocation, iconName, targetName, advanced, color, iconUOffset, iconVOffset, iconULength, iconVLength);
            this.biomeType = biomeType;
        }

        @Override
        @Nullable
        public BlockPos searchFor(WorldServer world, BlockPos searchPos) {
            return StructureFinder.tryFindClosestBiomeType(world, searchPos, this.biomeType);
        }
    }

    public static class Structure
    extends ASTargetObject {
        private final String structureName;

        public Structure(AssetLoader.TextureLocation texLocation, String iconName, String targetName, int color, boolean advanced, String structureName) {
            super(texLocation, iconName, targetName, advanced, color);
            this.structureName = structureName;
        }

        public Structure(AssetLoader.TextureLocation texLocation, String iconName, String targetName, int color, boolean advanced, String structureName, double iconUOffset, double iconVOffset, double iconULength, double iconVLength) {
            super(texLocation, iconName, targetName, advanced, color, iconUOffset, iconVOffset, iconULength, iconVLength);
            this.structureName = structureName;
        }

        @Override
        @Nullable
        public BlockPos searchFor(WorldServer world, BlockPos searchPos) {
            return StructureFinder.tryFindClosestVanillaStructure(world, searchPos, this.structureName);
        }
    }

    public static class ASStructure
    extends ASTargetObject {
        private final StructureGenBuffer.StructureType structureType;

        public ASStructure(AssetLoader.TextureLocation texLocation, String iconName, String targetName, int color, boolean advanced, StructureGenBuffer.StructureType type) {
            super(texLocation, iconName, targetName, advanced, color);
            this.structureType = type;
        }

        public ASStructure(AssetLoader.TextureLocation texLocation, String iconName, String targetName, int color, boolean advanced, StructureGenBuffer.StructureType type, double iconUOffset, double iconVOffset, double iconULength, double iconVLength) {
            super(texLocation, iconName, targetName, advanced, color, iconUOffset, iconVOffset, iconULength, iconVLength);
            this.structureType = type;
        }

        @Override
        @Nullable
        public BlockPos searchFor(WorldServer world, BlockPos searchPos) {
            return StructureFinder.tryFindClosestAstralSorceryStructure(world, searchPos, this.structureType);
        }
    }

    public static abstract class ASTargetObject
    extends TargetObject {
        private final TextureQuery query;
        private final boolean advanced;
        private final String name;
        private final int color;

        public ASTargetObject(AssetLoader.TextureLocation texLocation, String iconName, String targetName, boolean advanced, int color) {
            this(texLocation, iconName, targetName, advanced, color, 0.0, 0.0, 1.0, 1.0);
        }

        public ASTargetObject(AssetLoader.TextureLocation texLocation, String iconName, String targetName, boolean advanced, int color, double iconUOffset, double iconVOffset, double iconULength, double iconVLength) {
            this.query = new TextureSubQuery(texLocation, iconName, iconUOffset, iconVOffset, iconULength, iconVLength);
            this.advanced = advanced;
            this.name = targetName;
            this.color = color;
        }

        @Override
        public String getRegistryName() {
            return this.name;
        }

        @Override
        public boolean isSelectable(ItemStack stack, @Nullable PlayerProgress progress) {
            if (progress == null) {
                return false;
            }
            return !this.advanced && progress.getTierReached().isThisLaterOrEqual(ProgressionTier.BASIC_CRAFT) || ItemSextant.isAdvanced(stack) && progress.getTierReached().isThisLaterOrEqual(ProgressionTier.CONSTELLATION_CRAFT);
        }

        @Override
        @Nonnull
        @SideOnly(value=Side.CLIENT)
        public AbstractRenderableTexture getRenderable() {
            return this.query.resolve();
        }

        @Override
        public int getColorTheme() {
            return this.color;
        }
    }

    public static abstract class TargetObject {
        public abstract String getRegistryName();

        public abstract boolean isSelectable(ItemStack var1, @Nullable PlayerProgress var2);

        @Nonnull
        @SideOnly(value=Side.CLIENT)
        public abstract AbstractRenderableTexture getRenderable();

        @SideOnly(value=Side.CLIENT)
        public abstract int getColorTheme();

        @Nullable
        public abstract BlockPos searchFor(WorldServer var1, BlockPos var2);

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !this.getClass().isAssignableFrom(o.getClass())) {
                return false;
            }
            TargetObject that = (TargetObject)o;
            return Objects.equals(this.getRegistryName(), that.getRegistryName());
        }

        public int hashCode() {
            return Objects.hash(this.getRegistryName());
        }
    }

    public static class RegisterEvent
    extends Event {
    }
}

