/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.integrations.mods.crafttweaker.network;

import hellfirepvp.astralsorcery.common.crafting.helper.CraftingAccessManager;
import hellfirepvp.astralsorcery.common.integrations.mods.crafttweaker.network.SerializeableRecipe;
import hellfirepvp.astralsorcery.common.util.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class LiquidInteractionRemove
implements SerializeableRecipe {
    private FluidStack comp1;
    private FluidStack comp2;
    private ItemStack output;

    LiquidInteractionRemove() {
    }

    public LiquidInteractionRemove(FluidStack comp1, FluidStack comp2, ItemStack output) {
        this.comp1 = comp1;
        this.comp2 = comp2;
        this.output = output;
    }

    @Override
    public SerializeableRecipe.CraftingType getType() {
        return SerializeableRecipe.CraftingType.LIQINTERACTION_REMOVE;
    }

    @Override
    public void read(ByteBuf buf) {
        this.comp1 = ByteBufUtils.readFluidStack(buf);
        this.comp2 = ByteBufUtils.readFluidStack(buf);
        this.output = ByteBufUtils.readItemStack(buf);
    }

    @Override
    public void write(ByteBuf buf) {
        ByteBufUtils.writeFluidStack(buf, this.comp1);
        ByteBufUtils.writeFluidStack(buf, this.comp2);
        ByteBufUtils.writeItemStack(buf, this.output);
    }

    @Override
    public void applyRecipe() {
        CraftingAccessManager.removeLiquidInteraction(this.comp1.getFluid(), this.comp2.getFluid(), this.output);
    }
}

