/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data.research;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.common.data.research.ProgressionTier;
import hellfirepvp.astralsorcery.common.data.research.ResearchNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum ResearchProgression {
    DISCOVERY(0, ProgressionTier.DISCOVERY, new ResearchProgression[0]),
    BASIC_CRAFT(1, ProgressionTier.BASIC_CRAFT, DISCOVERY),
    ATTUNEMENT(2, ProgressionTier.ATTUNEMENT, BASIC_CRAFT),
    CONSTELLATION(3, ProgressionTier.CONSTELLATION_CRAFT, ATTUNEMENT),
    RADIANCE(4, ProgressionTier.TRAIT_CRAFT, CONSTELLATION),
    BRILLIANCE(5, ProgressionTier.BRILLIANCE, RADIANCE);

    private final int progressId;
    private List<ResearchProgression> preConditions = new LinkedList<ResearchProgression>();
    private List<ResearchNode> researchNodes = new LinkedList<ResearchNode>();
    private final ProgressionTier requiredProgress;
    private final String unlocName;
    private static final Map<Integer, ResearchProgression> BY_ID;
    private static final Map<String, ResearchProgression> BY_NAME;

    private ResearchProgression(int id, ProgressionTier requiredProgress, ResearchProgression ... preConditions) {
        this(id, requiredProgress, Arrays.asList(preConditions));
    }

    private ResearchProgression(int id, ProgressionTier requiredProgress, List<ResearchProgression> preConditions) {
        this.preConditions.addAll(preConditions);
        this.requiredProgress = requiredProgress;
        this.progressId = id;
        this.unlocName = "astralsorcery.journal.cluster." + this.name().toLowerCase() + ".name";
    }

    void addResearchToGroup(ResearchNode res) {
        for (ResearchNode node : this.researchNodes) {
            if (node.renderPosX != res.renderPosX || node.renderPosZ != res.renderPosZ) continue;
            throw new IllegalArgumentException("Tried to register 2 Research Nodes at the same position at x=" + res.renderPosX + ", z=" + res.renderPosZ + "! Present: " + node.getTranslationKey() + " - Tried to set: " + res.getTranslationKey());
        }
        this.researchNodes.add(res);
    }

    public List<ResearchNode> getResearchNodes() {
        return this.researchNodes;
    }

    public Registry getRegistry() {
        return new Registry(this);
    }

    public ProgressionTier getRequiredProgress() {
        return this.requiredProgress;
    }

    public List<ResearchProgression> getPreConditions() {
        return Collections.unmodifiableList(this.preConditions);
    }

    public String getTranslationKey() {
        return this.unlocName;
    }

    public int getProgressId() {
        return this.progressId;
    }

    public static ResearchProgression getById(int id) {
        return BY_ID.get(id);
    }

    public static ResearchProgression getByEnumName(String name) {
        return BY_NAME.get(name);
    }

    @Nullable
    public static ResearchNode findNode(String name) {
        for (ResearchProgression prog : ResearchProgression.values()) {
            for (ResearchNode node : prog.getResearchNodes()) {
                if (!node.getSimpleName().equals(name)) continue;
                return node;
            }
        }
        return null;
    }

    @Nonnull
    public static Collection<ResearchProgression> findProgression(ResearchNode n) {
        ArrayList progressions = Lists.newArrayList();
        for (ResearchProgression prog : ResearchProgression.values()) {
            if (!prog.getResearchNodes().contains(n)) continue;
            progressions.add(prog);
        }
        return progressions;
    }

    static {
        BY_ID = new HashMap<Integer, ResearchProgression>();
        BY_NAME = new HashMap<String, ResearchProgression>();
        for (ResearchProgression progress : ResearchProgression.values()) {
            BY_ID.put(progress.progressId, progress);
            BY_NAME.put(progress.name(), progress);
        }
    }

    public static class Registry {
        private final ResearchProgression prog;

        public Registry(ResearchProgression prog) {
            this.prog = prog;
        }

        public void register(ResearchNode node) {
            this.prog.addResearchToGroup(node);
        }
    }
}

