/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data.research;

import com.google.common.io.Files;
import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.client.event.ClientRenderEventHandler;
import hellfirepvp.astralsorcery.common.block.network.BlockAltar;
import hellfirepvp.astralsorcery.common.constellation.ConstellationRegistry;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.IMajorConstellation;
import hellfirepvp.astralsorcery.common.constellation.perk.AbstractPerk;
import hellfirepvp.astralsorcery.common.constellation.perk.PerkEffectHelper;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.PerkTree;
import hellfirepvp.astralsorcery.common.crafting.altar.ActiveCraftingTask;
import hellfirepvp.astralsorcery.common.crafting.infusion.ActiveInfusionTask;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgressTestAccess;
import hellfirepvp.astralsorcery.common.data.research.ProgressionTier;
import hellfirepvp.astralsorcery.common.data.research.ResearchIOThread;
import hellfirepvp.astralsorcery.common.data.research.ResearchProgression;
import hellfirepvp.astralsorcery.common.item.tool.sextant.SextantFinder;
import hellfirepvp.astralsorcery.common.lib.AdvancementTriggers;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.server.PktProgressionUpdate;
import hellfirepvp.astralsorcery.common.network.packet.server.PktSyncKnowledge;
import hellfirepvp.astralsorcery.common.network.packet.server.PktSyncPerkActivity;
import hellfirepvp.astralsorcery.common.tile.TileAltar;
import hellfirepvp.astralsorcery.common.tile.TileStarlightInfuser;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ResearchManager {
    public static PlayerProgress clientProgress = new PlayerProgress();
    public static boolean clientInitialized = false;
    private static Map<UUID, PlayerProgress> playerProgressServer = new HashMap<UUID, PlayerProgress>();

    @Nonnull
    public static PlayerProgress getProgress(EntityPlayer player) {
        return ResearchManager.getProgress(player, player.func_130014_f_().field_72995_K ? Side.CLIENT : Side.SERVER);
    }

    @Nonnull
    public static PlayerProgress getProgress(EntityPlayer player, Side side) {
        if (side == Side.CLIENT) {
            return clientProgress;
        }
        if (player instanceof EntityPlayerMP) {
            return ResearchManager.getProgressServer((EntityPlayerMP)player);
        }
        return new PlayerProgressTestAccess();
    }

    @Nonnull
    private static PlayerProgress getProgressServer(EntityPlayerMP player) {
        if (MiscUtils.isPlayerFakeMP(player)) {
            return new PlayerProgressTestAccess();
        }
        return ResearchManager.getProgress(player.func_110124_au());
    }

    @Nonnull
    private static PlayerProgress getProgress(UUID uuid) {
        PlayerProgress progress = playerProgressServer.get(uuid);
        if (progress == null) {
            ResearchManager.loadPlayerKnowledge(uuid);
            progress = playerProgressServer.get(uuid);
        }
        if (progress == null) {
            progress = new PlayerProgress();
        }
        return progress;
    }

    public static void wipeKnowledge(EntityPlayerMP p) {
        ResearchManager.resetPerks((EntityPlayer)p);
        ResearchManager.wipeFile(p);
        playerProgressServer.remove(p.func_110124_au());
        PktProgressionUpdate pkt = new PktProgressionUpdate();
        PacketChannel.CHANNEL.sendTo((IMessage)pkt, p);
        PktSyncKnowledge pk = new PktSyncKnowledge(1);
        PacketChannel.CHANNEL.sendTo((IMessage)pk, p);
        ResearchManager.loadPlayerKnowledge(p);
        ResearchManager.pushProgressToClientUnsafe(p);
    }

    public static void sendInitClientKnowledge(EntityPlayerMP p) {
        UUID uuid = p.func_110124_au();
        if (playerProgressServer.get(uuid) == null) {
            ResearchManager.loadPlayerKnowledge(p);
        }
        if (playerProgressServer.get(uuid) == null) {
            AstralSorcery.log.warn("Failed to load AstralSocery Progress data for " + p.func_70005_c_());
            AstralSorcery.log.warn("Erroneous file: " + uuid.toString() + ".astral");
            return;
        }
        ResearchManager.pushProgressToClientUnsafe(p);
    }

    public static void unsafeForceGiveResearch(EntityPlayerMP player, ResearchProgression prog) {
        PlayerProgress progress = ResearchManager.getProgress((EntityPlayer)player, Side.SERVER);
        if (!progress.isValid()) {
            return;
        }
        ProgressionTier reqTier = prog.getRequiredProgress();
        if (!progress.getTierReached().isThisLaterOrEqual(reqTier)) {
            progress.setTierReached(reqTier);
        }
        LinkedList<ResearchProgression> progToGive = new LinkedList<ResearchProgression>();
        progToGive.add(prog);
        while (!progToGive.isEmpty()) {
            ResearchProgression give = (ResearchProgression)((Object)progToGive.pop());
            if (!progress.getResearchProgression().contains((Object)give)) {
                progress.forceGainResearch(give);
            }
            progToGive.addAll(give.getPreConditions());
        }
        PktProgressionUpdate pkt = new PktProgressionUpdate();
        PacketChannel.CHANNEL.sendTo((IMessage)pkt, player);
        ResearchManager.pushProgressToClientUnsafe(player);
        ResearchManager.savePlayerKnowledge(player);
    }

    public static void giveResearchIgnoreFail(EntityPlayer player, ResearchProgression prog) {
        PlayerProgress progress = ResearchManager.getProgress(player, Side.SERVER);
        if (!progress.isValid()) {
            return;
        }
        ProgressionTier tier = prog.getRequiredProgress();
        if (!progress.getTierReached().isThisLaterOrEqual(tier)) {
            return;
        }
        for (ResearchProgression other : prog.getPreConditions()) {
            if (progress.getResearchProgression().contains((Object)other)) continue;
            return;
        }
        if (progress.forceGainResearch(prog)) {
            PktProgressionUpdate pkt = new PktProgressionUpdate(prog);
            PacketChannel.CHANNEL.sendTo((IMessage)pkt, (EntityPlayerMP)player);
        }
        ResearchManager.pushProgressToClientUnsafe((EntityPlayerMP)player);
        ResearchManager.savePlayerKnowledge((EntityPlayerMP)player);
    }

    public static void giveProgressionIgnoreFail(EntityPlayer player, ProgressionTier tier) {
        PlayerProgress progress = ResearchManager.getProgress(player, Side.SERVER);
        if (!progress.isValid()) {
            return;
        }
        ProgressionTier t = progress.getTierReached();
        if (!t.hasNextTier()) {
            return;
        }
        ProgressionTier next = t.next();
        if (!next.equals((Object)tier)) {
            return;
        }
        progress.setTierReached(next);
        PktProgressionUpdate pkt = new PktProgressionUpdate(next);
        PacketChannel.CHANNEL.sendTo((IMessage)pkt, (EntityPlayerMP)player);
        ResearchManager.pushProgressToClientUnsafe((EntityPlayerMP)player);
        ResearchManager.savePlayerKnowledge((EntityPlayerMP)player);
    }

    public static boolean mergeApplyPlayerprogress(PlayerProgress toMergeFrom, EntityPlayer player) {
        PlayerProgress progress = ResearchManager.getProgress(player, Side.SERVER);
        if (!progress.isValid()) {
            return false;
        }
        progress.acceptMergeFrom(toMergeFrom);
        ResearchManager.pushProgressToClientUnsafe((EntityPlayerMP)player);
        ResearchManager.savePlayerKnowledge((EntityPlayerMP)player);
        return true;
    }

    public static boolean useSextantTarget(SextantFinder.TargetObject to, EntityPlayer player) {
        PlayerProgress progress = ResearchManager.getProgress(player, Side.SERVER);
        if (!progress.isValid()) {
            return false;
        }
        progress.useTarget(to);
        ResearchManager.pushProgressToClientUnsafe((EntityPlayerMP)player);
        ResearchManager.savePlayerKnowledge((EntityPlayerMP)player);
        return true;
    }

    public static boolean discoverConstellations(Collection<IConstellation> csts, EntityPlayer player) {
        PlayerProgress progress = ResearchManager.getProgress(player, Side.SERVER);
        if (!progress.isValid()) {
            return false;
        }
        for (IConstellation c : csts) {
            progress.discoverConstellation(c.getTranslationKey());
            AdvancementTriggers.DISCOVER_CONSTELLATION.trigger((EntityPlayerMP)player, c);
        }
        ResearchManager.pushProgressToClientUnsafe((EntityPlayerMP)player);
        ResearchManager.savePlayerKnowledge((EntityPlayerMP)player);
        return true;
    }

    public static boolean discoverConstellation(IConstellation c, EntityPlayer player) {
        PlayerProgress progress = ResearchManager.getProgress(player, Side.SERVER);
        if (!progress.isValid()) {
            return false;
        }
        progress.discoverConstellation(c.getTranslationKey());
        AdvancementTriggers.DISCOVER_CONSTELLATION.trigger((EntityPlayerMP)player, c);
        ResearchManager.pushProgressToClientUnsafe((EntityPlayerMP)player);
        ResearchManager.savePlayerKnowledge((EntityPlayerMP)player);
        return true;
    }

    public static boolean memorizeConstellation(IConstellation c, EntityPlayer player) {
        PlayerProgress progress = ResearchManager.getProgress(player, Side.SERVER);
        if (!progress.isValid()) {
            return false;
        }
        progress.memorizeConstellation(c.getTranslationKey());
        ResearchManager.pushProgressToClientUnsafe((EntityPlayerMP)player);
        ResearchManager.savePlayerKnowledge((EntityPlayerMP)player);
        return true;
    }

    public static boolean maximizeTier(EntityPlayer player) {
        PlayerProgress progress = ResearchManager.getProgress(player, Side.SERVER);
        if (!progress.isValid()) {
            return false;
        }
        progress.setTierReached(ProgressionTier.values()[ProgressionTier.values().length - 1]);
        PktProgressionUpdate pkt = new PktProgressionUpdate();
        PacketChannel.CHANNEL.sendTo((IMessage)pkt, (EntityPlayerMP)player);
        ResearchManager.pushProgressToClientUnsafe((EntityPlayerMP)player);
        ResearchManager.savePlayerKnowledge((EntityPlayerMP)player);
        return true;
    }

    public static boolean setAttunedBefore(EntityPlayer player, boolean wasAttunedBefore) {
        PlayerProgress progress = ResearchManager.getProgress(player, Side.SERVER);
        if (!progress.isValid()) {
            return false;
        }
        progress.setAttunedBefore(wasAttunedBefore);
        ResearchManager.pushProgressToClientUnsafe((EntityPlayerMP)player);
        ResearchManager.savePlayerKnowledge((EntityPlayerMP)player);
        return true;
    }

    public static boolean setAttunedConstellation(EntityPlayer player, @Nullable IMajorConstellation constellation) {
        AbstractPerk root;
        PlayerProgress progress = ResearchManager.getProgress(player, Side.SERVER);
        if (!progress.isValid()) {
            return false;
        }
        if (constellation != null && !progress.getKnownConstellations().contains(constellation.getTranslationKey())) {
            return false;
        }
        HashMap<AbstractPerk, NBTTagCompound> perkCopy = new HashMap<AbstractPerk, NBTTagCompound>(progress.getUnlockedPerkData());
        for (Map.Entry perkEntry : perkCopy.entrySet()) {
            ResearchManager.dropPerk(progress, player, Side.SERVER, (AbstractPerk)perkEntry.getKey(), (NBTTagCompound)perkEntry.getValue());
        }
        PacketChannel.CHANNEL.sendTo((IMessage)new PktSyncPerkActivity(PktSyncPerkActivity.Type.CLEARALL), (EntityPlayerMP)player);
        progress.setExp(0.0);
        progress.setAttunedConstellation(constellation);
        if (constellation != null && (root = PerkTree.PERK_TREE.getRootPerk(constellation)) != null) {
            NBTTagCompound data = new NBTTagCompound();
            root.onUnlockPerkServer(player, progress, data);
            progress.applyPerk(root, data);
            PerkEffectHelper.EVENT_INSTANCE.notifyPerkChange(player, Side.SERVER, root, false);
            PacketChannel.CHANNEL.sendTo((IMessage)new PktSyncPerkActivity(root, true), (EntityPlayerMP)player);
        }
        AdvancementTriggers.ATTUNE_SELF.trigger((EntityPlayerMP)player, constellation);
        ResearchManager.pushProgressToClientUnsafe((EntityPlayerMP)player);
        ResearchManager.savePlayerKnowledge((EntityPlayerMP)player);
        return true;
    }

    public static boolean setPerkData(EntityPlayer player, @Nonnull AbstractPerk perk, NBTTagCompound prevoiusData, NBTTagCompound newData) {
        PlayerProgress progress = ResearchManager.getProgress(player, Side.SERVER);
        if (!progress.isValid()) {
            return false;
        }
        if (!progress.hasPerkEffect(perk)) {
            return false;
        }
        PerkEffectHelper.EVENT_INSTANCE.notifyPerkChange(player, Side.SERVER, perk, true);
        progress.applyPerk(perk, newData);
        PerkEffectHelper.EVENT_INSTANCE.notifyPerkChange(player, Side.SERVER, perk, false);
        PacketChannel.CHANNEL.sendTo((IMessage)new PktSyncPerkActivity(perk, prevoiusData, newData), (EntityPlayerMP)player);
        ResearchManager.pushProgressToClientUnsafe((EntityPlayerMP)player);
        ResearchManager.savePlayerKnowledge((EntityPlayerMP)player);
        return true;
    }

    public static boolean applyPerk(EntityPlayer player, @Nonnull AbstractPerk perk) {
        PlayerProgress progress = ResearchManager.getProgress(player, Side.SERVER);
        if (!progress.isValid()) {
            return false;
        }
        if (!progress.hasFreeAllocationPoint(player)) {
            return false;
        }
        if (progress.hasPerkUnlocked(perk)) {
            return false;
        }
        NBTTagCompound data = new NBTTagCompound();
        perk.onUnlockPerkServer(player, progress, data);
        progress.applyPerk(perk, data);
        PerkEffectHelper.EVENT_INSTANCE.notifyPerkChange(player, Side.SERVER, perk, false);
        PacketChannel.CHANNEL.sendTo((IMessage)new PktSyncPerkActivity(perk, true), (EntityPlayerMP)player);
        ResearchManager.pushProgressToClientUnsafe((EntityPlayerMP)player);
        ResearchManager.savePlayerKnowledge((EntityPlayerMP)player);
        return true;
    }

    public static boolean applyPerkSeal(EntityPlayer player, @Nonnull AbstractPerk perk) {
        PlayerProgress progress = ResearchManager.getProgress(player, Side.SERVER);
        if (!progress.isValid()) {
            return false;
        }
        if (!progress.hasPerkUnlocked(perk)) {
            return false;
        }
        if (progress.isPerkSealed(perk)) {
            return false;
        }
        if (!progress.sealPerk(perk)) {
            return false;
        }
        PerkEffectHelper.EVENT_INSTANCE.notifyPerkChange(player, Side.SERVER, perk, true);
        PacketChannel.CHANNEL.sendTo((IMessage)new PktSyncPerkActivity(perk, false), (EntityPlayerMP)player);
        ResearchManager.pushProgressToClientUnsafe((EntityPlayerMP)player);
        ResearchManager.savePlayerKnowledge((EntityPlayerMP)player);
        return true;
    }

    public static boolean breakPerkSeal(EntityPlayer player, @Nonnull AbstractPerk perk) {
        PlayerProgress progress = ResearchManager.getProgress(player, Side.SERVER);
        if (!progress.isValid()) {
            return false;
        }
        if (!progress.hasPerkUnlocked(perk)) {
            return false;
        }
        if (!progress.isPerkSealed(perk)) {
            return false;
        }
        if (!progress.breakSeal(perk)) {
            return false;
        }
        PerkEffectHelper.EVENT_INSTANCE.notifyPerkChange(player, Side.SERVER, perk, false);
        ResearchManager.pushProgressToClientUnsafe((EntityPlayerMP)player);
        ResearchManager.savePlayerKnowledge((EntityPlayerMP)player);
        AstralSorcery.proxy.scheduleDelayed(() -> PacketChannel.CHANNEL.sendTo((IMessage)new PktSyncPerkActivity(perk, true), (EntityPlayerMP)player));
        return true;
    }

    public static boolean grantFreePerkPoint(EntityPlayer player, String token) {
        PlayerProgress progress = ResearchManager.getProgress(player, Side.SERVER);
        if (!progress.isValid()) {
            return false;
        }
        if (!progress.grantFreeAllocationPoint(token)) {
            return false;
        }
        ResearchManager.pushProgressToClientUnsafe((EntityPlayerMP)player);
        ResearchManager.savePlayerKnowledge((EntityPlayerMP)player);
        return true;
    }

    public static boolean revokeFreePoint(EntityPlayer player, String token) {
        PlayerProgress progress = ResearchManager.getProgress(player, Side.SERVER);
        if (!progress.isValid()) {
            return false;
        }
        if (!progress.tryRevokeAllocationPoint(token)) {
            return false;
        }
        ResearchManager.pushProgressToClientUnsafe((EntityPlayerMP)player);
        ResearchManager.savePlayerKnowledge((EntityPlayerMP)player);
        return true;
    }

    public static boolean forceApplyPerk(EntityPlayer player, @Nonnull AbstractPerk perk) {
        PlayerProgress progress = ResearchManager.getProgress(player, Side.SERVER);
        if (!progress.isValid()) {
            return false;
        }
        if (progress.hasPerkUnlocked(perk)) {
            return false;
        }
        NBTTagCompound data = new NBTTagCompound();
        perk.onUnlockPerkServer(player, progress, data);
        progress.applyPerk(perk, data);
        PerkEffectHelper.EVENT_INSTANCE.notifyPerkChange(player, Side.SERVER, perk, false);
        PacketChannel.CHANNEL.sendTo((IMessage)new PktSyncPerkActivity(perk, true), (EntityPlayerMP)player);
        ResearchManager.pushProgressToClientUnsafe((EntityPlayerMP)player);
        ResearchManager.savePlayerKnowledge((EntityPlayerMP)player);
        return true;
    }

    public static boolean removePerk(EntityPlayer player, AbstractPerk perk) {
        PlayerProgress progress = ResearchManager.getProgress(player, Side.SERVER);
        if (!progress.isValid()) {
            return false;
        }
        NBTTagCompound data = progress.getPerkData(perk);
        if (data == null) {
            return false;
        }
        ResearchManager.dropPerk(progress, player, Side.SERVER, perk, data);
        PacketChannel.CHANNEL.sendTo((IMessage)new PktSyncPerkActivity(perk, false), (EntityPlayerMP)player);
        ResearchManager.pushProgressToClientUnsafe((EntityPlayerMP)player);
        ResearchManager.savePlayerKnowledge((EntityPlayerMP)player);
        return true;
    }

    public static boolean resetPerks(EntityPlayer player) {
        PlayerProgress progress = ResearchManager.getProgress(player, Side.SERVER);
        if (!progress.isValid()) {
            return false;
        }
        HashMap<AbstractPerk, NBTTagCompound> perkCopy = new HashMap<AbstractPerk, NBTTagCompound>(progress.getUnlockedPerkData());
        for (Map.Entry perkEntry : perkCopy.entrySet()) {
            ResearchManager.dropPerk(progress, player, Side.SERVER, (AbstractPerk)perkEntry.getKey(), (NBTTagCompound)perkEntry.getValue());
        }
        PacketChannel.CHANNEL.sendTo((IMessage)new PktSyncPerkActivity(PktSyncPerkActivity.Type.CLEARALL), (EntityPlayerMP)player);
        ResearchManager.pushProgressToClientUnsafe((EntityPlayerMP)player);
        ResearchManager.savePlayerKnowledge((EntityPlayerMP)player);
        return true;
    }

    private static void dropPerk(PlayerProgress progress, EntityPlayer player, Side side, AbstractPerk perk, NBTTagCompound data) {
        progress.removePerk(perk);
        PerkEffectHelper.EVENT_INSTANCE.notifyPerkChange(player, side, perk, true);
        perk.onRemovePerkServer(player, progress, data);
        progress.removePerkData(perk);
    }

    public static boolean setTomeReceived(EntityPlayer player) {
        PlayerProgress progress = ResearchManager.getProgress(player, Side.SERVER);
        if (!progress.isValid()) {
            return false;
        }
        progress.setTomeReceived();
        ResearchManager.pushProgressToClientUnsafe((EntityPlayerMP)player);
        ResearchManager.savePlayerKnowledge((EntityPlayerMP)player);
        return true;
    }

    public static boolean setExp(EntityPlayer player, long exp) {
        PlayerProgress progress = ResearchManager.getProgress(player, Side.SERVER);
        if (!progress.isValid()) {
            return false;
        }
        progress.setExp(exp);
        AdvancementTriggers.PERK_LEVEL.trigger((EntityPlayerMP)player);
        ResearchManager.pushProgressToClientUnsafe((EntityPlayerMP)player);
        ResearchManager.savePlayerKnowledge((EntityPlayerMP)player);
        return true;
    }

    public static boolean modifyExp(EntityPlayer player, double exp) {
        PlayerProgress progress = ResearchManager.getProgress(player, Side.SERVER);
        if (!progress.isValid()) {
            return false;
        }
        progress.modifyExp(exp, player);
        AdvancementTriggers.PERK_LEVEL.trigger((EntityPlayerMP)player);
        ResearchManager.pushProgressToClientUnsafe((EntityPlayerMP)player);
        ResearchManager.savePlayerKnowledge((EntityPlayerMP)player);
        return true;
    }

    public static void forceMaximizeAll(EntityPlayer player) {
        PlayerProgress progress = ResearchManager.getProgress(player, Side.SERVER);
        if (!progress.isValid()) {
            return;
        }
        ProgressionTier before = progress.getTierReached();
        ResearchManager.discoverConstellations(ConstellationRegistry.getAllConstellations(), player);
        ResearchManager.maximizeTier(player);
        ResearchManager.forceMaximizeResearch(player);
        ResearchManager.setAttunedBefore(player, true);
        for (SextantFinder.TargetObject to : SextantFinder.getSelectableTargets()) {
            progress.useTarget(to);
        }
        if (progress.getTierReached().isThisLater(before)) {
            PktProgressionUpdate pkt = new PktProgressionUpdate(progress.getTierReached());
            PacketChannel.CHANNEL.sendTo((IMessage)pkt, (EntityPlayerMP)player);
        }
        ResearchManager.pushProgressToClientUnsafe((EntityPlayerMP)player);
        ResearchManager.savePlayerKnowledge((EntityPlayerMP)player);
    }

    public static boolean forceMaximizeResearch(EntityPlayer player) {
        PlayerProgress progress = ResearchManager.getProgress(player, Side.SERVER);
        if (!progress.isValid()) {
            return false;
        }
        for (ResearchProgression progression : ResearchProgression.values()) {
            progress.forceGainResearch(progression);
        }
        PktProgressionUpdate pkt = new PktProgressionUpdate();
        PacketChannel.CHANNEL.sendTo((IMessage)pkt, (EntityPlayerMP)player);
        ResearchManager.pushProgressToClientUnsafe((EntityPlayerMP)player);
        ResearchManager.savePlayerKnowledge((EntityPlayerMP)player);
        return true;
    }

    private static void pushProgressToClientUnsafe(EntityPlayerMP p) {
        PlayerProgress progress = playerProgressServer.get(p.func_110124_au());
        PktSyncKnowledge pkt = new PktSyncKnowledge(0);
        pkt.load(progress);
        PacketChannel.CHANNEL.sendTo((IMessage)pkt, p);
    }

    private static void wipeFile(EntityPlayerMP player) {
        ResearchManager.getPlayerFile((EntityPlayer)player).delete();
        ResearchIOThread.cancelSave(player.func_110124_au());
    }

    public static void savePlayerKnowledge(EntityPlayerMP p) {
        if (!MiscUtils.isPlayerFakeMP(p)) {
            ResearchManager.savePlayerKnowledge(p.func_110124_au(), false);
        }
    }

    private static void savePlayerKnowledge(UUID pUUID, boolean force) {
        if (playerProgressServer.get(pUUID) == null) {
            return;
        }
        PlayerProgress progress = playerProgressServer.get(pUUID);
        if (force) {
            ResearchIOThread.saveNow(pUUID, progress);
        } else {
            ResearchIOThread.saveProgress(pUUID, progress.copy());
        }
    }

    public static void loadPlayerKnowledge(EntityPlayerMP p) {
        if (!MiscUtils.isPlayerFakeMP(p)) {
            ResearchManager.loadPlayerKnowledge(p.func_110124_au());
        }
    }

    private static void loadPlayerKnowledge(UUID pUUID) {
        File playerFile = ResearchManager.getPlayerFile(pUUID);
        try {
            ResearchManager.load_unsafe(pUUID, playerFile);
        }
        catch (Exception e) {
            AstralSorcery.log.warn("Unable to load progress from default progress file. Attempting loading backup.");
            AstralSorcery.log.warn("Erroneous file: " + playerFile.getName());
            e.printStackTrace();
            playerFile = ResearchManager.getPlayerBackupFile(pUUID);
            try {
                ResearchManager.load_unsafe(pUUID, playerFile);
                Files.copy((File)playerFile, (File)ResearchManager.getPlayerFile(pUUID));
            }
            catch (Exception e1) {
                AstralSorcery.log.warn("Unable to load progress from backup progress file. Copying relevant files to error files.");
                AstralSorcery.log.warn("Erroneous file: " + playerFile.getName());
                e1.printStackTrace();
                File plOriginal = ResearchManager.getPlayerFile(pUUID);
                File plBackup = ResearchManager.getPlayerBackupFile(pUUID);
                try {
                    Files.copy((File)plOriginal, (File)new File(plOriginal.getParent(), plOriginal.getName() + ".lerror"));
                    Files.copy((File)plBackup, (File)new File(plBackup.getParent(), plBackup.getName() + ".lerror"));
                    AstralSorcery.log.warn("Copied progression files to error files. In case you would like to try me (HellFirePvP) to maybe see what i can do about maybe recovering the files,");
                    AstralSorcery.log.warn("send them over to me at the issue tracker https://github.com/HellFirePvP/AstralSorcery/issues - 90% that i won't be able to do anything, but reporting it would still be great.");
                }
                catch (IOException e2) {
                    AstralSorcery.log.warn("Unable to copy files to error-files.");
                    AstralSorcery.log.warn("I've had enough. I can't even access or open the files apparently. I'm giving up.");
                    e2.printStackTrace();
                }
                plOriginal.delete();
                plBackup.delete();
                ResearchManager.informPlayersAboutProgressionLoss(pUUID);
                ResearchManager.load_unsafeFromNBT(pUUID, null);
                ResearchManager.savePlayerKnowledge(pUUID, true);
            }
        }
    }

    private static void load_unsafe(UUID pUUID, File playerFile) throws Exception {
        NBTTagCompound compound = CompressedStreamTools.func_74797_a((File)playerFile);
        ResearchManager.load_unsafeFromNBT(pUUID, compound);
    }

    private static void load_unsafeFromNBT(UUID pUUID, @Nullable NBTTagCompound compound) {
        PlayerProgress progress = new PlayerProgress();
        if (compound != null && !compound.func_82582_d()) {
            progress.load(compound);
        }
        progress.forceGainResearch(ResearchProgression.DISCOVERY);
        playerProgressServer.put(pUUID, progress);
    }

    public static File getPlayerFile(EntityPlayer player) {
        return ResearchManager.getPlayerFile(player.func_110124_au());
    }

    public static File getPlayerFile(UUID pUUID) {
        File f = new File(ResearchManager.getPlayerDirectory(), pUUID.toString() + ".astral");
        if (!f.exists()) {
            try {
                CompressedStreamTools.func_74795_b((NBTTagCompound)new NBTTagCompound(), (File)f);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return f;
    }

    public static boolean doesPlayerFileExist(EntityPlayer player) {
        return new File(ResearchManager.getPlayerDirectory(), player.func_110124_au().toString() + ".astral").exists();
    }

    public static File getPlayerBackupFile(EntityPlayer player) {
        return ResearchManager.getPlayerBackupFile(player.func_110124_au());
    }

    public static File getPlayerBackupFile(UUID pUUID) {
        File f = new File(ResearchManager.getPlayerDirectory(), pUUID.toString() + ".astralback");
        if (!f.exists()) {
            try {
                CompressedStreamTools.func_74795_b((NBTTagCompound)new NBTTagCompound(), (File)f);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return f;
    }

    private static File getPlayerDirectory() {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        File worldDir = new File(server.field_71308_o, server.func_71270_I());
        File pDir = new File(worldDir, "playerdata");
        if (!pDir.exists()) {
            pDir.mkdirs();
        }
        return pDir;
    }

    public static void saveAndClearServerCache() {
        ResearchIOThread.saveAllPending();
        playerProgressServer.clear();
    }

    @SideOnly(value=Side.CLIENT)
    public static void recieveProgressFromServer(PktSyncKnowledge message, EntityPlayer player) {
        int currentLvl = clientProgress == null ? 0 : clientProgress.getPerkLevel(player);
        clientProgress = new PlayerProgress();
        clientProgress.receive(message);
        clientInitialized = true;
        if (clientProgress.getPerkLevel(player) > currentLvl) {
            ResearchManager.showBar();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void showBar() {
        ClientRenderEventHandler.requestPermChargeReveal(160);
    }

    public static void informCraftingGridCompletion(EntityPlayer player, ItemStack out) {
        Item iOut = out.func_77973_b();
        ResearchManager.informCraft(player, out, iOut, Block.func_149634_a((Item)iOut));
    }

    public static void informCraftingInfusionCompletion(TileStarlightInfuser infuser, ActiveInfusionTask recipe) {
        EntityPlayer crafter = recipe.tryGetCraftingPlayerServer();
        if (crafter == null) {
            AstralSorcery.log.warn("Infusion finished, player that initialized crafting could not be found!");
            AstralSorcery.log.warn("Affected tile: " + infuser.func_174877_v() + " in dim " + infuser.func_145831_w().field_73011_w.getDimension());
            return;
        }
        ItemStack out = recipe.getRecipeToCraft().getOutput(infuser);
        Item iOut = out.func_77973_b();
        ResearchManager.informCraft(crafter, out, iOut, Block.func_149634_a((Item)iOut));
    }

    public static void informCraftingAltarCompletion(TileAltar altar, ActiveCraftingTask recipeToCraft) {
        EntityPlayer crafter = recipeToCraft.tryGetCraftingPlayerServer();
        if (crafter == null || !(crafter instanceof EntityPlayerMP)) {
            AstralSorcery.log.warn("Crafting finished, player that initialized crafting could not be found!");
            AstralSorcery.log.warn("Affected tile: " + altar.func_174877_v() + " in dim " + altar.func_145831_w().field_73011_w.getDimension());
            return;
        }
        ItemStack out = recipeToCraft.getRecipeToCraft().getOutputForMatching();
        Item iOut = out.func_77973_b();
        ResearchManager.informCraft(crafter, out, iOut, Block.func_149634_a((Item)iOut));
        AdvancementTriggers.ALTAR_CRAFT.trigger((EntityPlayerMP)crafter, recipeToCraft.getRecipeToCraft());
    }

    private static void informCraft(EntityPlayer crafter, ItemStack crafted, Item itemCrafted, @Nullable Block iBlock) {
        if (iBlock != null && iBlock instanceof BlockAltar) {
            ResearchManager.giveProgressionIgnoreFail(crafter, ProgressionTier.BASIC_CRAFT);
            ResearchManager.giveResearchIgnoreFail(crafter, ResearchProgression.BASIC_CRAFT);
            TileAltar.AltarLevel to = TileAltar.AltarLevel.values()[crafted.func_77952_i()];
            switch (to) {
                case ATTUNEMENT: {
                    ResearchManager.giveProgressionIgnoreFail(crafter, ProgressionTier.ATTUNEMENT);
                    ResearchManager.giveResearchIgnoreFail(crafter, ResearchProgression.ATTUNEMENT);
                    break;
                }
                case CONSTELLATION_CRAFT: {
                    ResearchManager.giveProgressionIgnoreFail(crafter, ProgressionTier.CONSTELLATION_CRAFT);
                    ResearchManager.giveResearchIgnoreFail(crafter, ResearchProgression.CONSTELLATION);
                    break;
                }
                case TRAIT_CRAFT: {
                    ResearchManager.giveProgressionIgnoreFail(crafter, ProgressionTier.TRAIT_CRAFT);
                    ResearchManager.giveResearchIgnoreFail(crafter, ResearchProgression.RADIANCE);
                    break;
                }
                case BRILLIANCE: {
                    ResearchManager.giveProgressionIgnoreFail(crafter, ProgressionTier.BRILLIANCE);
                    ResearchManager.giveResearchIgnoreFail(crafter, ResearchProgression.BRILLIANCE);
                    break;
                }
            }
        }
    }

    private static void informPlayersAboutProgressionLoss(UUID pUUID) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server != null) {
            EntityPlayerMP player = server.func_184103_al().func_177451_a(pUUID);
            if (player != null) {
                player.func_145747_a(new TextComponentString("AstralSorcery: Your progression could not be loaded and can't be recovered from backup. Please contact an administrator to lookup what went wrong and/or potentially recover your data from a backup.").func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
            }
            String resolvedName = player != null ? player.func_70005_c_() : pUUID.toString() + " (Not online)";
            for (String opName : server.func_184103_al().func_152606_n()) {
                EntityPlayerMP pl = server.func_184103_al().func_152612_a(opName);
                if (pl == null) continue;
                pl.func_145747_a(new TextComponentString("AstralSorcery: The progression of " + resolvedName + " could not be loaded and can't be recovered from backup. Error files might be created from the unloadable progression files, check the console for additional information!").func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
            }
        }
    }
}

