/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data.fragment;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.client.gui.GuiJournalConstellationDetails;
import hellfirepvp.astralsorcery.client.gui.journal.GuiJournalPages;
import hellfirepvp.astralsorcery.client.gui.journal.GuiScreenJournal;
import hellfirepvp.astralsorcery.client.util.ClientConstellationGenerator;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.MoonPhase;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ProgressionTier;
import hellfirepvp.astralsorcery.common.data.research.ResearchNode;
import hellfirepvp.astralsorcery.common.data.research.ResearchProgression;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class KnowledgeFragment {
    private static final Predicate<PlayerProgress> TRUE = p -> true;
    private final ResourceLocation name;
    private String unlocPrefix;
    private Predicate<PlayerProgress> canSeeTest = TRUE;
    private Predicate<PlayerProgress> canDiscoverTest = TRUE;

    public KnowledgeFragment(ResourceLocation name, String unlocalizedPrefix) {
        this.name = name;
        this.unlocPrefix = unlocalizedPrefix;
    }

    public static KnowledgeFragment onConstellations(String name, IConstellation ... constellations) {
        return KnowledgeFragment.onConstellations(new ResourceLocation("astralsorcery", name), constellations);
    }

    public static KnowledgeFragment onConstellations(ResourceLocation name, IConstellation ... constellations) {
        final List<IConstellation> cst = Arrays.asList(constellations);
        IConstellation c = (IConstellation)Iterables.getFirst(cst, null);
        return new KnowledgeFragment(name, c == null ? "" : c.getTranslationKey()){

            @Override
            @SideOnly(value=Side.CLIENT)
            public boolean isVisible(GuiScreenJournal journalGui) {
                return journalGui instanceof GuiJournalConstellationDetails && MiscUtils.contains(cst, n -> n.equals(((GuiJournalConstellationDetails)journalGui).getConstellation()));
            }
        }.setCanSeeTest(prog -> {
            for (IConstellation con : cst) {
                if (!prog.hasConstellationDiscovered(con)) continue;
                return true;
            }
            return false;
        });
    }

    public static KnowledgeFragment onResearchNodes(String name, ResearchNode ... nodes) {
        return KnowledgeFragment.onResearchNodes(new ResourceLocation("astralsorcery", name), nodes);
    }

    private static KnowledgeFragment onResearchNodes(ResourceLocation name, ResearchNode ... nodes) {
        final List<ResearchNode> nds = Arrays.asList(nodes);
        ResearchNode nd = (ResearchNode)Iterables.getFirst(nds, null);
        return new KnowledgeFragment(name, nd == null ? "" : nd.getTranslationKey()){

            @Override
            @SideOnly(value=Side.CLIENT)
            public boolean isVisible(GuiScreenJournal journalGui) {
                return journalGui instanceof GuiJournalPages && MiscUtils.contains(nds, n -> n.equals(((GuiJournalPages)journalGui).getResearchNode()));
            }
        }.setCanSeeTest(prog -> {
            for (ResearchNode n : nds) {
                if (!n.canSee((PlayerProgress)prog)) continue;
                for (ResearchProgression rProg : ResearchProgression.findProgression(n)) {
                    if (!prog.getResearchProgression().contains((Object)rProg)) continue;
                    return true;
                }
            }
            return false;
        }).setCanDiscoverTest(prog -> {
            for (ResearchNode n : nds) {
                if (!n.canSee((PlayerProgress)prog)) {
                    return false;
                }
                for (ResearchProgression rProg : ResearchProgression.findProgression(n)) {
                    if (prog.getResearchProgression().contains((Object)rProg)) continue;
                    return false;
                }
            }
            return true;
        });
    }

    public KnowledgeFragment setCanSeeTest(Predicate<PlayerProgress> canSeeTest) {
        this.canSeeTest = canSeeTest;
        return this;
    }

    public KnowledgeFragment setCanDiscoverTest(Predicate<PlayerProgress> canDiscoverTest) {
        this.canDiscoverTest = canDiscoverTest;
        return this;
    }

    public static Predicate<PlayerProgress> hasTier(ProgressionTier tier) {
        return p -> p.getTierReached().isThisLaterOrEqual(tier);
    }

    public static Predicate<PlayerProgress> discoveredConstellation(IConstellation cst) {
        return p -> p.hasConstellationDiscovered(cst);
    }

    @SideOnly(value=Side.CLIENT)
    private boolean isConstellationGated(long seed) {
        return new Random(seed).nextInt(4) == 0;
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public IConstellation getDiscoverConstellation(long seed) {
        if (!this.isConstellationGated(seed)) {
            return null;
        }
        ClientConstellationGenerator.ClientConstellation cst = ClientConstellationGenerator.generateRandom(seed);
        cst.setFragment(this);
        return cst;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public List<MoonPhase> getShowupPhases(long seed) {
        if (!this.isConstellationGated(seed)) {
            return Lists.newArrayList();
        }
        Random r = new Random(seed);
        int amt = 2 + r.nextInt(2);
        ArrayList<MoonPhase> phases = new ArrayList<MoonPhase>(amt);
        for (int i = 0; i < amt; ++i) {
            MoonPhase phase;
            while (phases.contains((Object)(phase = MoonPhase.values()[r.nextInt(MoonPhase.values().length)]))) {
            }
            phases.add(phase);
        }
        return phases;
    }

    public boolean canSee(PlayerProgress progress) {
        return this.canSeeTest.test(progress);
    }

    public boolean canDiscover(PlayerProgress progress) {
        return this.canSeeTest.test(progress) && this.canDiscoverTest.test(progress);
    }

    @SideOnly(value=Side.CLIENT)
    public abstract boolean isVisible(GuiScreenJournal var1);

    public String getTranslationKey() {
        return String.format("%s.name", this.getLocalizationBaseString());
    }

    public String getUnlocalizedBookmark() {
        return String.format("%s.bookmark", this.getLocalizationBaseString());
    }

    public String getUnlocalizedPage() {
        return String.format("%s.description", this.getLocalizationBaseString());
    }

    private String getLocalizationBaseString() {
        return String.format("knowledge.%s.%s", this.name.func_110624_b(), this.name.func_110623_a());
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isFullyPresent() {
        return I18n.func_188566_a((String)this.getTranslationKey()) && I18n.func_188566_a((String)this.getUnlocalizedBookmark()) && I18n.func_188566_a((String)this.getUnlocalizedPage()) && (this.unlocPrefix.isEmpty() || I18n.func_188566_a((String)this.unlocPrefix));
    }

    @SideOnly(value=Side.CLIENT)
    public String getLocalizedName() {
        return I18n.func_135052_a((String)this.getTranslationKey(), (Object[])new Object[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public String getLocalizedBookmark() {
        return I18n.func_135052_a((String)this.getUnlocalizedBookmark(), (Object[])new Object[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public String getLocalizedPage() {
        return I18n.func_135052_a((String)this.getUnlocalizedPage(), (Object[])new Object[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public String getLocalizedIndexName() {
        return this.unlocPrefix.isEmpty() ? this.getLocalizedName() : String.format("%s: %s", I18n.func_135052_a((String)this.unlocPrefix, (Object[])new Object[0]), this.getLocalizedName());
    }

    public ResourceLocation getRegistryName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KnowledgeFragment that = (KnowledgeFragment)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name.toString());
    }
}

