/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.infusion;

import hellfirepvp.astralsorcery.common.crafting.infusion.AbstractInfusionRecipe;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.tile.TileChalice;
import hellfirepvp.astralsorcery.common.tile.TileStarlightInfuser;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ActiveInfusionTask {
    private final AbstractInfusionRecipe recipeToCraft;
    private final UUID playerCraftingUUID;
    private int ticksCrafting = 0;
    private List<TileChalice> supportingChalices = new LinkedList<TileChalice>();
    private List<BlockPos> pendingChalicePositions = new LinkedList<BlockPos>();

    public ActiveInfusionTask(AbstractInfusionRecipe recipeToCraft, UUID playerCraftingUUID) {
        this.recipeToCraft = recipeToCraft;
        this.playerCraftingUUID = playerCraftingUUID;
    }

    public void addChalices(List<TileChalice> chaliceList) {
        this.supportingChalices.addAll(chaliceList);
    }

    public int getChaliceRequiredAmount() {
        return this.recipeToCraft.doesConsumeMultiple() ? MathHelper.func_76141_d((float)(this.recipeToCraft.getLiquidStarlightConsumptionChance() * 400.0f * 12.0f)) : MathHelper.func_76141_d((float)(this.recipeToCraft.getLiquidStarlightConsumptionChance() * 400.0f));
    }

    public UUID getPlayerCraftingUUID() {
        return this.playerCraftingUUID;
    }

    @Nullable
    public EntityPlayer tryGetCraftingPlayerServer() {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(this.playerCraftingUUID);
    }

    public boolean tick(TileStarlightInfuser infuser) {
        ++this.ticksCrafting;
        boolean change = this.pendingChalicePositions.size() > 0;
        for (BlockPos bp : this.pendingChalicePositions) {
            TileChalice test = MiscUtils.getTileAt((IBlockAccess)infuser.func_145831_w(), bp, TileChalice.class, true);
            if (test == null) continue;
            this.supportingChalices.add(test);
        }
        this.pendingChalicePositions.clear();
        FluidStack fl = new FluidStack(BlocksAS.fluidLiquidStarlight, this.getChaliceRequiredAmount());
        Iterator<TileChalice> iterator = this.supportingChalices.iterator();
        while (iterator.hasNext()) {
            TileChalice tc = iterator.next();
            if (tc.func_145837_r()) {
                iterator.remove();
                change = true;
                continue;
            }
            TileChalice test = MiscUtils.getTileAt((IBlockAccess)infuser.func_145831_w(), tc.func_174877_v(), TileChalice.class, true);
            if (test != null && test.getTank() != null && test.getTank().getFluid() != null && test.getTank().getFluid().containsFluid(fl)) continue;
            iterator.remove();
            change = true;
        }
        return change;
    }

    public int getTicksCrafting() {
        return this.ticksCrafting;
    }

    public AbstractInfusionRecipe getRecipeToCraft() {
        return this.recipeToCraft;
    }

    public List<TileChalice> getSupportingChalices() {
        return this.supportingChalices;
    }

    @SideOnly(value=Side.CLIENT)
    public List<BlockPos> getPendingChalicePositions() {
        return this.pendingChalicePositions;
    }

    public void addPendingChalicePositions(List<BlockPos> chaliceList) {
        this.pendingChalicePositions.addAll(chaliceList);
    }

    public boolean isFinished() {
        return (float)this.ticksCrafting >= (float)this.recipeToCraft.craftingTickTime() * (this.recipeToCraft.canBeSupportedByChalice() && !this.supportingChalices.isEmpty() ? 0.3f : 1.0f);
    }

    public void forceTick(int tick) {
        this.ticksCrafting = tick;
    }
}

