/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.starmap;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.common.constellation.ConstellationRegistry;
import hellfirepvp.astralsorcery.common.constellation.DrawnConstellation;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.starmap.ConstellationMapEffectRegistry;
import hellfirepvp.astralsorcery.common.registry.RegistryPotions;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemBook;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.math.MathHelper;

public class ActiveStarMap {
    private static final Random rand = new Random();
    private Map<IConstellation, Float> starProportions = new HashMap<IConstellation, Float>();
    private Map<IConstellation, List<Point>> mapOffsets = new HashMap<IConstellation, List<Point>>();

    public static ActiveStarMap compile(List<DrawnConstellation> constellations) {
        ActiveStarMap asm = new ActiveStarMap();
        Collections.reverse(constellations);
        LinkedList<Rectangle> usedSpace = new LinkedList<Rectangle>();
        int maxSize = 2500;
        for (DrawnConstellation c : constellations) {
            Rectangle r;
            Point point = c.point;
            Rectangle used = new Rectangle(point.x - 25, point.y - 25, 50, 50);
            LinkedList<Rectangle> intersecting = new LinkedList<Rectangle>();
            for (Rectangle other : usedSpace) {
                r = used.intersection(other);
                if (r.isEmpty()) continue;
                intersecting.add(r);
            }
            usedSpace.add(used);
            int intersectingSize = 0;
            for (int i = 0; i < intersecting.size(); ++i) {
                r = (Rectangle)intersecting.get(i);
                intersectingSize += r.width * r.height;
                for (int j = i; j < intersecting.size(); ++j) {
                    Rectangle ir;
                    Rectangle r2 = (Rectangle)intersecting.get(j);
                    if (r2.equals(r) || (ir = r.intersection(r2)).isEmpty()) continue;
                    intersectingSize -= ir.width * ir.height;
                }
            }
            float perc = 1.0f - (float)intersectingSize / (float)maxSize;
            if (asm.starProportions.containsKey(c.constellation)) {
                asm.starProportions.put(c.constellation, Float.valueOf(asm.starProportions.get(c.constellation).floatValue() + perc));
                continue;
            }
            asm.starProportions.put(c.constellation, Float.valueOf(perc));
        }
        HashMap<IConstellation, Float> multipliers = new HashMap<IConstellation, Float>();
        for (IConstellation iConstellation : asm.starProportions.keySet()) {
            int count = 0;
            for (DrawnConstellation dc : constellations) {
                if (!dc.constellation.equals(iConstellation)) continue;
                ++count;
            }
            if (count <= true) continue;
            multipliers.put(iConstellation, Float.valueOf(count));
        }
        for (IConstellation iConstellation : multipliers.keySet()) {
            asm.starProportions.put(iConstellation, Float.valueOf(asm.starProportions.get(iConstellation).floatValue() / ((Float)multipliers.get(iConstellation)).floatValue()));
        }
        for (DrawnConstellation drawnConstellation : constellations) {
            if (asm.mapOffsets.containsKey(drawnConstellation.constellation)) {
                asm.mapOffsets.get(drawnConstellation.constellation).add(drawnConstellation.point);
                continue;
            }
            asm.mapOffsets.put(drawnConstellation.constellation, Lists.newArrayList((Object[])new Point[]{drawnConstellation.point}));
        }
        ActiveStarMap.shiftDistribution(asm);
        return asm;
    }

    private static void shiftDistribution(ActiveStarMap asm) {
        float perc;
        HashMap<IConstellation, Float> out = new HashMap<IConstellation, Float>();
        for (Map.Entry<IConstellation, Float> entry : asm.starProportions.entrySet()) {
            perc = entry.getValue().floatValue();
            if ((perc = MathHelper.func_76131_a((float)perc, (float)0.0f, (float)1.0f)) >= 0.75f) {
                perc = perc * 3.0f - 2.25f;
                perc *= perc;
                perc = -perc + 1.0f;
            } else {
                perc = perc * 1.3333334f - 1.0f;
                perc *= perc;
                perc = -perc + 1.0f;
            }
            out.put(entry.getKey(), Float.valueOf(perc));
        }
        asm.starProportions = out;
        out = new HashMap();
        for (Map.Entry<IConstellation, Float> entry : asm.starProportions.entrySet()) {
            perc = entry.getValue().floatValue();
            out.put(entry.getKey(), Float.valueOf(MathHelper.func_76129_c((float)perc)));
        }
        asm.starProportions = out;
    }

    public boolean tryApplyEnchantments(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        HashMap effectMap = new HashMap();
        for (IConstellation c : this.starProportions.keySet()) {
            ConstellationMapEffectRegistry.MapEffect e = ConstellationMapEffectRegistry.getEffects(c);
            if (e == null) continue;
            LinkedList<ConstellationMapEffectRegistry.EnchantmentMapEffect> applicable = new LinkedList<ConstellationMapEffectRegistry.EnchantmentMapEffect>();
            for (ConstellationMapEffectRegistry.EnchantmentMapEffect enchEffect : e.enchantmentEffects) {
                Enchantment ench = enchEffect.ench;
                if ((!(stack.func_77973_b() instanceof ItemBook) && !(stack.func_77973_b() instanceof ItemEnchantedBook) || !ench.isAllowedOnBooks()) && !ench.func_92089_a(stack)) continue;
                applicable.add(enchEffect);
            }
            effectMap.put(c, applicable);
        }
        if (effectMap.isEmpty()) {
            return false;
        }
        boolean appliedSomething = false;
        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack);
        block2: for (Map.Entry entry : effectMap.entrySet()) {
            for (ConstellationMapEffectRegistry.EnchantmentMapEffect effect : (List)entry.getValue()) {
                Float perc;
                if (enchantments.containsKey(effect.ench)) continue;
                if (!effect.ignoreCompaibility) {
                    for (Enchantment existing : enchantments.keySet()) {
                        if (existing.func_191560_c(effect.ench)) continue;
                        continue block2;
                    }
                }
                if ((perc = this.starProportions.get(entry.getKey())) == null) continue;
                float p = MathHelper.func_76131_a((float)perc.floatValue(), (float)0.0f, (float)1.0f);
                int lvl = effect.minEnchLevel + Math.round((float)(effect.maxEnchLevel - effect.minEnchLevel) * p);
                if (stack.func_77973_b() instanceof ItemEnchantedBook) {
                    ItemEnchantedBook cfr_ignored_0 = (ItemEnchantedBook)stack.func_77973_b();
                    ItemEnchantedBook.func_92115_a((ItemStack)stack, (EnchantmentData)new EnchantmentData(effect.ench, lvl));
                } else {
                    stack.func_77966_a(effect.ench, lvl);
                }
                enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack);
                appliedSomething = true;
            }
        }
        return appliedSomething;
    }

    public void tryApplyPotionEffects(ItemStack stack) {
        if (stack.func_190926_b()) {
            return;
        }
        LinkedList<PotionEffect> applicableEffects = new LinkedList<PotionEffect>();
        for (IConstellation c : this.starProportions.keySet()) {
            ConstellationMapEffectRegistry.MapEffect me = ConstellationMapEffectRegistry.getEffects(c);
            if (me == null) continue;
            for (ConstellationMapEffectRegistry.PotionMapEffect effect : me.potionEffects) {
                float perc = this.starProportions.get(c).floatValue();
                perc = MathHelper.func_76131_a((float)perc, (float)0.0f, (float)1.0f);
                int amp = effect.minPotionAmplifier + Math.round((float)(effect.maxPotionAmplifier - effect.minPotionAmplifier) * perc);
                int tDuration = 4800 + Math.round(rand.nextFloat() * 2.0f * 1200.0f);
                PotionEffect eff = MiscUtils.iterativeSearch(applicableEffects, pe -> pe.func_188419_a().equals(effect.potion));
                if (eff != null) {
                    if (eff.func_76458_c() >= amp) continue;
                    applicableEffects.remove(eff);
                    applicableEffects.add(new PotionEffect(effect.potion, tDuration, amp, false, true));
                    continue;
                }
                applicableEffects.add(new PotionEffect(effect.potion, tDuration, amp, false, true));
            }
        }
        if (rand.nextInt(30) == 0) {
            applicableEffects.add(new PotionEffect((Potion)RegistryPotions.potionCheatDeath, 2400 + Math.round(rand.nextFloat() * 6.0f * 1200.0f), 0, false, true));
        }
        stack.func_190924_f("potion.as.crafted.name");
        Collections.shuffle(applicableEffects);
        PotionUtils.func_185184_a((ItemStack)stack, applicableEffects);
    }

    public Collection<IConstellation> getConstellations() {
        return Collections.unmodifiableCollection(this.starProportions.keySet());
    }

    public Map<IConstellation, List<Point>> getMapOffsets() {
        return Collections.unmodifiableMap(this.mapOffsets);
    }

    public float getPercentage(IConstellation c) {
        if (!this.starProportions.containsKey(c)) {
            return 0.0f;
        }
        return this.starProportions.get(c).floatValue();
    }

    public NBTTagCompound serialize() {
        NBTTagCompound c;
        NBTTagCompound cmp = new NBTTagCompound();
        NBTTagList l = new NBTTagList();
        for (Map.Entry<IConstellation, Float> entry : this.starProportions.entrySet()) {
            c = new NBTTagCompound();
            c.func_74778_a("cst", entry.getKey().getTranslationKey());
            c.func_74776_a("perc", entry.getValue().floatValue());
            l.func_74742_a((NBTBase)c);
        }
        cmp.func_74782_a("starMap", (NBTBase)l);
        l = new NBTTagList();
        for (Map.Entry<IConstellation, Object> entry : this.mapOffsets.entrySet()) {
            c = new NBTTagCompound();
            c.func_74778_a("cst", entry.getKey().getTranslationKey());
            NBTTagList posList = new NBTTagList();
            for (Point p : (List)entry.getValue()) {
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74768_a("x", p.x);
                tag.func_74768_a("y", p.y);
                posList.func_74742_a((NBTBase)tag);
            }
            c.func_74782_a("posList", (NBTBase)posList);
            l.func_74742_a((NBTBase)c);
        }
        cmp.func_74782_a("offsetMap", (NBTBase)l);
        return cmp;
    }

    public static ActiveStarMap deserialize(NBTTagCompound cmp) {
        IConstellation cst;
        String str;
        NBTTagCompound c;
        int i;
        ActiveStarMap map = new ActiveStarMap();
        NBTTagList list = cmp.func_150295_c("starMap", 10);
        for (i = 0; i < list.func_74745_c(); ++i) {
            c = list.func_150305_b(i);
            str = c.func_74779_i("cst");
            cst = ConstellationRegistry.getConstellationByName(str);
            if (cst == null) continue;
            float perc = c.func_74760_g("perc");
            map.starProportions.put(cst, Float.valueOf(perc));
        }
        list = cmp.func_150295_c("offsetMap", 10);
        for (i = 0; i < list.func_74745_c(); ++i) {
            c = list.func_150305_b(i);
            str = c.func_74779_i("cst");
            cst = ConstellationRegistry.getConstellationByName(str);
            if (cst == null) continue;
            NBTTagList posList = c.func_150295_c("posList", 10);
            ArrayList positions = Lists.newArrayList();
            for (int j = 0; j < posList.func_74745_c(); ++j) {
                NBTTagCompound tag = posList.func_150305_b(j);
                positions.add(new Point(tag.func_74762_e("x"), tag.func_74762_e("y")));
            }
            map.mapOffsets.put(cst, positions);
        }
        return map;
    }
}

