/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.perk.tree;

import hellfirepvp.astralsorcery.client.gui.perk.BatchPerkContext;
import hellfirepvp.astralsorcery.client.gui.perk.DynamicPerkRender;
import hellfirepvp.astralsorcery.client.gui.perk.PerkRenderGroup;
import hellfirepvp.astralsorcery.client.gui.perk.group.PerkPointHaloRenderGroup;
import hellfirepvp.astralsorcery.client.util.BufferBatch;
import hellfirepvp.astralsorcery.client.util.RenderConstellation;
import hellfirepvp.astralsorcery.client.util.resource.SpriteSheetResource;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.perk.AbstractPerk;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.PerkTreePoint;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.util.data.Tuple;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PerkTreePointConstellation<T extends AbstractPerk>
extends PerkTreePoint<T>
implements DynamicPerkRender {
    public static final int ROOT_SPRITE_SIZE = 50;
    public static final int MINOR_SPRITE_SIZE = 40;
    private final IConstellation associatedConstellation;
    private final int perkSpriteSize;

    public PerkTreePointConstellation(T perk, Point offset, IConstellation associatedConstellation, int perkSpriteSize) {
        super(perk, offset);
        this.associatedConstellation = associatedConstellation;
        this.perkSpriteSize = perkSpriteSize;
        this.setRenderSize(perkSpriteSize / 2);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addGroups(Collection<PerkRenderGroup> groups) {
        super.addGroups(groups);
        groups.add(PerkPointHaloRenderGroup.INSTANCE);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderAt(PerkTreePoint.AllocationStatus status, long spriteOffsetTick, float pTicks, double x, double y, double scale) {
        if (this.associatedConstellation != null) {
            PlayerProgress prog = ResearchManager.getProgress((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Side.CLIENT);
            if (!prog.getKnownConstellations().contains(this.associatedConstellation.getTranslationKey())) {
                return;
            }
            Color overlay = Color.WHITE;
            switch (status) {
                case UNALLOCATED: {
                    overlay = new Color(0x3333FF);
                    break;
                }
                case ALLOCATED: {
                    overlay = new Color(0xEEEE00);
                    break;
                }
                case UNLOCKABLE: {
                    overlay = new Color(13181149);
                    break;
                }
            }
            int size = MathHelper.func_76128_c((double)((double)this.perkSpriteSize * 0.85 * scale));
            int fX = (int)Math.round(x);
            int fY = (int)Math.round(y);
            RenderConstellation.renderConstellationIntoGUI(overlay, this.associatedConstellation, fX - size, fY - size, 0.0f, size * 2, size * 2, 1.5 * scale, new RenderConstellation.BrightnessFunction(){

                @Override
                public float getBrightness() {
                    return 0.75f;
                }
            }, true, false);
        }
    }

    @Override
    @Nullable
    @SideOnly(value=Side.CLIENT)
    public Rectangle2D.Double renderPerkAtBatch(BatchPerkContext drawCtx, PerkTreePoint.AllocationStatus status, long spriteOffsetTick, float pTicks, double x, double y, double scale) {
        SpriteSheetResource tex = this.getHaloSprite(status);
        BatchPerkContext.TextureObjectGroup grp = PerkPointHaloRenderGroup.INSTANCE.getGroup(tex);
        if (grp == null) {
            return new Rectangle2D.Double();
        }
        BufferBatch buf = drawCtx.getContext(grp);
        BufferBuilder vb = buf.getBuffer();
        double haloSize = (double)this.perkSpriteSize * scale;
        if (status == PerkTreePoint.AllocationStatus.ALLOCATED) {
            haloSize *= 1.3;
        }
        Vector3 starVec = new Vector3(x - haloSize, y - haloSize, 0.0);
        double uLength = tex.getULength();
        double vLength = tex.getVLength();
        Tuple<Double, Double> frameUV = tex.getUVOffset(spriteOffsetTick);
        for (int i = 0; i < 4; ++i) {
            int u = (i + 1 & 2) >> 1;
            int v = (i + 2 & 2) >> 1;
            Vector3 pos = starVec.clone().addX(haloSize * (double)u * 2.0).addY(haloSize * (double)v * 2.0);
            vb.func_181662_b(pos.getX(), pos.getY(), pos.getZ()).func_187315_a((Double)frameUV.key + uLength * (double)u, (Double)frameUV.value + vLength * (double)v).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        }
        super.renderPerkAtBatch(drawCtx, status, spriteOffsetTick, pTicks, x, y, scale);
        double actualSize = (double)this.perkSpriteSize * scale;
        return new Rectangle2D.Double(-actualSize, -actualSize, actualSize * 2.0, actualSize * 2.0);
    }
}

