/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.perk.reader.impl;

import hellfirepvp.astralsorcery.common.constellation.perk.PlayerAttributeMap;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.AttributeTypeLimiter;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.AttributeTypeRegistry;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.PerkAttributeModifier;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.PerkAttributeType;
import hellfirepvp.astralsorcery.common.constellation.perk.reader.AttributeReader;
import hellfirepvp.astralsorcery.common.constellation.perk.reader.PerkStatistic;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.event.AttributeEvent;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class VanillaAttributeReader
extends AttributeReader {
    protected IAttribute attribute;
    protected PerkAttributeType perkAttrType;
    protected boolean formatAsDecimal = false;

    public VanillaAttributeReader(IAttribute attribute) {
        this.attribute = attribute;
        this.perkAttrType = AttributeTypeRegistry.findType(this.attribute);
        if (this.perkAttrType == null) {
            throw new IllegalArgumentException("Cannot create reader for unknown vanilla type attribute!");
        }
    }

    public <T extends VanillaAttributeReader> T formatAsDecimal() {
        this.formatAsDecimal = true;
        return (T)this;
    }

    @Override
    public double getDefaultValue(PlayerAttributeMap statMap, EntityPlayer player, Side side) {
        return player.func_110148_a(this.attribute).func_111125_b();
    }

    @Override
    public double getModifierValueForMode(PlayerAttributeMap statMap, EntityPlayer player, Side side, PerkAttributeModifier.Mode mode) {
        return statMap.getModifier(player, ResearchManager.getProgress(player, side), this.perkAttrType.getTypeString(), mode);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public PerkStatistic getStatistics(PlayerAttributeMap statMap, EntityPlayer player) {
        Float limit = AttributeTypeLimiter.INSTANCE.getMaxLimit(this.perkAttrType);
        String limitStr = limit == null ? "" : I18n.func_135052_a((String)"perk.reader.limit.default", (Object[])new Object[]{VanillaAttributeReader.formatDecimal(limit.floatValue())});
        double value = this.getDefaultValue(statMap, player, Side.CLIENT);
        value = statMap.modifyValue(player, ResearchManager.getProgress(player, Side.CLIENT), this.perkAttrType.getTypeString(), (float)value);
        String postProcess = "";
        double post = AttributeEvent.postProcessVanilla(value, (ModifiableAttributeInstance)player.func_110148_a(this.attribute));
        if (Math.abs(value - post) > 1.0E-4 && (limit == null || Math.abs(post - (double)limit.floatValue()) > 1.0E-4)) {
            if (Math.abs(post) >= 1.0E-4) {
                postProcess = I18n.func_135052_a((String)"perk.reader.postprocess.default", (Object[])new Object[]{this.formatForDisplay(post)});
            }
            value = post;
        }
        return new PerkStatistic(this.perkAttrType, this.formatForDisplay(value), limitStr, postProcess);
    }

    protected String formatForDisplay(double value) {
        String valueStr = this.formatAsDecimal ? VanillaAttributeReader.formatDecimal(value) : String.valueOf(MathHelper.func_76128_c((double)value));
        return valueStr;
    }
}

