/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.perk.attribute;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.PerkAttributeModifier;
import hellfirepvp.astralsorcery.common.constellation.perk.reader.AttributeReader;
import hellfirepvp.astralsorcery.common.constellation.perk.reader.AttributeReaderRegistry;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;

public class PerkAttributeType {
    protected static final Random rand = new Random();
    private Map<Side, List<UUID>> applicationCache = Maps.newHashMap();
    private final String type;
    private final boolean isOnlyMultiplicative;

    public PerkAttributeType(String type) {
        this(type, false);
    }

    public PerkAttributeType(String type, boolean isOnlyMultiplicative) {
        this.type = type;
        this.isOnlyMultiplicative = isOnlyMultiplicative;
    }

    public String getTypeString() {
        return this.type;
    }

    public boolean isMultiplicative() {
        return this.isOnlyMultiplicative;
    }

    public String getTranslationKey() {
        return String.format("perk.attribute.%s.name", this.getTypeString());
    }

    protected void init() {
    }

    @Nullable
    public AttributeReader getReader() {
        return AttributeReaderRegistry.getReader(this.getTypeString());
    }

    @Nonnull
    public PerkAttributeModifier createModifier(float modifier, PerkAttributeModifier.Mode mode) {
        if (this.isMultiplicative() && mode == PerkAttributeModifier.Mode.ADDITION) {
            throw new IllegalArgumentException("Tried creating addition-modifier for a multiplicative-only modifier!");
        }
        return new PerkAttributeModifier(this.getTypeString(), mode, modifier);
    }

    public void onApply(EntityPlayer player, Side side) {
        List applied = this.applicationCache.computeIfAbsent(side, s -> Lists.newArrayList());
        if (!applied.contains(player.func_110124_au())) {
            applied.add(player.func_110124_au());
        }
    }

    public void onRemove(EntityPlayer player, Side side, boolean removedCompletely) {
        if (removedCompletely) {
            this.applicationCache.computeIfAbsent(side, s -> Lists.newArrayList()).remove(player.func_110124_au());
        }
    }

    public void onModeApply(EntityPlayer player, PerkAttributeModifier.Mode mode, Side side) {
    }

    public void onModeRemove(EntityPlayer player, PerkAttributeModifier.Mode mode, Side side, boolean removedCompletely) {
    }

    public boolean hasTypeApplied(EntityPlayer player, Side side) {
        return this.applicationCache.computeIfAbsent(side, s -> Lists.newArrayList()).contains(player.func_110124_au());
    }

    public final void clear(Side side) {
        this.applicationCache.remove(side);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PerkAttributeType that = (PerkAttributeType)o;
        return Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.type);
    }
}

