/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.perk.attribute;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import hellfirepvp.astralsorcery.common.constellation.perk.PerkConverter;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.AttributeTypeRegistry;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.PerkAttributeType;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PerkAttributeModifier {
    private static long counter = 0L;
    private long id;
    protected final Mode mode;
    protected final String attributeType;
    protected float value;
    private boolean absolute = false;
    protected double ctMultiplier = 1.0;
    private Map<PerkConverter, Table<String, Mode, PerkAttributeModifier>> cachedConverters = Maps.newHashMap();

    public PerkAttributeModifier(String type, Mode mode, float value) {
        this.id = counter++;
        this.attributeType = type;
        this.mode = mode;
        this.value = value;
        this.initModifier();
    }

    public long getId() {
        return this.id;
    }

    protected void setId(long id) {
        this.id = id;
    }

    protected void initModifier() {
    }

    protected void setAbsolute() {
        this.absolute = true;
    }

    void multiplyValue(double multiplier) {
        this.ctMultiplier = multiplier;
        this.value = this.mode == Mode.STACKING_MULTIPLY ? (this.value - 1.0f) * (float)multiplier + 1.0f : (float)((double)this.value * multiplier);
    }

    @Nonnull
    public PerkAttributeModifier convertModifier(String attributeType, Mode mode, float value) {
        if (this.absolute) {
            return this;
        }
        PerkAttributeType type = AttributeTypeRegistry.getType(attributeType);
        PerkAttributeModifier mod = this.createModifier(type, attributeType, mode, value);
        mod.setId(this.id);
        return mod;
    }

    @Nonnull
    public PerkAttributeModifier gainAsExtraModifier(PerkConverter converter, String attributeType, Mode mode, float value) {
        PerkAttributeModifier modifier = this.getCachedAttributeModifier(converter, attributeType, mode);
        if (modifier == null) {
            modifier = this.createModifier(AttributeTypeRegistry.getType(attributeType), attributeType, mode, value);
            modifier.setAbsolute();
            this.addModifierToCache(converter, attributeType, mode, modifier);
        }
        return modifier;
    }

    @Nullable
    protected PerkAttributeModifier getCachedAttributeModifier(PerkConverter converter, String attributeType, Mode mode) {
        Table cachedModifiers = this.cachedConverters.computeIfAbsent(converter, c -> HashBasedTable.create());
        return (PerkAttributeModifier)cachedModifiers.get((Object)attributeType, (Object)mode);
    }

    protected void addModifierToCache(PerkConverter converter, String attributeType, Mode mode, PerkAttributeModifier modifier) {
        Table cachedModifiers = this.cachedConverters.computeIfAbsent(converter, c -> HashBasedTable.create());
        cachedModifiers.put((Object)attributeType, (Object)mode, (Object)modifier);
    }

    @Nonnull
    protected PerkAttributeModifier createModifier(@Nullable PerkAttributeType type, String attributeType, Mode mode, float value) {
        if (type != null) {
            return type.createModifier(value, mode);
        }
        return new PerkAttributeModifier(attributeType, mode, value);
    }

    @Deprecated
    public final float getFlatValue() {
        return this.value;
    }

    public float getValue(EntityPlayer player, PlayerProgress progress) {
        return this.getFlatValue();
    }

    @SideOnly(value=Side.CLIENT)
    public float getValueForDisplay(EntityPlayer player, PlayerProgress progress) {
        return this.getValue(player, progress);
    }

    public Mode getMode() {
        return this.mode;
    }

    public String getAttributeType() {
        return this.attributeType;
    }

    @Nullable
    public PerkAttributeType resolveType() {
        return AttributeTypeRegistry.getType(this.attributeType);
    }

    protected String getUnlocalizedAttributeName() {
        PerkAttributeType type = this.resolveType();
        if (type != null) {
            return type.getTranslationKey();
        }
        return "???";
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasDisplayString() {
        PerkAttributeType type = this.resolveType();
        if (type != null) {
            return I18n.func_188566_a((String)type.getTranslationKey());
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public String getLocalizedAttributeValue() {
        return this.getMode().stringifyValue(this.getValueForDisplay((EntityPlayer)Minecraft.func_71410_x().field_71439_g, ResearchManager.clientProgress));
    }

    @SideOnly(value=Side.CLIENT)
    public String getLocalizedModifierName() {
        return I18n.func_135052_a((String)this.getMode().getUnlocalizedModifierName(this.getValueForDisplay((EntityPlayer)Minecraft.func_71410_x().field_71439_g, ResearchManager.clientProgress)), (Object[])new Object[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public String getAttributeDisplayFormat() {
        return I18n.func_135052_a((String)"perk.modifier.format", (Object[])new Object[0]);
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public String getLocalizedDisplayString() {
        if (!this.hasDisplayString()) {
            return null;
        }
        return String.format(this.getAttributeDisplayFormat(), this.getLocalizedAttributeValue(), this.getLocalizedModifierName(), I18n.func_135052_a((String)this.getUnlocalizedAttributeName(), (Object[])new Object[0]));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PerkAttributeModifier that = (PerkAttributeModifier)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    public static enum Mode {
        ADDITION,
        ADDED_MULTIPLY,
        STACKING_MULTIPLY;


        public static Mode fromVanillaAttributeOperation(int op) {
            return Mode.values()[MathHelper.func_76125_a((int)op, (int)0, (int)(Mode.values().length - 1))];
        }

        public int getVanillaAttributeOperation() {
            return this.ordinal();
        }

        public String stringifyValue(float number) {
            if (this == ADDITION) {
                String str = Integer.toString(Math.round(number));
                if (number > 0.0f) {
                    str = "+" + str;
                }
                return str;
            }
            int nbr = Math.round(number * 100.0f);
            return Integer.toString(Math.abs(this == STACKING_MULTIPLY ? 100 - nbr : nbr));
        }

        public String getUnlocalizedModifierName(float number) {
            boolean positive;
            if (this == ADDITION) {
                positive = number > 0.0f;
            } else {
                int nbr = Math.round(number * 100.0f);
                positive = this == STACKING_MULTIPLY ? nbr > 100 : nbr > 0;
            }
            return this.getUnlocalizedModifierName(positive);
        }

        public String getUnlocalizedModifierName(boolean positive) {
            String base = positive ? "perk.modifier.%s.add" : "perk.modifier.%s.sub";
            return String.format(base, this.name().toLowerCase());
        }
    }
}

